/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.function.ThrowableAction;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MappingChangedEvent;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.client.EventPublishingServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscoveryFactory;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.client.metadata.SubscribedURLsSynthesizer;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;

public class ServiceDiscoveryRegistry
implements Registry {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServiceDiscovery serviceDiscovery;
    private final Set<String> subscribedServices;
    private final ServiceNameMapping serviceNameMapping;
    private final WritableMetadataService writableMetadataService;
    private final Set<String> registeredListeners = new LinkedHashSet<String>();
    private final Map<String, ServiceInstancesChangedListener> serviceListeners = new HashMap<String, ServiceInstancesChangedListener>();
    private URL registryURL;
    private final Map<String, Map<String, List<URL>>> serviceRevisionExportedURLsCache = new LinkedHashMap<String, Map<String, List<URL>>>();

    public ServiceDiscoveryRegistry(URL registryURL) {
        this.registryURL = registryURL;
        this.serviceDiscovery = this.createServiceDiscovery(registryURL);
        this.subscribedServices = ServiceDiscoveryRegistry.parseServices(registryURL.getParameter("subscribed-services"));
        this.serviceNameMapping = ServiceNameMapping.getExtension(registryURL.getParameter("mapping-type"));
        this.writableMetadataService = WritableMetadataService.getDefaultExtension();
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    protected ServiceDiscovery createServiceDiscovery(URL registryURL) {
        ServiceDiscovery originalServiceDiscovery = this.getServiceDiscovery(registryURL);
        ServiceDiscovery serviceDiscovery = this.enhanceEventPublishing(originalServiceDiscovery);
        ThrowableAction.execute(() -> serviceDiscovery.initialize(registryURL.addParameter("interface", ServiceDiscovery.class.getName()).removeParameter("registry-type")));
        return serviceDiscovery;
    }

    private List<SubscribedURLsSynthesizer> initSubscribedURLsSynthesizers() {
        ExtensionLoader<SubscribedURLsSynthesizer> loader = ExtensionLoader.getExtensionLoader(SubscribedURLsSynthesizer.class);
        return Collections.unmodifiableList(new ArrayList<SubscribedURLsSynthesizer>(loader.getSupportedExtensionInstances()));
    }

    private ServiceDiscovery getServiceDiscovery(URL registryURL) {
        ServiceDiscoveryFactory factory = ServiceDiscoveryFactory.getExtension(registryURL);
        return factory.getServiceDiscovery(registryURL);
    }

    private ServiceDiscovery enhanceEventPublishing(ServiceDiscovery original) {
        return new EventPublishingServiceDiscovery(original);
    }

    protected boolean shouldRegister(URL providerURL) {
        String side = providerURL.getParameter("side");
        boolean should = "provider".equals(side);
        if (!should && this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("The URL[%s] should not be registered.", providerURL.toString()));
        }
        return should;
    }

    protected boolean shouldSubscribe(URL subscribedURL) {
        return !this.shouldRegister(subscribedURL);
    }

    @Override
    public final void register(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        this.doRegister(url);
    }

    public void doRegister(URL url) {
        String registryCluster = this.serviceDiscovery.getUrl().getParameter("id");
        if (registryCluster != null && url.getParameter("REGISTRY_CLUSTER") == null) {
            url = url.addParameter("REGISTRY_CLUSTER", registryCluster);
        }
        if (this.writableMetadataService.exportURL(url)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("The URL[%s] registered successfully.", url.toString()));
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.info(String.format("The URL[%s] has been registered.", url.toString()));
        }
    }

    @Override
    public final void unregister(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        this.doUnregister(url);
    }

    public void doUnregister(URL url) {
        String registryCluster = this.serviceDiscovery.getUrl().getParameter("id");
        if (registryCluster != null && url.getParameter("REGISTRY_CLUSTER") == null) {
            url = url.addParameter("REGISTRY_CLUSTER", registryCluster);
        }
        if (this.writableMetadataService.unexportURL(url)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("The URL[%s] deregistered successfully.", url.toString()));
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.info(String.format("The URL[%s] has been deregistered.", url.toString()));
        }
    }

    @Override
    public final void subscribe(URL url, NotifyListener listener) {
        if (!this.shouldSubscribe(url)) {
            return;
        }
        String registryCluster = this.serviceDiscovery.getUrl().getParameter("id");
        if (registryCluster != null && url.getParameter("REGISTRY_CLUSTER") == null) {
            url = url.addParameter("REGISTRY_CLUSTER", registryCluster);
        }
        this.doSubscribe(url, listener);
    }

    public void doSubscribe(URL url, NotifyListener listener) {
        this.writableMetadataService.subscribeURL(url);
        Set<String> serviceNames = this.getServices(url, listener);
        if (CollectionUtils.isEmpty(serviceNames)) {
            throw new IllegalStateException("Should has at least one way to know which services this interface belongs to, subscription url: " + url);
        }
        this.subscribeURLs(url, listener, serviceNames);
    }

    @Override
    public final void unsubscribe(URL url, NotifyListener listener) {
        if (!this.shouldSubscribe(url)) {
            return;
        }
        String registryCluster = this.serviceDiscovery.getUrl().getParameter("id");
        if (registryCluster != null && url.getParameter("REGISTRY_CLUSTER") == null) {
            url = url.addParameter("REGISTRY_CLUSTER", registryCluster);
        }
        this.doUnsubscribe(url, listener);
    }

    public void doUnsubscribe(URL url, NotifyListener listener) {
        this.writableMetadataService.unsubscribeURL(url);
    }

    @Override
    public List<URL> lookup(URL url) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public URL getUrl() {
        return this.registryURL;
    }

    @Override
    public boolean isAvailable() {
        return !this.serviceDiscovery.getServices().isEmpty();
    }

    @Override
    public void destroy() {
        AbstractRegistryFactory.removeDestroyedRegistry(this);
        ThrowableAction.execute(() -> this.serviceDiscovery.destroy());
    }

    protected void subscribeURLs(URL url, NotifyListener listener, Set<String> serviceNames) {
        String serviceNamesKey = serviceNames.toString();
        ServiceInstancesChangedListener serviceListener = this.serviceListeners.computeIfAbsent(serviceNamesKey, k -> new ServiceInstancesChangedListener(serviceNames, this.serviceDiscovery));
        serviceListener.setUrl(url);
        listener.addServiceListener(serviceListener);
        String protocolServiceKey = url.getServiceKey() + ":" + url.getParameter("protocol", "dubbo");
        serviceListener.addListener(protocolServiceKey, listener);
        this.registerServiceInstancesChangedListener(url, serviceListener);
        serviceNames.forEach(serviceName -> {
            List<ServiceInstance> serviceInstances = this.serviceDiscovery.getInstances((String)serviceName);
            serviceListener.onEvent(new ServiceInstancesChangedEvent((String)serviceName, serviceInstances));
        });
        listener.notify(serviceListener.getUrls(protocolServiceKey));
    }

    private void registerServiceInstancesChangedListener(URL url, ServiceInstancesChangedListener listener) {
        String listenerId = this.createListenerId(url, listener);
        if (this.registeredListeners.add(listenerId)) {
            this.serviceDiscovery.addServiceInstancesChangedListener(listener);
        }
    }

    private String createListenerId(URL url, ServiceInstancesChangedListener listener) {
        return listener.getServiceNames() + ":" + url.toString("version", "group", "protocol");
    }

    protected Set<String> getServices(URL subscribedURL, NotifyListener listener) {
        TreeSet<String> subscribedServices = new TreeSet<String>();
        String serviceNames = subscribedURL.getParameter("provided-by");
        if (StringUtils.isNotEmpty(serviceNames)) {
            subscribedServices.addAll(ServiceDiscoveryRegistry.parseServices(serviceNames));
        }
        if (StringUtils.isNotEmpty(serviceNames = subscribedURL.getParameter("subscribed-services"))) {
            subscribedServices.addAll(ServiceDiscoveryRegistry.parseServices(serviceNames));
        }
        if (CollectionUtils.isEmpty(subscribedServices)) {
            subscribedServices.addAll(this.findMappedServices(subscribedURL, new DefaultMappingListener(subscribedURL, subscribedServices, listener)));
            if (CollectionUtils.isEmpty(subscribedServices)) {
                subscribedServices.addAll(this.getSubscribedServices());
            }
        }
        return subscribedServices;
    }

    public static Set<String> parseServices(String literalServices) {
        return StringUtils.isBlank(literalServices) ? Collections.emptySet() : Collections.unmodifiableSet(Stream.of(literalServices.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toSet()));
    }

    public Set<String> getSubscribedServices() {
        return this.subscribedServices;
    }

    protected Set<String> findMappedServices(URL subscribedURL, MappingListener listener) {
        return this.serviceNameMapping.getAndListen(subscribedURL, listener);
    }

    public static ServiceDiscoveryRegistry create(URL registryURL) {
        return ServiceDiscoveryRegistry.supports(registryURL) ? new ServiceDiscoveryRegistry(registryURL) : null;
    }

    public static boolean supports(URL registryURL) {
        return "service".equalsIgnoreCase(registryURL.getParameter("registry-type"));
    }

    private static List<URL> filterSubscribedURLs(URL subscribedURL, List<URL> exportedURLs) {
        return exportedURLs.stream().filter(url -> ServiceDiscoveryRegistry.isSameServiceInterface(subscribedURL, url)).filter(url -> ServiceDiscoveryRegistry.isSameParameter(subscribedURL, url, "version")).filter(url -> ServiceDiscoveryRegistry.isSameParameter(subscribedURL, url, "group")).filter(url -> ServiceDiscoveryRegistry.isCompatibleProtocol(subscribedURL, url)).collect(Collectors.toList());
    }

    private static boolean isSameServiceInterface(URL one, URL another) {
        return Objects.equals(one.getServiceInterface(), another.getServiceInterface());
    }

    private static boolean isSameParameter(URL one, URL another, String key) {
        return Objects.equals(one.getParameter(key), another.getParameter(key));
    }

    private static boolean isCompatibleProtocol(URL one, URL another) {
        String protocol = one.getParameter("protocol");
        return ServiceDiscoveryRegistry.isCompatibleProtocol(protocol, another);
    }

    private static boolean isCompatibleProtocol(String protocol, URL targetURL) {
        return protocol == null || Objects.equals(protocol, targetURL.getParameter("protocol")) || Objects.equals(protocol, targetURL.getProtocol());
    }

    private class DefaultMappingListener
    implements MappingListener {
        private URL url;
        private Set<String> oldApps;
        private NotifyListener listener;

        public DefaultMappingListener(URL subscribedURL, Set<String> serviceNames, NotifyListener listener) {
            this.url = subscribedURL;
            this.oldApps = serviceNames;
            this.listener = listener;
        }

        @Override
        public void onEvent(MappingChangedEvent event) {
            Set<String> newApps = event.getApps();
            Set<String> tempOldApps = this.oldApps;
            this.oldApps = newApps;
            if (CollectionUtils.isEmpty(newApps)) {
                return;
            }
            if (CollectionUtils.isEmpty(tempOldApps) && newApps.size() > 0) {
                ServiceDiscoveryRegistry.this.subscribeURLs(this.url, this.listener, newApps);
                return;
            }
            for (String newAppName : newApps) {
                if (tempOldApps.contains(newAppName)) continue;
                ServiceDiscoveryRegistry.this.subscribeURLs(this.url, this.listener, newApps);
                return;
            }
        }
    }
}

