/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.event.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.event.ConditionalEventListener;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.InstanceAddressURL;
import org.apache.dubbo.registry.client.RegistryClusterIdentifier;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.store.RemoteMetadataServiceImpl;

public class ServiceInstancesChangedListener
implements ConditionalEventListener<ServiceInstancesChangedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInstancesChangedListener.class);
    private final Set<String> serviceNames;
    private final ServiceDiscovery serviceDiscovery;
    private URL url;
    private Map<String, NotifyListener> listeners;
    private Map<String, List<ServiceInstance>> allInstances;
    private Map<String, List<URL>> serviceUrls;
    private Map<String, MetadataInfo> revisionToMetadata;

    public ServiceInstancesChangedListener(Set<String> serviceNames, ServiceDiscovery serviceDiscovery) {
        this.serviceNames = serviceNames;
        this.serviceDiscovery = serviceDiscovery;
        this.listeners = new HashMap<String, NotifyListener>();
        this.allInstances = new HashMap<String, List<ServiceInstance>>();
        this.serviceUrls = new HashMap<String, List<URL>>();
        this.revisionToMetadata = new HashMap<String, MetadataInfo>();
    }

    @Override
    public synchronized void onEvent(ServiceInstancesChangedEvent event) {
        logger.info("Received instance notification, serviceName: " + event.getServiceName() + ", instances: " + event.getServiceInstances().size());
        String appName = event.getServiceName();
        this.allInstances.put(appName, event.getServiceInstances());
        HashMap<String, List> revisionToInstances = new HashMap<String, List>();
        HashMap<String, Set<String>> localServiceToRevisions = new HashMap<String, Set<String>>();
        HashMap revisionsToUrls = new HashMap();
        for (Map.Entry<String, List<ServiceInstance>> entry : this.allInstances.entrySet()) {
            List<ServiceInstance> instances = entry.getValue();
            for (ServiceInstance instance : instances) {
                String revision = ServiceInstanceMetadataUtils.getExportedServicesRevision(instance);
                if (MetadataInfo.DEFAULT_REVISION.equals(revision)) {
                    logger.info("Find instance without valid service metadata: " + instance.getAddress());
                    continue;
                }
                List subInstances = revisionToInstances.computeIfAbsent(revision, r -> new LinkedList());
                subInstances.add(instance);
                MetadataInfo metadata = this.revisionToMetadata.get(revision);
                if (metadata == null) {
                    metadata = this.getMetadataInfo(instance);
                    logger.info("MetadataInfo for instance " + instance.getAddress() + "?revision=" + revision + " is " + metadata);
                    if (metadata != null) {
                        this.revisionToMetadata.put(revision, this.getMetadataInfo(instance));
                    }
                }
                if (metadata != null) {
                    this.parseMetadata(revision, metadata, localServiceToRevisions);
                    ((DefaultServiceInstance)instance).setServiceMetadata(metadata);
                }
                localServiceToRevisions.forEach((serviceKey, revisions) -> {
                    ArrayList<InstanceAddressURL> urls = (ArrayList<InstanceAddressURL>)revisionsToUrls.get(revisions);
                    if (urls != null) {
                        this.serviceUrls.put((String)serviceKey, (List<URL>)urls);
                    } else {
                        urls = new ArrayList<InstanceAddressURL>();
                        for (String r : revisions) {
                            for (ServiceInstance i : (List)revisionToInstances.get(r)) {
                                urls.add(i.toURL());
                            }
                        }
                        revisionsToUrls.put(revisions, urls);
                        this.serviceUrls.put((String)serviceKey, (List<URL>)urls);
                    }
                });
            }
        }
        this.notifyAddressChanged();
    }

    private Map<String, Set<String>> parseMetadata(String revision, MetadataInfo metadata, Map<String, Set<String>> localServiceToRevisions) {
        Map<String, MetadataInfo.ServiceInfo> serviceInfos = metadata.getServices();
        for (Map.Entry<String, MetadataInfo.ServiceInfo> entry : serviceInfos.entrySet()) {
            Set set = localServiceToRevisions.computeIfAbsent(entry.getKey(), k -> new TreeSet());
            set.add(revision);
        }
        return localServiceToRevisions;
    }

    private MetadataInfo getMetadataInfo(ServiceInstance instance) {
        MetadataInfo metadataInfo;
        String metadataType = ServiceInstanceMetadataUtils.getMetadataStorageType(instance);
        instance.getExtendParams().putIfAbsent("REGISTRY_CLUSTER", RegistryClusterIdentifier.getExtension(this.url).consumerKey(this.url));
        try {
            if ("remote".equals(metadataType)) {
                RemoteMetadataServiceImpl remoteMetadataService = MetadataUtils.getRemoteMetadataService();
                metadataInfo = remoteMetadataService.getMetadata(instance);
            } else {
                MetadataService metadataServiceProxy = MetadataUtils.getMetadataServiceProxy(instance, this.serviceDiscovery);
                metadataInfo = metadataServiceProxy.getMetadataInfo(ServiceInstanceMetadataUtils.getExportedServicesRevision(instance));
            }
        }
        catch (Exception e) {
            logger.error("Failed to load service metadata, metadta type is " + metadataType, e);
            metadataInfo = null;
        }
        return metadataInfo;
    }

    private void notifyAddressChanged() {
        this.listeners.forEach((key, notifyListener) -> notifyListener.notify(this.toUrlsWithEmpty(this.serviceUrls.get(key))));
    }

    private List<URL> toUrlsWithEmpty(List<URL> urls) {
        if (urls == null) {
            urls = Collections.emptyList();
        }
        return urls;
    }

    public void addListener(String serviceKey, NotifyListener listener) {
        this.listeners.put(serviceKey, listener);
    }

    public List<URL> getUrls(String serviceKey) {
        return this.toUrlsWithEmpty(this.serviceUrls.get(serviceKey));
    }

    public final Set<String> getServiceNames() {
        return this.serviceNames;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public final boolean accept(ServiceInstancesChangedEvent event) {
        return this.serviceNames.contains(event.getServiceName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceInstancesChangedListener)) {
            return false;
        }
        ServiceInstancesChangedListener that = (ServiceInstancesChangedListener)o;
        return Objects.equals(this.getServiceNames(), that.getServiceNames());
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.getServiceNames());
    }
}

