/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.MetadataServiceURLBuilder;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class StandardMetadataServiceURLBuilder
implements MetadataServiceURLBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String NAME = "standard";

    @Override
    public List<URL> build(ServiceInstance serviceInstance) {
        Map<String, Map<String, String>> paramsMap = ServiceInstanceMetadataUtils.getMetadataServiceURLsParams(serviceInstance);
        ArrayList<URL> urls = new ArrayList<URL>(paramsMap.size());
        String serviceName = serviceInstance.getServiceName();
        String host = serviceInstance.getHost();
        if (paramsMap.isEmpty()) {
            urls.add(this.generateUrlWithoutMetadata(serviceName, host));
        } else {
            for (Map.Entry<String, Map<String, String>> entry : paramsMap.entrySet()) {
                String protocol = entry.getKey();
                Map<String, String> params = entry.getValue();
                urls.add(this.generateWithMetadata(serviceName, host, protocol, params));
            }
        }
        return urls;
    }

    private URL generateWithMetadata(String serviceName, String host, String protocol, Map<String, String> params) {
        int port = Integer.parseInt(params.get("port"));
        URLBuilder urlBuilder = new URLBuilder().setHost(host).setPort(port).setProtocol(protocol).setPath(MetadataService.class.getName()).addParameter("timeout", ConfigurationUtils.get("dubbo.application.metadata.delay", 5000)).addParameter("side", "consumer");
        params.forEach((name, value) -> urlBuilder.addParameter((String)name, String.valueOf(value)));
        urlBuilder.addParameter("group", serviceName);
        return urlBuilder.build();
    }

    private URL generateUrlWithoutMetadata(String serviceName, String host) {
        Integer port = ApplicationModel.getApplicationConfig().getMetadataServicePort();
        if (port == null || port < 1) {
            String message = "Metadata Service Port should be specified for consumer. Please set dubbo.application.metadataServicePort and make sure it has been set in provider side. ServiceName: " + serviceName + " Host: " + host;
            this.logger.error(message);
            throw new IllegalStateException(message);
        }
        URLBuilder urlBuilder = new URLBuilder().setHost(host).setPort(port).setProtocol("dubbo").setPath(MetadataService.class.getName()).addParameter("timeout", ConfigurationUtils.get("dubbo.application.metadata.delay", 5000)).addParameter("reconnect", false).addParameter("side", "consumer").addParameter("group", serviceName).addParameter("version", "1.0.0");
        urlBuilder.addParameter("getAndListenServiceDiscoveryMetadata.1.callback", true);
        return urlBuilder.build();
    }
}

