/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.HashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.client.RegistryProtocol;
import org.apache.dubbo.registry.integration.DynamicDirectory;
import org.apache.dubbo.registry.integration.RegistryDirectory;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;

public class InterfaceCompatibleRegistryProtocol
extends RegistryProtocol {
    @Override
    protected URL getRegistryUrl(Invoker<?> originInvoker) {
        URL registryUrl = originInvoker.getUrl();
        if ("registry".equals(registryUrl.getProtocol())) {
            String protocol = registryUrl.getParameter("registry", "dubbo");
            registryUrl = registryUrl.setProtocol(protocol).removeParameter("registry");
        }
        return registryUrl;
    }

    @Override
    protected URL getRegistryUrl(URL url) {
        return URLBuilder.from(url).setProtocol(url.getParameter("registry", "dubbo")).removeParameter("registry").build();
    }

    @Override
    protected <T> DynamicDirectory<T> createDirectory(Class<T> type, URL url) {
        return new RegistryDirectory<T>(type, url);
    }

    @Override
    protected <T> Invoker<T> doRefer(Cluster cluster, Registry registry, Class<T> type, URL url) {
        ClusterInvoker<T> invoker = this.getInvoker(cluster, registry, type, url);
        ClusterInvoker<T> serviceDiscoveryInvoker = this.getServiceDiscoveryInvoker(cluster, type, url);
        MigrationInvoker<T> migrationInvoker = new MigrationInvoker<T>(invoker, serviceDiscoveryInvoker);
        return this.interceptInvoker(migrationInvoker, url);
    }

    protected <T> ClusterInvoker<T> getServiceDiscoveryInvoker(Cluster cluster, Class<T> type, URL url) {
        Registry registry = this.registryFactory.getRegistry(super.getRegistryUrl(url));
        ClusterInvoker serviceDiscoveryInvoker = null;
        boolean autoMigration = url.getParameter("enable-auto-migration", false);
        if (autoMigration) {
            DynamicDirectory<T> serviceDiscoveryDirectory = super.createDirectory(type, url);
            serviceDiscoveryDirectory.setRegistry(registry);
            serviceDiscoveryDirectory.setProtocol(this.protocol);
            HashMap<String, String> parameters = new HashMap<String, String>(serviceDiscoveryDirectory.getConsumerUrl().getParameters());
            URL urlToRegistry = new URL("consumer", (String)parameters.remove("register.ip"), 0, type.getName(), parameters);
            if (serviceDiscoveryDirectory.isShouldRegister()) {
                serviceDiscoveryDirectory.setRegisteredConsumerUrl(urlToRegistry);
                registry.register(serviceDiscoveryDirectory.getRegisteredConsumerUrl());
            }
            serviceDiscoveryDirectory.buildRouterChain(urlToRegistry);
            serviceDiscoveryDirectory.subscribe(InterfaceCompatibleRegistryProtocol.toSubscribeUrl(urlToRegistry));
            serviceDiscoveryInvoker = (ClusterInvoker)cluster.join(serviceDiscoveryDirectory);
        }
        return serviceDiscoveryInvoker;
    }

    private static class MigrationInvoker<T>
    implements ClusterInvoker<T> {
        private ClusterInvoker<T> invoker;
        private ClusterInvoker<T> serviceDiscoveryInvoker;

        public MigrationInvoker(ClusterInvoker<T> invoker, ClusterInvoker<T> serviceDiscoveryInvoker) {
            this.invoker = invoker;
            this.serviceDiscoveryInvoker = serviceDiscoveryInvoker;
        }

        public ClusterInvoker<T> getInvoker() {
            return this.invoker;
        }

        public void setInvoker(ClusterInvoker<T> invoker) {
            this.invoker = invoker;
        }

        public ClusterInvoker<T> getServiceDiscoveryInvoker() {
            return this.serviceDiscoveryInvoker;
        }

        public void setServiceDiscoveryInvoker(ClusterInvoker<T> serviceDiscoveryInvoker) {
            this.serviceDiscoveryInvoker = serviceDiscoveryInvoker;
        }

        @Override
        public Class<T> getInterface() {
            return this.invoker.getInterface();
        }

        @Override
        public Result invoke(Invocation invocation) throws RpcException {
            if (this.serviceDiscoveryInvoker == null) {
                return this.invoker.invoke(invocation);
            }
            if (this.invoker.isDestroyed()) {
                return this.serviceDiscoveryInvoker.invoke(invocation);
            }
            if (this.serviceDiscoveryInvoker.isAvailable()) {
                this.invoker.destroy();
                return this.serviceDiscoveryInvoker.invoke(invocation);
            }
            return this.invoker.invoke(invocation);
        }

        @Override
        public URL getUrl() {
            return this.invoker.getUrl();
        }

        @Override
        public boolean isAvailable() {
            if (this.serviceDiscoveryInvoker == null) {
                return this.invoker.isAvailable();
            }
            return this.invoker.isAvailable() || this.serviceDiscoveryInvoker.isAvailable();
        }

        @Override
        public void destroy() {
            if (this.invoker != null) {
                this.invoker.destroy();
            }
            if (this.serviceDiscoveryInvoker != null) {
                this.serviceDiscoveryInvoker.destroy();
            }
        }

        @Override
        public URL getRegistryUrl() {
            return this.invoker.getRegistryUrl();
        }

        @Override
        public Directory<T> getDirectory() {
            return this.invoker.getDirectory();
        }

        @Override
        public boolean isDestroyed() {
            if (this.serviceDiscoveryInvoker == null) {
                return this.invoker.isDestroyed();
            }
            return this.invoker.isDestroyed() && this.serviceDiscoveryInvoker.isDestroyed();
        }
    }
}

