/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.sofa;

import com.alipay.sofa.registry.client.api.Publisher;
import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.api.Subscriber;
import com.alipay.sofa.registry.client.api.model.RegistryType;
import com.alipay.sofa.registry.client.api.model.UserData;
import com.alipay.sofa.registry.client.api.registration.PublisherRegistration;
import com.alipay.sofa.registry.client.api.registration.SubscriberRegistration;
import com.alipay.sofa.registry.client.provider.DefaultRegistryClient;
import com.alipay.sofa.registry.client.provider.DefaultRegistryClientConfigBuilder;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.DefaultPage;
import org.apache.dubbo.common.utils.Page;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.sofa.SofaRegistryInstance;
import org.apache.dubbo.rpc.RpcException;

public class SofaRegistryServiceDiscovery
implements ServiceDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(SofaRegistryServiceDiscovery.class);
    private static final String DEFAULT_GROUP = "dubbo";
    private URL registryURL;
    private DefaultRegistryClient registryClient;
    private int waitAddressTimeout;
    private RegistryClientConfig registryClientConfig;
    private final Map<String, Publisher> publishers = new ConcurrentHashMap<String, Publisher>();
    private final Map<String, Subscriber> subscribers = new ConcurrentHashMap<String, Subscriber>();
    private ServiceInstance serviceInstance;
    private Gson gson = new Gson();

    @Override
    public void initialize(URL registryURL) throws Exception {
        this.registryURL = registryURL;
        this.registryClientConfig = DefaultRegistryClientConfigBuilder.start().setDataCenter("DefaultDataCenter").setZone("DEFAULT_ZONE").setRegistryEndpoint(registryURL.getHost()).setRegistryEndpointPort(registryURL.getPort()).build();
        this.registryClient = new DefaultRegistryClient(this.registryClientConfig);
        this.registryClient.init();
        this.waitAddressTimeout = Integer.parseInt(ConfigUtils.getProperty("rpc.reference.address.wait.time", "5000"));
    }

    @Override
    public URL getUrl() {
        return this.registryURL;
    }

    @Override
    public void destroy() throws Exception {
    }

    @Override
    public void register(ServiceInstance serviceInstance) throws RuntimeException {
        SofaRegistryInstance sofaRegistryInstance = new SofaRegistryInstance(serviceInstance.getId(), serviceInstance.getHost(), serviceInstance.getPort(), serviceInstance.getServiceName(), serviceInstance.getMetadata());
        Publisher publisher = this.publishers.get(serviceInstance.getServiceName());
        this.serviceInstance = serviceInstance;
        if (null == publisher) {
            PublisherRegistration registration = new PublisherRegistration(serviceInstance.getServiceName());
            registration.setGroup(DEFAULT_GROUP);
            publisher = this.registryClient.register(registration, new String[]{this.gson.toJson((Object)sofaRegistryInstance)});
            this.publishers.put(serviceInstance.getServiceName(), publisher);
        } else {
            publisher.republish(new String[]{this.gson.toJson((Object)sofaRegistryInstance)});
        }
    }

    @Override
    public void update(ServiceInstance serviceInstance) throws RuntimeException {
        this.register(serviceInstance);
    }

    @Override
    public void unregister(ServiceInstance serviceInstance) throws RuntimeException {
        this.registryClient.unregister(serviceInstance.getServiceName(), DEFAULT_GROUP, RegistryType.PUBLISHER);
    }

    @Override
    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        listener.getServiceNames().forEach(serviceName -> this.registerServiceWatcher((String)serviceName, listener));
    }

    protected void registerServiceWatcher(String serviceName, ServiceInstancesChangedListener listener) {
        Subscriber subscriber = this.subscribers.get(serviceName);
        if (null == subscriber) {
            CountDownLatch latch = new CountDownLatch(1);
            SubscriberRegistration subscriberRegistration = new SubscriberRegistration(serviceName, (dataId, data) -> this.handleRegistryData(dataId, data, listener, latch));
            subscriberRegistration.setGroup(DEFAULT_GROUP);
            subscriberRegistration.setScopeEnum(ScopeEnum.global);
            subscriber = this.registryClient.register(subscriberRegistration);
            this.subscribers.put(serviceName, subscriber);
            this.waitAddress(serviceName, latch);
        }
    }

    @Override
    public Page<ServiceInstance> getInstances(String serviceName, int offset, int pageSize, boolean healthyOnly) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException {
        Subscriber subscriber = this.subscribers.get(serviceName);
        if (null != subscriber) {
            List<ServiceInstance> serviceInstanceList = this.handleRegistryData(serviceName, subscriber.peekData(), null, null);
            return new DefaultPage<ServiceInstance>(offset, pageSize, serviceInstanceList, serviceInstanceList.size());
        }
        throw new RpcException("getInstances error!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServiceInstance> handleRegistryData(String dataId, UserData userData, ServiceInstancesChangedListener listener, CountDownLatch latch) {
        try {
            List<String> datas = this.getUserData(dataId, userData);
            ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>(datas.size());
            for (String serviceData : datas) {
                SofaRegistryInstance sri = (SofaRegistryInstance)this.gson.fromJson(serviceData, SofaRegistryInstance.class);
                DefaultServiceInstance serviceInstance = new DefaultServiceInstance(sri.getId(), dataId, sri.getHost(), sri.getPort());
                serviceInstance.setMetadata(sri.getMetadata());
                serviceInstances.add(serviceInstance);
            }
            if (null != listener) {
                listener.onEvent(new ServiceInstancesChangedEvent(dataId, serviceInstances));
            }
            ArrayList<ServiceInstance> arrayList = serviceInstances;
            return arrayList;
        }
        finally {
            if (null != latch) {
                latch.countDown();
            }
        }
    }

    private void waitAddress(String serviceName, CountDownLatch countDownLatch) {
        try {
            if (!countDownLatch.await(this.waitAddressTimeout, TimeUnit.MILLISECONDS)) {
                LOGGER.warn("Subscribe data failed by dataId " + serviceName);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error when wait Address!", e);
        }
    }

    protected List<String> getUserData(String dataId, UserData userData) {
        List<String> datas = null;
        datas = userData == null ? new ArrayList<String>(0) : this.flatUserData(userData);
        StringBuilder sb = new StringBuilder();
        for (String provider : datas) {
            sb.append("  >>> ").append(provider).append("\n");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Receive updated RPC service addresses: service[" + dataId + "]\n  .Available target addresses size [" + datas.size() + "]\n" + sb.toString());
        }
        return datas;
    }

    protected List<String> flatUserData(UserData userData) {
        ArrayList<String> result = new ArrayList<String>();
        Map zoneData = userData.getZoneData();
        for (Map.Entry entry : zoneData.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    @Override
    public ServiceInstance getLocalInstance() {
        return this.serviceInstance;
    }

    @Override
    public Set<String> getServices() {
        return this.subscribers.keySet();
    }
}

