/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.zookeeper;

import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.zookeeper.ZookeeperServiceDiscovery;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class ZookeeperServiceDiscoveryChangeWatcher
implements CuratorWatcher {
    private ServiceInstancesChangedListener listener;
    private final ZookeeperServiceDiscovery zookeeperServiceDiscovery;
    private final String serviceName;

    public ZookeeperServiceDiscoveryChangeWatcher(ZookeeperServiceDiscovery zookeeperServiceDiscovery, String serviceName, ServiceInstancesChangedListener listener) {
        this.zookeeperServiceDiscovery = zookeeperServiceDiscovery;
        this.serviceName = serviceName;
        this.listener = listener;
    }

    public void process(WatchedEvent event) throws Exception {
        Watcher.Event.EventType eventType = event.getType();
        if (Watcher.Event.EventType.NodeChildrenChanged.equals((Object)eventType) || Watcher.Event.EventType.NodeDataChanged.equals((Object)eventType)) {
            this.listener.onEvent(new ServiceInstancesChangedEvent(this.serviceName, this.zookeeperServiceDiscovery.getInstances(this.serviceName)));
            this.zookeeperServiceDiscovery.registerServiceWatcher(this.serviceName, this.listener);
            this.zookeeperServiceDiscovery.dispatchServiceInstancesChangedEvent(this.serviceName);
        }
    }
}

