/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.loadbalance;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.loadbalance.AbstractLoadBalance;

public class RandomLoadBalance
extends AbstractLoadBalance {
    public static final String NAME = "random";

    @Override
    protected <T> Invoker<T> doSelect(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        int length = invokers.size();
        boolean sameWeight = true;
        int[] weights = new int[length];
        int totalWeight = 0;
        for (int i = 0; i < length; ++i) {
            int weight = this.getWeight(invokers.get(i), invocation);
            weights[i] = totalWeight += weight;
            if (!sameWeight || totalWeight == weight * (i + 1)) continue;
            sameWeight = false;
        }
        if (totalWeight > 0 && !sameWeight) {
            int offset = ThreadLocalRandom.current().nextInt(totalWeight);
            for (int i = 0; i < length; ++i) {
                if (offset >= weights[i]) continue;
                return invokers.get(i);
            }
        }
        return invokers.get(ThreadLocalRandom.current().nextInt(length));
    }
}

