/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool.manager;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadlocal.NamedInternalThreadFactory;
import org.apache.dubbo.common.threadpool.ThreadPool;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.manager.Ring;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DefaultExecutorRepository
implements ExecutorRepository {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExecutorRepository.class);
    private int DEFAULT_SCHEDULER_SIZE = Runtime.getRuntime().availableProcessors();
    private final ExecutorService SHARED_EXECUTOR = Executors.newCachedThreadPool(new NamedThreadFactory("DubboSharedHandler", true));
    private Ring<ScheduledExecutorService> scheduledExecutors = new Ring();
    private volatile ScheduledExecutorService exportReferExecutor;
    public ScheduledExecutorService registryNotificationExecutor;
    private ScheduledExecutorService reconnectScheduledExecutor;
    private ScheduledExecutorService serviceDiscoveryAddressNotificationExecutor;
    private ScheduledExecutorService metadataRetryExecutor;
    private ConcurrentMap<String, ConcurrentMap<Integer, ExecutorService>> data = new ConcurrentHashMap<String, ConcurrentMap<Integer, ExecutorService>>();
    private ExecutorService poolRouterExecutor;
    private static Ring<ExecutorService> executorServiceRing = new Ring();
    private static final Object LOCK = new Object();

    public DefaultExecutorRepository() {
        for (int i = 0; i < this.DEFAULT_SCHEDULER_SIZE; ++i) {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-framework-scheduler"));
            this.scheduledExecutors.addItem(scheduler);
            executorServiceRing.addItem(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new NamedInternalThreadFactory("Dubbo-state-router-loop", true), new ThreadPoolExecutor.AbortPolicy()));
        }
        this.poolRouterExecutor = new ThreadPoolExecutor(1, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new NamedInternalThreadFactory("Dubbo-state-router-pool-router", true), new ThreadPoolExecutor.AbortPolicy());
        this.serviceDiscoveryAddressNotificationExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-SD-address-refresh"));
        this.registryNotificationExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-registry-notification"));
        this.metadataRetryExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-metadata-retry"));
    }

    @Override
    public synchronized ExecutorService createExecutorIfAbsent(URL url) {
        Integer portKey;
        Map executors = this.data.computeIfAbsent(CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY, k -> new ConcurrentHashMap());
        ExecutorService executor = executors.computeIfAbsent(portKey = Integer.valueOf("consumer".equalsIgnoreCase(url.getParameter("side")) ? Integer.MAX_VALUE : url.getPort()), k -> this.createExecutor(url));
        if (executor.isShutdown() || executor.isTerminated()) {
            executors.remove(portKey);
            executor = this.createExecutor(url);
            executors.put(portKey, executor);
        }
        return executor;
    }

    @Override
    public ExecutorService getExecutor(URL url) {
        Map executors = (Map)this.data.get(CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY);
        if (executors == null) {
            logger.warn("No available executors, this is not expected, framework should call createExecutorIfAbsent first before coming to here.");
            return null;
        }
        Integer portKey = "consumer".equalsIgnoreCase(url.getParameter("side")) ? Integer.MAX_VALUE : url.getPort();
        ExecutorService executor = (ExecutorService)executors.get(portKey);
        if (executor != null && (executor.isShutdown() || executor.isTerminated())) {
            executors.remove(portKey);
            executor = null;
            logger.info("Executor for " + url + " is shutdown.");
        }
        if (executor == null) {
            return this.SHARED_EXECUTOR;
        }
        return executor;
    }

    @Override
    public void updateThreadpool(URL url, ExecutorService executor) {
        try {
            if (url.hasParameter("threads") && executor instanceof ThreadPoolExecutor && !executor.isShutdown()) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
                int threads = url.getParameter("threads", 0);
                int max = threadPoolExecutor.getMaximumPoolSize();
                int core = threadPoolExecutor.getCorePoolSize();
                if (threads > 0 && (threads != max || threads != core)) {
                    if (threads < core) {
                        threadPoolExecutor.setCorePoolSize(threads);
                        if (core == max) {
                            threadPoolExecutor.setMaximumPoolSize(threads);
                        }
                    } else {
                        threadPoolExecutor.setMaximumPoolSize(threads);
                        if (core == max) {
                            threadPoolExecutor.setCorePoolSize(threads);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    @Override
    public ScheduledExecutorService nextScheduledExecutor() {
        return this.scheduledExecutors.pollItem();
    }

    @Override
    public ExecutorService nextExecutorExecutor() {
        return executorServiceRing.pollItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledExecutorService getExportReferExecutor() {
        if (this.exportReferExecutor == null) {
            Object object = LOCK;
            synchronized (object) {
                if (this.exportReferExecutor == null) {
                    int coreSize = this.getExportReferThreadNum();
                    this.exportReferExecutor = Executors.newScheduledThreadPool(coreSize, new NamedThreadFactory("Dubbo-export-refer", true));
                }
            }
        }
        return this.exportReferExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownExportReferExecutor() {
        Object object = LOCK;
        synchronized (object) {
            if (this.exportReferExecutor != null && !this.exportReferExecutor.isShutdown()) {
                this.exportReferExecutor.shutdown();
            }
            this.exportReferExecutor = null;
        }
    }

    private Integer getExportReferThreadNum() {
        Stream<Integer> consumer;
        Stream<Integer> provider = ApplicationModel.getConfigManager().getProviders().stream().map(ProviderConfig::getAsyncThreadNum);
        List threadNums = Stream.concat(provider, consumer = ApplicationModel.getConfigManager().getConsumers().stream().map(ConsumerConfig::getAsyncThreadNum)).filter(k -> k != null && k > 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(threadNums)) {
            logger.info("Cannot get config `async-thread-num` for export-refer thread, using default: 10");
            return 10;
        }
        if (threadNums.size() > 1) {
            logger.info("Detect multiple config `async-thread-num` for export-refer thread, using: " + threadNums.get(0));
        }
        return (Integer)threadNums.get(0);
    }

    @Override
    public ScheduledExecutorService getRegistryNotificationExecutor() {
        return this.registryNotificationExecutor;
    }

    @Override
    public ScheduledExecutorService getServiceDiscoveryAddressNotificationExecutor() {
        return this.serviceDiscoveryAddressNotificationExecutor;
    }

    @Override
    public ScheduledExecutorService getMetadataRetryExecutor() {
        return this.metadataRetryExecutor;
    }

    @Override
    public ExecutorService getSharedExecutor() {
        return this.SHARED_EXECUTOR;
    }

    private ExecutorService createExecutor(URL url) {
        return (ExecutorService)ExtensionLoader.getExtensionLoader(ThreadPool.class).getAdaptiveExtension().getExecutor(url);
    }

    @Override
    public ExecutorService getPoolRouterExecutor() {
        return this.poolRouterExecutor;
    }

    @Override
    public void destroyAll() {
        this.poolRouterExecutor.shutdown();
        this.serviceDiscoveryAddressNotificationExecutor.shutdown();
        this.registryNotificationExecutor.shutdown();
        this.metadataRetryExecutor.shutdown();
        this.shutdownExportReferExecutor();
        this.data.values().forEach(executors -> {
            if (executors != null) {
                executors.values().forEach(executor -> {
                    if (executor != null && !executor.isShutdown()) {
                        ExecutorUtil.shutdownNow(executor, 100);
                    }
                });
            }
        });
    }
}

