/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component;

import java.util.Objects;
import org.apache.dubbo.common.url.component.URLAddress;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;

public class PathURLAddress
extends URLAddress {
    private String protocol;
    private String username;
    private String password;
    private String path;
    private transient String address;
    private transient String ip;

    public PathURLAddress(String protocol, String username, String password, String path, String host, int port) {
        this(protocol, username, password, path, host, port, null);
    }

    public PathURLAddress(String protocol, String username, String password, String path, String host, int port, String rawAddress) {
        super(host, port, rawAddress);
        this.protocol = protocol;
        this.username = username;
        this.password = password;
        while (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        this.path = path;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public URLAddress setProtocol(String protocol) {
        return new PathURLAddress(protocol, this.username, this.password, this.path, this.host, this.port, this.rawAddress);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public URLAddress setUsername(String username) {
        return new PathURLAddress(this.protocol, username, this.password, this.path, this.host, this.port, this.rawAddress);
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public PathURLAddress setPassword(String password) {
        return new PathURLAddress(this.protocol, this.username, password, this.path, this.host, this.port, this.rawAddress);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public PathURLAddress setPath(String path) {
        return new PathURLAddress(this.protocol, this.username, this.password, path, this.host, this.port, this.rawAddress);
    }

    @Override
    public URLAddress setHost(String host) {
        return new PathURLAddress(this.protocol, this.username, this.password, this.path, host, this.port, this.rawAddress);
    }

    @Override
    public URLAddress setPort(int port) {
        return new PathURLAddress(this.protocol, this.username, this.password, this.path, this.host, port, this.rawAddress);
    }

    @Override
    public URLAddress setAddress(String host, int port) {
        return new PathURLAddress(this.protocol, this.username, this.password, this.path, host, port, this.rawAddress);
    }

    @Override
    public String getAddress() {
        if (this.address == null) {
            this.address = this.getAddress(this.getHost(), this.getPort());
        }
        return this.address;
    }

    @Override
    public String getIp() {
        if (this.ip == null) {
            this.ip = NetUtils.getIpByHost(this.getHost());
        }
        return this.ip;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.protocol, this.username, this.password, this.path, this.host, this.port);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof URLAddress)) {
            return false;
        }
        URLAddress that = (URLAddress)obj;
        return Objects.equals(this.getProtocol(), that.getProtocol()) && Objects.equals(this.getUsername(), that.getUsername()) && Objects.equals(this.getPassword(), that.getPassword()) && Objects.equals(this.getPath(), that.getPath()) && Objects.equals(this.getHost(), that.getHost()) && Objects.equals(this.getPort(), that.getPort());
    }

    @Override
    public String toString() {
        if (this.rawAddress != null) {
            return this.rawAddress;
        }
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isNotEmpty(this.protocol)) {
            buf.append(this.protocol);
            buf.append("://");
        }
        if (StringUtils.isNotEmpty(this.host)) {
            buf.append(this.host);
            if (this.port > 0) {
                buf.append(":");
                buf.append(this.port);
            }
        }
        if (StringUtils.isNotEmpty(this.path)) {
            buf.append("/");
            buf.append(this.path);
        }
        return buf.toString();
    }
}

