/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.url.component.param;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.url.component.param.DynamicParamSource;
import org.apache.dubbo.common.url.component.param.DynamicValues;
import org.apache.dubbo.common.url.component.param.ParamValue;

public final class DynamicParamTable {
    private static final List<String> KEYS = new CopyOnWriteArrayList<String>();
    private static final List<ParamValue> VALUES = new CopyOnWriteArrayList<ParamValue>();
    private static final Map<String, Integer> KEY2INDEX = new HashMap<String, Integer>(64);

    private DynamicParamTable() {
        throw new IllegalStateException();
    }

    public static Integer getKeyIndex(boolean enabled, String key) {
        if (!enabled) {
            return null;
        }
        return KEY2INDEX.get(key);
    }

    public static Integer getValueIndex(String key, String value) {
        Integer idx = DynamicParamTable.getKeyIndex(true, key);
        if (idx == null) {
            throw new IllegalArgumentException("Cannot found key in url param:" + key);
        }
        ParamValue paramValue = VALUES.get(idx);
        return paramValue.getIndex(value);
    }

    public static String getKey(int offset) {
        return KEYS.get(offset);
    }

    public static boolean isDefaultValue(String key, String value) {
        return Objects.equals(value, VALUES.get(DynamicParamTable.getKeyIndex(true, key)).defaultVal());
    }

    public static String getValue(int vi, Integer offset) {
        return VALUES.get(vi).getN(offset);
    }

    public static String getDefaultValue(int vi) {
        return VALUES.get(vi).defaultVal();
    }

    public static void init() {
        int i;
        LinkedList<String> keys = new LinkedList<String>();
        LinkedList<DynamicValues> values = new LinkedList<DynamicValues>();
        HashMap<String, Integer> key2Index = new HashMap<String, Integer>(64);
        keys.add("");
        values.add(new DynamicValues(null));
        ExtensionLoader.getExtensionLoader(DynamicParamSource.class).getSupportedExtensionInstances().forEach(source -> source.init(keys, values));
        for (i = 0; i < keys.size(); ++i) {
            if (KEYS.contains(keys.get(i))) continue;
            KEYS.add((String)keys.get(i));
            VALUES.add((ParamValue)values.get(i));
        }
        for (i = 0; i < KEYS.size(); ++i) {
            if (KEYS.get(i).isEmpty()) continue;
            key2Index.put(KEYS.get(i), i);
        }
        KEY2INDEX.putAll(key2Index);
    }

    static {
        DynamicParamTable.init();
    }
}

