/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.dubbo.common.context.FrameworkExt;
import org.apache.dubbo.common.context.LifecycleAdapter;
import org.apache.dubbo.common.extension.DisableInject;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.config.SslConfig;

public class ConfigManager
extends LifecycleAdapter
implements FrameworkExt {
    private static final Logger logger = LoggerFactory.getLogger(ConfigManager.class);
    public static final String NAME = "config";
    public static final String BEAN_NAME = "dubboConfigManager";
    private static final String CONFIG_NAME_READ_METHOD = "getName";
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    final Map<String, Map<String, AbstractConfig>> configsCache = ConfigManager.newMap();
    private static Map<Class, AtomicInteger> configIdIndexes = new ConcurrentHashMap<Class, AtomicInteger>();
    private static volatile boolean configWarnLogEnabled = false;
    private static Set<Class<? extends AbstractConfig>> uniqueConfigTypes = new ConcurrentHashSet<Class<? extends AbstractConfig>>();

    public ConfigManager() {
        try {
            String rawWarn = System.getProperty("dubbo.application.config.warn");
            if (rawWarn != null) {
                configWarnLogEnabled = Boolean.parseBoolean(rawWarn);
            }
        }
        catch (Exception e) {
            logger.warn("Illegal 'dubbo.application.config.warn' config, only boolean value is accepted.", e);
        }
    }

    @DisableInject
    public void setApplication(ApplicationConfig application) {
        this.addConfig(application, true);
    }

    public Optional<ApplicationConfig> getApplication() {
        return Optional.ofNullable((ApplicationConfig)this.getSingleConfig(AbstractConfig.getTagName(ApplicationConfig.class)));
    }

    public ApplicationConfig getApplicationOrElseThrow() {
        return this.getApplication().orElseThrow(() -> new IllegalStateException("There's no ApplicationConfig specified."));
    }

    @DisableInject
    public void setMonitor(MonitorConfig monitor) {
        this.addConfig(monitor, true);
    }

    public Optional<MonitorConfig> getMonitor() {
        return Optional.ofNullable((MonitorConfig)this.getSingleConfig(AbstractConfig.getTagName(MonitorConfig.class)));
    }

    @DisableInject
    public void setModule(ModuleConfig module) {
        this.addConfig(module, true);
    }

    public Optional<ModuleConfig> getModule() {
        return Optional.ofNullable((ModuleConfig)this.getSingleConfig(AbstractConfig.getTagName(ModuleConfig.class)));
    }

    @DisableInject
    public void setMetrics(MetricsConfig metrics) {
        this.addConfig(metrics, true);
    }

    public Optional<MetricsConfig> getMetrics() {
        return Optional.ofNullable((MetricsConfig)this.getSingleConfig(AbstractConfig.getTagName(MetricsConfig.class)));
    }

    @DisableInject
    public void setSsl(SslConfig sslConfig) {
        this.addConfig(sslConfig, true);
    }

    public Optional<SslConfig> getSsl() {
        return Optional.ofNullable((SslConfig)this.getSingleConfig(AbstractConfig.getTagName(SslConfig.class)));
    }

    public void addConfigCenter(ConfigCenterConfig configCenter) {
        this.addConfig(configCenter);
    }

    public void addConfigCenters(Iterable<ConfigCenterConfig> configCenters) {
        configCenters.forEach(this::addConfigCenter);
    }

    public Optional<Collection<ConfigCenterConfig>> getDefaultConfigCenter() {
        Collection<Object> defaults = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ConfigCenterConfig.class)));
        if (CollectionUtils.isEmpty(defaults)) {
            defaults = this.getConfigCenters();
        }
        return Optional.ofNullable(defaults);
    }

    public Optional<ConfigCenterConfig> getConfigCenter(String id) {
        return this.getConfig(ConfigCenterConfig.class, id);
    }

    public Collection<ConfigCenterConfig> getConfigCenters() {
        return this.getConfigs(AbstractConfig.getTagName(ConfigCenterConfig.class));
    }

    public void addMetadataReport(MetadataReportConfig metadataReportConfig) {
        this.addConfig(metadataReportConfig);
    }

    public void addMetadataReports(Iterable<MetadataReportConfig> metadataReportConfigs) {
        metadataReportConfigs.forEach(this::addMetadataReport);
    }

    public Collection<MetadataReportConfig> getMetadataConfigs() {
        return this.getConfigs(AbstractConfig.getTagName(MetadataReportConfig.class));
    }

    public Collection<MetadataReportConfig> getDefaultMetadataConfigs() {
        List<MetadataReportConfig> defaults = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(MetadataReportConfig.class)));
        if (CollectionUtils.isEmpty(defaults)) {
            return this.getMetadataConfigs();
        }
        return defaults;
    }

    public void addProvider(ProviderConfig providerConfig) {
        this.addConfig(providerConfig);
    }

    public void addProviders(Iterable<ProviderConfig> providerConfigs) {
        providerConfigs.forEach(this::addProvider);
    }

    public Optional<ProviderConfig> getProvider(String id) {
        return this.getConfig(ProviderConfig.class, id);
    }

    public Optional<ProviderConfig> getDefaultProvider() {
        List providerConfigs = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ProviderConfig.class)));
        if (CollectionUtils.isNotEmpty(providerConfigs)) {
            return Optional.of((ProviderConfig)providerConfigs.get(0));
        }
        return Optional.empty();
    }

    public Collection<ProviderConfig> getProviders() {
        return this.getConfigs(AbstractConfig.getTagName(ProviderConfig.class));
    }

    public void addConsumer(ConsumerConfig consumerConfig) {
        this.addConfig(consumerConfig);
    }

    public void addConsumers(Iterable<ConsumerConfig> consumerConfigs) {
        consumerConfigs.forEach(this::addConsumer);
    }

    public Optional<ConsumerConfig> getConsumer(String id) {
        return this.getConfig(ConsumerConfig.class, id);
    }

    public Optional<ConsumerConfig> getDefaultConsumer() {
        List consumerConfigs = ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(ConsumerConfig.class)));
        if (CollectionUtils.isNotEmpty(consumerConfigs)) {
            return Optional.of((ConsumerConfig)consumerConfigs.get(0));
        }
        return Optional.empty();
    }

    public Collection<ConsumerConfig> getConsumers() {
        return this.getConfigs(AbstractConfig.getTagName(ConsumerConfig.class));
    }

    public void addProtocol(ProtocolConfig protocolConfig) {
        this.addConfig(protocolConfig);
    }

    public void addProtocols(Iterable<ProtocolConfig> protocolConfigs) {
        if (protocolConfigs != null) {
            protocolConfigs.forEach(this::addProtocol);
        }
    }

    public Optional<ProtocolConfig> getProtocol(String idOrName) {
        return this.getConfig(ProtocolConfig.class, idOrName);
    }

    public List<ProtocolConfig> getDefaultProtocols() {
        return this.getDefaultConfigs(ProtocolConfig.class);
    }

    public <C extends AbstractConfig> List<C> getDefaultConfigs(Class<C> cls) {
        return ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(cls)));
    }

    public Collection<ProtocolConfig> getProtocols() {
        return this.getConfigs(AbstractConfig.getTagName(ProtocolConfig.class));
    }

    public void addRegistry(RegistryConfig registryConfig) {
        this.addConfig(registryConfig);
    }

    public void addRegistries(Iterable<RegistryConfig> registryConfigs) {
        if (registryConfigs != null) {
            registryConfigs.forEach(this::addRegistry);
        }
    }

    public Optional<RegistryConfig> getRegistry(String id) {
        return this.getConfig(RegistryConfig.class, id);
    }

    public <T extends AbstractConfig> Optional<T> getConfig(Class<T> cls, String idOrName) {
        Object config = this.getConfigById(AbstractConfig.getTagName(cls), idOrName);
        if (config == null) {
            config = this.getConfigByName(cls, idOrName);
        }
        return Optional.ofNullable(config);
    }

    public List<RegistryConfig> getDefaultRegistries() {
        return ConfigManager.getDefaultConfigs(this.getConfigsMap(AbstractConfig.getTagName(RegistryConfig.class)));
    }

    public Collection<RegistryConfig> getRegistries() {
        return this.getConfigs(AbstractConfig.getTagName(RegistryConfig.class));
    }

    public void addService(ServiceConfigBase<?> serviceConfig) {
        this.addConfig(serviceConfig);
    }

    public void addServices(Iterable<ServiceConfigBase<?>> serviceConfigs) {
        serviceConfigs.forEach(this::addService);
    }

    public Collection<ServiceConfigBase> getServices() {
        return this.getConfigs(AbstractConfig.getTagName(ServiceConfigBase.class));
    }

    public <T> ServiceConfigBase<T> getService(String id) {
        return this.getConfig(ServiceConfigBase.class, id).orElse(null);
    }

    public void addReference(ReferenceConfigBase<?> referenceConfig) {
        this.addConfig(referenceConfig);
    }

    public void addReferences(Iterable<ReferenceConfigBase<?>> referenceConfigs) {
        referenceConfigs.forEach(this::addReference);
    }

    public Collection<ReferenceConfigBase<?>> getReferences() {
        return this.getConfigs(AbstractConfig.getTagName(ReferenceConfigBase.class));
    }

    public <T> ReferenceConfigBase<T> getReference(String id) {
        return this.getConfig(ReferenceConfigBase.class, id).orElse(null);
    }

    public void refreshAll() {
        this.write(() -> {
            this.getApplication().ifPresent(ApplicationConfig::refresh);
            this.getMonitor().ifPresent(AbstractConfig::refresh);
            this.getModule().ifPresent(AbstractConfig::refresh);
            this.getMetrics().ifPresent(AbstractConfig::refresh);
            this.getSsl().ifPresent(AbstractConfig::refresh);
            this.getProtocols().forEach(AbstractConfig::refresh);
            this.getRegistries().forEach(AbstractConfig::refresh);
            this.getProviders().forEach(AbstractConfig::refresh);
            this.getConsumers().forEach(AbstractConfig::refresh);
            this.getConfigCenters().forEach(AbstractConfig::refresh);
            this.getMetadataConfigs().forEach(AbstractConfig::refresh);
        });
    }

    public void removeConfig(AbstractConfig config) {
        if (config == null) {
            return;
        }
        Map<String, AbstractConfig> configs = this.configsCache.get(AbstractConfig.getTagName(config.getClass()));
        if (CollectionUtils.isNotEmptyMap(configs)) {
            configs.values().removeIf(c -> config == c);
        }
    }

    public void clear() {
        this.write(() -> {
            this.configsCache.clear();
            configIdIndexes.clear();
        });
    }

    @Override
    public void destroy() throws IllegalStateException {
        this.clear();
    }

    public void addConfig(AbstractConfig config) {
        if (config == null) {
            return;
        }
        this.addConfig(config, this.isUniqueConfig(config));
    }

    private boolean isUniqueConfig(AbstractConfig config) {
        return uniqueConfigTypes.contains(config.getClass());
    }

    protected <T extends AbstractConfig> T addConfig(AbstractConfig config, boolean unique) {
        if (config == null) {
            return null;
        }
        if (config instanceof MethodConfig) {
            return null;
        }
        return (T)this.write(() -> {
            Map configsMap = this.configsCache.computeIfAbsent(AbstractConfig.getTagName(config.getClass()), type -> ConfigManager.newMap());
            return ConfigManager.addIfAbsent(config, configsMap, unique);
        });
    }

    public <C extends AbstractConfig> Map<String, C> getConfigsMap(Class<C> cls) {
        return this.getConfigsMap(AbstractConfig.getTagName(cls));
    }

    private <C extends AbstractConfig> Map<String, C> getConfigsMap(String configType) {
        return this.read(() -> this.configsCache.getOrDefault(configType, Collections.emptyMap()));
    }

    private <C extends AbstractConfig> Collection<C> getConfigs(String configType) {
        return this.read(() -> this.getConfigsMap(configType).values());
    }

    public <C extends AbstractConfig> Collection<C> getConfigs(Class<C> configType) {
        return this.read(() -> this.getConfigsMap(AbstractConfig.getTagName(configType)).values());
    }

    private <C extends AbstractConfig> C getConfigById(String configType, String id) {
        return (C)this.read(() -> {
            Map configsMap = this.configsCache.getOrDefault(configType, Collections.emptyMap());
            return (AbstractConfig)configsMap.get(id);
        });
    }

    private <C extends AbstractConfig> C getConfigByName(Class<? extends C> cls, String name) {
        return (C)this.read(() -> {
            String configType = AbstractConfig.getTagName(cls);
            Map configsMap = this.configsCache.getOrDefault(configType, Collections.emptyMap());
            if (configsMap.isEmpty()) {
                return null;
            }
            if (ReflectUtils.hasMethod(cls, CONFIG_NAME_READ_METHOD)) {
                List list = configsMap.values().stream().filter(cfg -> name.equals(this.getConfigName(cfg))).collect(Collectors.toList());
                if (list.size() > 1) {
                    throw new IllegalStateException("Found more than one config by name: " + name + ", instances: " + list + ". Please remove redundant configs or get config by id.");
                }
                if (list.size() == 1) {
                    return (AbstractConfig)list.get(0);
                }
            }
            return null;
        });
    }

    private <C extends AbstractConfig> String getConfigName(C config) {
        try {
            return (String)ReflectUtils.getProperty(config, CONFIG_NAME_READ_METHOD);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected <C extends AbstractConfig> C getSingleConfig(String configType) throws IllegalStateException {
        return (C)this.read(() -> {
            Map configsMap = this.configsCache.getOrDefault(configType, Collections.emptyMap());
            int size = configsMap.size();
            if (size < 1) {
                return null;
            }
            if (size > 1) {
                throw new IllegalStateException("Expected single instance of " + configType + ", but found " + size + " instances, please remove redundant configs. instances: " + configsMap.values());
            }
            return (AbstractConfig)configsMap.values().iterator().next();
        });
    }

    private <V> V write(Callable<V> callable) {
        V value = null;
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            value = callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getCause());
        }
        finally {
            writeLock.unlock();
        }
        return value;
    }

    private void write(Runnable runnable) {
        this.write(() -> {
            runnable.run();
            return null;
        });
    }

    private <V> V read(Callable<V> callable) {
        Lock readLock = this.lock.readLock();
        V value = null;
        try {
            readLock.lock();
            value = callable.call();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            readLock.unlock();
        }
        return value;
    }

    private static void checkDuplicate(AbstractConfig oldOne, AbstractConfig newOne) throws IllegalStateException {
        if (!ConfigManager.isEquals(oldOne, newOne)) {
            String configName = oldOne.getClass().getSimpleName();
            throw new IllegalStateException("Duplicate Configs found for " + configName + ", only one unique " + configName + " is allowed for one application. old: " + oldOne + ", new: " + newOne);
        }
    }

    private static boolean isEquals(AbstractConfig oldOne, AbstractConfig newOne) {
        if (oldOne == newOne) {
            return true;
        }
        if (oldOne == null || newOne == null) {
            return false;
        }
        if (oldOne.getClass() != newOne.getClass()) {
            return false;
        }
        if (oldOne.isRefreshed() || newOne.isRefreshed()) {
            if (!oldOne.isRefreshed()) {
                oldOne.refresh();
            }
            if (!newOne.isRefreshed()) {
                newOne.refresh();
            }
        }
        return oldOne.equals(newOne);
    }

    private static Map newMap() {
        return new HashMap();
    }

    static <C extends AbstractConfig> C addIfAbsent(C config, Map<String, C> configsMap, boolean unique) throws IllegalStateException {
        AbstractConfig existedConfig;
        String key;
        Optional<AbstractConfig> prevConfig;
        if (config == null || configsMap == null) {
            return config;
        }
        if (unique) {
            configsMap.values().forEach(c -> ConfigManager.checkDuplicate(c, config));
        }
        if ((prevConfig = configsMap.values().stream().filter(val -> ConfigManager.isEquals(val, config)).findFirst()).isPresent()) {
            if (prevConfig.get() == config) {
                return (C)prevConfig.get();
            }
            if (unique) {
                if (logger.isInfoEnabled()) {
                    logger.info("Ignore duplicated config: " + config);
                }
                return (C)prevConfig.get();
            }
        }
        if ((key = ConfigManager.getId(config)) == null) {
            key = ConfigManager.generateConfigId(config);
        }
        if (ConfigManager.isEquals(existedConfig = (AbstractConfig)configsMap.get(key), config)) {
            String type = config.getClass().getSimpleName();
            throw new IllegalStateException(String.format("Duplicate %s found, there already has one default %s or more than two %ss have the same id, you can try to give each %s a different id, key: %s, prev: %s, new: %s", type, type, type, type, key, existedConfig, config));
        }
        configsMap.put(key, config);
        return config;
    }

    public static <C extends AbstractConfig> String generateConfigId(C config) {
        int idx = configIdIndexes.computeIfAbsent(config.getClass(), clazz -> new AtomicInteger(0)).incrementAndGet();
        return config.getClass().getSimpleName() + "#" + idx;
    }

    static <C extends AbstractConfig> String getId(C config) {
        String id = config.getId();
        return StringUtils.isNotEmpty(id) ? id : null;
    }

    static <C extends AbstractConfig> Boolean isDefaultConfig(C config) {
        return config.isDefault();
    }

    static <C extends AbstractConfig> List<C> getDefaultConfigs(Map<String, C> configsMap) {
        List list = configsMap.values().stream().filter(c -> Boolean.TRUE.equals(ConfigManager.isDefaultConfig(c))).collect(Collectors.toList());
        if (list.size() > 0) {
            return list;
        }
        list = configsMap.values().stream().filter(c -> ConfigManager.isDefaultConfig(c) == null).collect(Collectors.toList());
        return list;
    }

    static {
        uniqueConfigTypes.add(ApplicationConfig.class);
        uniqueConfigTypes.add(ModuleConfig.class);
        uniqueConfigTypes.add(MonitorConfig.class);
        uniqueConfigTypes.add(MetricsConfig.class);
        uniqueConfigTypes.add(SslConfig.class);
    }
}

