/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.MetadataServiceExporter;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigurableMetadataServiceExporter
implements MetadataServiceExporter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MetadataService metadataService;
    private volatile ServiceConfig<MetadataService> serviceConfig;

    public ConfigurableMetadataServiceExporter(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    @Override
    public ConfigurableMetadataServiceExporter export() {
        if (!this.isExported()) {
            ServiceConfig<MetadataService> serviceConfig = new ServiceConfig<MetadataService>();
            serviceConfig.setApplication(this.getApplicationConfig());
            serviceConfig.setRegistry(new RegistryConfig("N/A"));
            serviceConfig.setProtocol(this.generateMetadataProtocol());
            serviceConfig.setInterface(MetadataService.class);
            serviceConfig.setRef(this.metadataService);
            serviceConfig.setGroup(this.getApplicationConfig().getName());
            serviceConfig.setVersion(this.metadataService.version());
            serviceConfig.setMethods(this.generateMethodConfig());
            serviceConfig.export();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("The MetadataService exports urls : " + serviceConfig.getExportedUrls());
            }
            this.serviceConfig = serviceConfig;
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("The MetadataService has been exported : " + this.serviceConfig.getExportedUrls());
        }
        return this;
    }

    private List<MethodConfig> generateMethodConfig() {
        MethodConfig methodConfig = new MethodConfig();
        methodConfig.setName("getAndListenInstanceMetadata");
        ArgumentConfig argumentConfig = new ArgumentConfig();
        argumentConfig.setIndex(1);
        argumentConfig.setCallback(true);
        methodConfig.setArguments(Collections.singletonList(argumentConfig));
        return Collections.singletonList(methodConfig);
    }

    @Override
    public ConfigurableMetadataServiceExporter unexport() {
        if (this.isExported()) {
            this.serviceConfig.unexport();
        }
        return this;
    }

    @Override
    public List<URL> getExportedURLs() {
        return this.serviceConfig != null ? this.serviceConfig.getExportedUrls() : Collections.emptyList();
    }

    @Override
    public boolean isExported() {
        return this.serviceConfig != null && this.serviceConfig.isExported();
    }

    private ApplicationConfig getApplicationConfig() {
        return ApplicationModel.getConfigManager().getApplication().get();
    }

    private ProtocolConfig generateMetadataProtocol() {
        ProtocolConfig defaultProtocol = new ProtocolConfig();
        Integer port = this.getApplicationConfig().getMetadataServicePort();
        if (port == null || port < -1) {
            List<ProtocolConfig> defaultProtocols;
            ProtocolConfig dubboProtocol;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Metadata Service Port hasn't been set will use default protocol defined in protocols.");
            }
            if ((dubboProtocol = this.findDubboProtocol(defaultProtocols = ApplicationModel.getConfigManager().getDefaultProtocols())) != null) {
                this.logger.info("Using dubbo protocol " + dubboProtocol + " to export MetadataService.");
                return dubboProtocol;
            }
            defaultProtocol.setName("dubbo");
            defaultProtocol.setPort(-1);
        } else {
            defaultProtocol.setName("dubbo");
            defaultProtocol.setPort(port);
        }
        this.logger.info("Using dubbo protocol " + defaultProtocol + " to export MetadataService.");
        return defaultProtocol;
    }

    private ProtocolConfig findDubboProtocol(List<ProtocolConfig> protocolConfigs) {
        if (CollectionUtils.isEmpty(protocolConfigs)) {
            return null;
        }
        for (ProtocolConfig protocolConfig : protocolConfigs) {
            if (!"dubbo".equalsIgnoreCase(protocolConfig.getName())) continue;
            return protocolConfig;
        }
        return null;
    }
}

