/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ServiceInstanceHostPortCustomizer
implements ServiceInstanceCustomizer {
    @Override
    public void customize(ServiceInstance serviceInstance) {
        if (serviceInstance.getPort() > 0) {
            return;
        }
        WritableMetadataService writableMetadataService = WritableMetadataService.getDefaultExtension();
        String host = null;
        int port = -1;
        Set<URL> urls = writableMetadataService.getExportedServiceURLs();
        if (CollectionUtils.isNotEmpty(urls)) {
            String preferredProtocol = ApplicationModel.getApplicationConfig().getProtocol();
            if (preferredProtocol != null) {
                for (URL exportedURL : urls) {
                    if (!preferredProtocol.equals(exportedURL.getProtocol())) continue;
                    host = exportedURL.getHost();
                    port = exportedURL.getPort();
                    break;
                }
            } else {
                URL url = urls.iterator().next();
                host = url.getHost();
                port = url.getPort();
            }
            if (serviceInstance instanceof DefaultServiceInstance) {
                DefaultServiceInstance instance = (DefaultServiceInstance)serviceInstance;
                instance.setHost(host);
                instance.setPort(port);
            }
        }
    }
}

