/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.spring.ConfigCenterBean;
import org.apache.dubbo.config.spring.reference.ReferenceBeanManager;
import org.apache.dubbo.config.spring.util.EnvironmentUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class DubboConfigInitializationPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
ApplicationContextAware,
Ordered {
    public static String BEAN_NAME = "dubboConfigInitializationPostProcessor";
    @Value(value="${dubbo.config-initialization-post-processor.order:1000}")
    private int order = 1000;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private ConfigurableListableBeanFactory beanFactory;
    private ReferenceBeanManager referenceBeanManager;
    private ApplicationContext applicationContext;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.initialized.compareAndSet(false, true)) {
            try {
                this.prepareDubboConfigBeans(this.beanFactory);
                this.prepareReferenceBeans(this.beanFactory);
            }
            catch (Throwable e) {
                throw new FatalBeanException("Initialization dubbo config beans failed", e);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        this.referenceBeanManager = (ReferenceBeanManager)beanFactory.getBean("dubboReferenceBeanManager", ReferenceBeanManager.class);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private void prepareReferenceBeans(ConfigurableListableBeanFactory beanFactory) throws Exception {
        ReferenceBeanManager referenceBeanManager = (ReferenceBeanManager)beanFactory.getBean("dubboReferenceBeanManager", ReferenceBeanManager.class);
        referenceBeanManager.prepareReferenceBeans();
    }

    private void prepareDubboConfigBeans(ConfigurableListableBeanFactory beanFactory) {
        BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, ApplicationConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, ModuleConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, RegistryConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, ProtocolConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, MonitorConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, ProviderConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, ConsumerConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, ConfigCenterBean.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, MetadataReportConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, MetricsConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, SslConfig.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        ConfigurableEnvironment environment = (ConfigurableEnvironment)applicationContext.getEnvironment();
        SortedMap<String, String> dubboProperties = EnvironmentUtils.filterDubboProperties(environment);
        ApplicationModel.getEnvironment().setAppConfigMap(dubboProperties);
    }
}

