/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import org.apache.dubbo.config.spring.extension.SpringExtensionFactory;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DubboInfraBeanRegisterPostProcessor
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    public static final String BEAN_NAME = "dubboInfraBeanRegisterPostProcessor";
    private BeanDefinitionRegistry registry;
    private ApplicationContext applicationContext;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        DubboBeanUtils.registerBeansIfNotExists(this.registry);
        beanFactory.registerSingleton("dubboConfigManager", (Object)ApplicationModel.getConfigManager());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        SpringExtensionFactory.addApplicationContext(applicationContext);
    }
}

