/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.reference;

import com.alibaba.spring.util.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.reference.ReferenceCreator;
import org.apache.dubbo.rpc.service.GenericService;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.ObjectUtils;

public class ReferenceBeanSupport {
    public static void convertReferenceProps(Map<String, Object> attributes, Class defaultInterfaceClass) {
        String[] registryIds;
        String oldGeneric;
        String interfaceName = (String)attributes.get("interface");
        if (interfaceName == null) {
            interfaceName = (String)attributes.get("interfaceName");
        }
        if (interfaceName == null) {
            Class clazz = (Class)attributes.get("interfaceClass");
            String string = interfaceName = clazz != null ? clazz.getName() : null;
        }
        if (interfaceName == null && defaultInterfaceClass != GenericService.class) {
            interfaceName = defaultInterfaceClass.getName();
        }
        Assert.notEmptyString(interfaceName, "The interface class or name of reference was not found");
        attributes.put("interface", interfaceName);
        attributes.remove("interfaceName");
        attributes.remove("interfaceClass");
        String generic = String.valueOf(defaultInterfaceClass == GenericService.class);
        String string = oldGeneric = attributes.containsValue("generic") ? String.valueOf(attributes.get("generic")) : "false";
        if (!StringUtils.isEquals(oldGeneric, generic)) {
            attributes.put("generic", generic);
        }
        if ((registryIds = (String[])attributes.get("registry")) != null) {
            String value = StringUtils.join(registryIds, ",");
            attributes.remove("registry");
            attributes.put("registryIds", value);
        }
    }

    public static String generateReferenceKey(Map<String, Object> attributes, PropertyResolver propertyResolver) {
        String interfaceClass = (String)attributes.get("interface");
        Assert.notEmptyString(interfaceClass, "No interface class or name found from attributes");
        String group = (String)attributes.get("group");
        String version = (String)attributes.get("version");
        StringBuilder beanNameBuilder = new StringBuilder("ReferenceBean:");
        if (StringUtils.isNotEmpty(group)) {
            beanNameBuilder.append(group).append("/");
        }
        beanNameBuilder.append(interfaceClass);
        if (StringUtils.isNotEmpty(version)) {
            beanNameBuilder.append(":").append(version);
        }
        beanNameBuilder.append('(');
        ArrayList<String> sortedAttrKeys = new ArrayList<String>(attributes.keySet());
        Collections.sort(sortedAttrKeys);
        List<String> ignoredAttrs = Arrays.asList("id", "group", "version", "interface", "interfaceName", "interfaceClass");
        for (String key : sortedAttrKeys) {
            if (ignoredAttrs.contains(key)) continue;
            Object value = attributes.get(key);
            value = ReferenceBeanSupport.convertToString(key, value);
            beanNameBuilder.append(key).append('=').append(value).append(',');
        }
        if (beanNameBuilder.charAt(beanNameBuilder.length() - 1) == ',') {
            beanNameBuilder.setCharAt(beanNameBuilder.length() - 1, ')');
        } else {
            beanNameBuilder.append(')');
        }
        String referenceKey = beanNameBuilder.toString();
        if (propertyResolver != null) {
            referenceKey = propertyResolver.resolveRequiredPlaceholders(referenceKey);
        }
        return referenceKey;
    }

    private static String convertToString(String key, Object obj) {
        if (obj == null) {
            return null;
        }
        if ("parameters".equals(key) && obj instanceof String[]) {
            obj = ReferenceCreator.convertStringArrayToMap((String[])obj);
        }
        if (obj instanceof Annotation) {
            AnnotationAttributes attributes = AnnotationUtils.getAnnotationAttributes((Annotation)((Annotation)obj), (boolean)true, (String[])new String[0]);
            for (Map.Entry entry : attributes.entrySet()) {
                entry.setValue(ReferenceBeanSupport.convertToString((String)entry.getKey(), entry.getValue()));
            }
            return String.valueOf(attributes);
        }
        if (obj.getClass().isArray()) {
            Object[] array = ObjectUtils.toObjectArray((Object)obj);
            Object[] newArray = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                newArray[i] = ReferenceBeanSupport.convertToString(null, array[i]);
            }
            Arrays.sort(newArray);
            return Arrays.toString(newArray);
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            TreeMap newMap = new TreeMap();
            for (Map.Entry entry : map.entrySet()) {
                newMap.put(entry.getKey(), ReferenceBeanSupport.convertToString((String)entry.getKey(), entry.getValue()));
            }
            return String.valueOf(newMap);
        }
        return String.valueOf(obj);
    }

    public static Map<String, Object> convertPropertyValues(MutablePropertyValues propertyValues) {
        LinkedHashMap<String, Object> referenceProps = new LinkedHashMap<String, Object>();
        for (PropertyValue propertyValue : propertyValues.getPropertyValueList()) {
            String propertyName = propertyValue.getName();
            Object[] value = propertyValue.getValue();
            if ("methods".equals(propertyName) || "arguments".equals(propertyName)) {
                ManagedList managedList = (ManagedList)value;
                ArrayList<Map<String, Object>> elementList = new ArrayList<Map<String, Object>>();
                for (Object el : managedList) {
                    Map<String, Object> element = ReferenceBeanSupport.convertPropertyValues(((BeanDefinitionHolder)el).getBeanDefinition().getPropertyValues());
                    element.remove("id");
                    elementList.add(element);
                }
                value = elementList.toArray(new Object[0]);
            } else if ("parameters".equals(propertyName)) {
                value = ReferenceBeanSupport.createParameterMap((ManagedMap)value);
            }
            if (value instanceof RuntimeBeanReference) {
                RuntimeBeanReference beanReference = (RuntimeBeanReference)value;
                value = beanReference.getBeanName();
            }
            if (value == null || value instanceof String && StringUtils.isBlank((String)value)) continue;
            referenceProps.put(propertyName, value);
        }
        return referenceProps;
    }

    private static Map<String, String> createParameterMap(ManagedMap managedMap) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Set entrySet = managedMap.entrySet();
        for (Map.Entry entry : entrySet) {
            map.put((String)entry.getKey(), ((TypedStringValue)entry.getValue()).getValue());
        }
        return map;
    }

    public static String generateReferenceKey(ReferenceBean referenceBean, PropertyResolver propertyResolver) {
        return ReferenceBeanSupport.generateReferenceKey(ReferenceBeanSupport.getReferenceAttributes(referenceBean), propertyResolver);
    }

    public static String generateReferenceKey(BeanDefinition beanDefinition, PropertyResolver propertyResolver) {
        return ReferenceBeanSupport.generateReferenceKey(ReferenceBeanSupport.getReferenceAttributes(beanDefinition), propertyResolver);
    }

    public static Map<String, Object> getReferenceAttributes(ReferenceBean referenceBean) {
        Map<String, Object> referenceProps = referenceBean.getReferenceProps();
        if (referenceProps == null) {
            MutablePropertyValues propertyValues = referenceBean.getPropertyValues();
            if (propertyValues == null) {
                throw new RuntimeException("ReferenceBean is invalid, 'referenceProps' and 'propertyValues' cannot both be empty.");
            }
            referenceProps = ReferenceBeanSupport.convertPropertyValues(propertyValues);
        }
        return referenceProps;
    }

    public static Map<String, Object> getReferenceAttributes(BeanDefinition beanDefinition) {
        Map referenceProps = null;
        referenceProps = beanDefinition.hasAttribute("referenceProps") ? (Map)beanDefinition.getAttribute("referenceProps") : ReferenceBeanSupport.convertPropertyValues(beanDefinition.getPropertyValues());
        return referenceProps;
    }
}

