/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.reference;

import com.alibaba.spring.util.AnnotationUtils;
import com.alibaba.spring.util.BeanFactoryUtils;
import com.alibaba.spring.util.ObjectUtils;
import java.beans.PropertyEditor;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.annotation.Argument;
import org.apache.dubbo.config.annotation.Method;
import org.apache.dubbo.config.spring.beans.factory.annotation.AnnotationPropertyValuesAdapter;
import org.apache.dubbo.config.spring.reference.ReferenceBeanSupport;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

public class ReferenceCreator {
    static final String[] IGNORE_FIELD_NAMES = (String[])ObjectUtils.of((Object[])new String[]{"application", "module", "consumer", "monitor", "registry", "interfaceClass"});
    private static final String ONRETURN = "onreturn";
    private static final String ONTHROW = "onthrow";
    private static final String ONINVOKE = "oninvoke";
    private static final String METHOD = "Method";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final Map<String, Object> attributes;
    protected final ApplicationContext applicationContext;
    protected final ClassLoader classLoader;
    protected Class<?> defaultInterfaceClass;

    private ReferenceCreator(Map<String, Object> attributes, ApplicationContext applicationContext) {
        Assert.notNull(attributes, (String)"The Annotation attributes must not be null!");
        Assert.notNull((Object)applicationContext, (String)"The ApplicationContext must not be null!");
        this.attributes = attributes;
        this.applicationContext = applicationContext;
        this.classLoader = applicationContext.getClassLoader() != null ? applicationContext.getClassLoader() : Thread.currentThread().getContextClassLoader();
    }

    public final ReferenceConfig build() throws Exception {
        ReferenceConfig configBean = new ReferenceConfig();
        this.configureBean(configBean);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("The configBean[type:" + configBean.getClass().getSimpleName() + "] has been built."));
        }
        return configBean;
    }

    protected void configureBean(ReferenceConfig configBean) throws Exception {
        this.populateBean(this.attributes, configBean);
        this.configureMonitorConfig(configBean);
        this.configureApplicationConfig(configBean);
        this.configureModuleConfig(configBean);
        this.configureConsumerConfig(this.attributes, configBean);
    }

    private void configureRegistryConfigs(ReferenceConfig configBean) {
        String[] registryConfigBeanIds = (String[])AnnotationUtils.getAttribute(this.attributes, (String)"registry");
        if (registryConfigBeanIds != null) {
            List registryConfigs = BeanFactoryUtils.getBeans((ListableBeanFactory)this.applicationContext, (String[])registryConfigBeanIds, RegistryConfig.class);
            configBean.setRegistries(registryConfigs);
        }
    }

    private void configureMonitorConfig(ReferenceConfig configBean) {
        String monitorBeanName = (String)AnnotationUtils.getAttribute(this.attributes, (String)"monitor");
        MonitorConfig monitorConfig = (MonitorConfig)BeanFactoryUtils.getOptionalBean((ListableBeanFactory)this.applicationContext, (String)monitorBeanName, MonitorConfig.class);
        configBean.setMonitor(monitorConfig);
    }

    private void configureApplicationConfig(ReferenceConfig configBean) {
        String applicationConfigBeanName = (String)AnnotationUtils.getAttribute(this.attributes, (String)"application");
        ApplicationConfig applicationConfig = (ApplicationConfig)BeanFactoryUtils.getOptionalBean((ListableBeanFactory)this.applicationContext, (String)applicationConfigBeanName, ApplicationConfig.class);
        configBean.setApplication(applicationConfig);
    }

    private void configureModuleConfig(ReferenceConfig configBean) {
        String moduleConfigBeanName = (String)AnnotationUtils.getAttribute(this.attributes, (String)"module");
        ModuleConfig moduleConfig = (ModuleConfig)BeanFactoryUtils.getOptionalBean((ListableBeanFactory)this.applicationContext, (String)moduleConfigBeanName, ModuleConfig.class);
        configBean.setModule(moduleConfig);
    }

    private void configureInterface(Map<String, Object> attributes, ReferenceConfig referenceBean) {
        if (referenceBean.getInterface() == null) {
            Object genericValue = AnnotationUtils.getAttribute(attributes, (String)"generic");
            String generic = genericValue != null ? genericValue.toString() : null;
            referenceBean.setGeneric(generic);
            String interfaceClassName = (String)AnnotationUtils.getAttribute(attributes, (String)"interfaceName");
            if (StringUtils.hasText((String)interfaceClassName)) {
                referenceBean.setInterface(interfaceClassName);
            } else {
                Class<?> interfaceClass = (Class<?>)AnnotationUtils.getAttribute(attributes, (String)"interfaceClass");
                if (Void.TYPE.equals(interfaceClass)) {
                    interfaceClass = null;
                }
                if (interfaceClass != null) {
                    Assert.isTrue((boolean)interfaceClass.isInterface(), (String)("The interfaceClass of @DubboReference is not an interface: " + interfaceClass.getName()));
                }
                if (interfaceClass == null && this.defaultInterfaceClass != null) {
                    interfaceClass = this.defaultInterfaceClass;
                    Assert.isTrue((boolean)interfaceClass.isInterface(), (String)"The class of field or method that was annotated @DubboReference is not an interface!");
                }
                referenceBean.setInterface(interfaceClass.getName());
            }
        }
    }

    private void configureConsumerConfig(Map<String, Object> attributes, ReferenceConfig<?> referenceBean) {
        ConsumerConfig consumerConfig = null;
        Object consumer = AnnotationUtils.getAttribute(attributes, (String)"consumer");
        if (consumer != null) {
            if (consumer instanceof String) {
                consumerConfig = (ConsumerConfig)BeanFactoryUtils.getOptionalBean((ListableBeanFactory)this.applicationContext, (String)((String)consumer), ConsumerConfig.class);
            } else if (consumer instanceof ConsumerConfig) {
                consumerConfig = (ConsumerConfig)consumer;
            } else {
                throw new IllegalArgumentException("Unexpected 'consumer' attribute value: " + consumer);
            }
            referenceBean.setConsumer(consumerConfig);
        }
    }

    void configureMethodConfig(Map<String, Object> attributes, ReferenceConfig<?> referenceBean) {
        Object value = attributes.get("methods");
        if (value instanceof Method[]) {
            Method[] methods = (Method[])value;
            List<MethodConfig> methodConfigs = MethodConfig.constructMethodConfig(methods);
            if (!methodConfigs.isEmpty()) {
                referenceBean.setMethods(methodConfigs);
            }
        } else if (value instanceof MethodConfig[]) {
            MethodConfig[] methodConfigs = (MethodConfig[])value;
            referenceBean.setMethods(Arrays.asList(methodConfigs));
        }
    }

    protected void populateBean(Map<String, Object> attributes, ReferenceConfig referenceBean) {
        Assert.notNull(this.defaultInterfaceClass, (String)"The default interface class cannot be empty!");
        ReferenceBeanSupport.convertReferenceProps(attributes, this.defaultInterfaceClass);
        DataBinder dataBinder = new DataBinder((Object)referenceBean);
        dataBinder.registerCustomEditor(String.class, "filter", (PropertyEditor)new StringTrimmerEditor(true));
        dataBinder.registerCustomEditor(String.class, "listener", (PropertyEditor)new StringTrimmerEditor(true));
        final DefaultConversionService conversionService = new DefaultConversionService();
        conversionService.addConverter(String[].class, Map.class, (Converter)new Converter<String[], Map>(){

            public Map convert(String[] source) {
                return ReferenceCreator.convertStringArrayToMap(source);
            }
        });
        conversionService.addConverter(Map.class, MethodConfig.class, (Converter)new Converter<Map, MethodConfig>(){

            public MethodConfig convert(Map source) {
                return ReferenceCreator.this.createMethodConfig(source, conversionService);
            }
        });
        conversionService.addConverter(Method.class, MethodConfig.class, (Converter)new Converter<Method, MethodConfig>(){

            public MethodConfig convert(Method source) {
                AnnotationAttributes methodAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)source, (boolean)true, (String[])new String[0]);
                return ReferenceCreator.this.createMethodConfig((Map)methodAttributes, conversionService);
            }
        });
        conversionService.addConverter(Map.class, ArgumentConfig.class, (Converter)new Converter<Map, ArgumentConfig>(){

            public ArgumentConfig convert(Map source) {
                ArgumentConfig argumentConfig = new ArgumentConfig();
                DataBinder argDataBinder = new DataBinder((Object)argumentConfig);
                argDataBinder.setConversionService((ConversionService)conversionService);
                argDataBinder.bind((PropertyValues)new AnnotationPropertyValuesAdapter(source, (PropertyResolver)ReferenceCreator.this.applicationContext.getEnvironment(), new String[0]));
                return argumentConfig;
            }
        });
        conversionService.addConverter(Argument.class, ArgumentConfig.class, (Converter)new Converter<Argument, ArgumentConfig>(){

            public ArgumentConfig convert(Argument source) {
                ArgumentConfig argumentConfig = new ArgumentConfig();
                DataBinder argDataBinder = new DataBinder((Object)argumentConfig);
                argDataBinder.setConversionService((ConversionService)conversionService);
                argDataBinder.bind((PropertyValues)new AnnotationPropertyValuesAdapter((Annotation)source, (PropertyResolver)ReferenceCreator.this.applicationContext.getEnvironment(), new String[0]));
                return argumentConfig;
            }
        });
        dataBinder.setConversionService((ConversionService)conversionService);
        dataBinder.bind((PropertyValues)new AnnotationPropertyValuesAdapter(attributes, (PropertyResolver)this.applicationContext.getEnvironment(), IGNORE_FIELD_NAMES));
    }

    private MethodConfig createMethodConfig(Map<String, Object> methodAttributes, DefaultConversionService conversionService) {
        String[] callbacks;
        for (String callbackName : callbacks = new String[]{ONINVOKE, ONRETURN, ONTHROW}) {
            Object value = methodAttributes.get(callbackName);
            if (!(value instanceof String)) continue;
            String strValue = (String)value;
            int index = strValue.lastIndexOf(".");
            if (index != -1) {
                String beanName = strValue.substring(0, index);
                String methodName = strValue.substring(index + 1);
                methodAttributes.put(callbackName, this.applicationContext.getBean(beanName));
                methodAttributes.put(callbackName + METHOD, methodName);
                continue;
            }
            methodAttributes.put(callbackName, this.applicationContext.getBean(strValue));
        }
        MethodConfig methodConfig = new MethodConfig();
        DataBinder mcDataBinder = new DataBinder((Object)methodConfig);
        mcDataBinder.setConversionService((ConversionService)conversionService);
        AnnotationPropertyValuesAdapter propertyValues = new AnnotationPropertyValuesAdapter(methodAttributes, (PropertyResolver)this.applicationContext.getEnvironment(), new String[0]);
        mcDataBinder.bind((PropertyValues)propertyValues);
        return methodConfig;
    }

    public static Map convertStringArrayToMap(String[] source) {
        String content = StringUtils.arrayToCommaDelimitedString((Object[])source);
        if (!StringUtils.hasText((String)(content = StringUtils.trimAllWhitespace((String)content)))) {
            return null;
        }
        content = StringUtils.replace((String)content, (String)"=", (String)",");
        content = StringUtils.replace((String)content, (String)":", (String)",");
        Map<String, String> parameters = CollectionUtils.toStringMap(StringUtils.commaDelimitedListToStringArray((String)content));
        return parameters;
    }

    public static ReferenceCreator create(Map<String, Object> attributes, ApplicationContext applicationContext) {
        return new ReferenceCreator(attributes, applicationContext);
    }

    public ReferenceCreator defaultInterfaceClass(Class<?> interfaceClass) {
        this.defaultInterfaceClass = interfaceClass;
        return this;
    }
}

