/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.nacos;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;

public class NacosConfigServiceWrapper {
    private static final String INNERCLASS_SYMBOL = "$";
    private static final String INNERCLASS_COMPATIBLE_SYMBOL = "___";
    private static final long DEFAULT_TIMEOUT = 3000L;
    private ConfigService configService;

    public NacosConfigServiceWrapper(ConfigService configService) {
        this.configService = configService;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public void addListener(String dataId, String group, Listener listener) throws NacosException {
        this.configService.addListener(this.handleInnerSymbol(dataId), this.handleInnerSymbol(group), listener);
    }

    public String getConfig(String dataId, String group) throws NacosException {
        return this.configService.getConfig(this.handleInnerSymbol(dataId), this.handleInnerSymbol(group), 3000L);
    }

    public String getConfig(String dataId, String group, long timeout) throws NacosException {
        return this.configService.getConfig(this.handleInnerSymbol(dataId), this.handleInnerSymbol(group), timeout);
    }

    public boolean publishConfig(String dataId, String group, String content) throws NacosException {
        return this.configService.publishConfig(this.handleInnerSymbol(dataId), this.handleInnerSymbol(group), content);
    }

    public boolean publishConfigCas(String dataId, String group, String content, String casMd5) throws NacosException {
        return this.configService.publishConfigCas(this.handleInnerSymbol(dataId), this.handleInnerSymbol(group), content, casMd5);
    }

    public boolean removeConfig(String dataId, String group) throws NacosException {
        return this.configService.removeConfig(this.handleInnerSymbol(dataId), this.handleInnerSymbol(group));
    }

    private String handleInnerSymbol(String data) {
        if (data == null) {
            return null;
        }
        return data.replace(INNERCLASS_SYMBOL, INNERCLASS_COMPATIBLE_SYMBOL).replace('/', '-');
    }
}

