/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.qos.command.BaseCommand;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.annotation.Cmd;
import org.apache.dubbo.qos.probe.StartupProbe;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Cmd(name="startup", summary="Judge if service has started? ")
public class Startup
implements BaseCommand {
    @Override
    public String execute(CommandContext commandContext, String[] args) {
        URL url = URL.valueOf("application://").addParameter("dubbo.application.startup-probe", ApplicationModel.getApplicationConfig().getStartupProbe());
        List<StartupProbe> startupProbes = ExtensionLoader.getExtensionLoader(StartupProbe.class).getActivateExtension(url, "dubbo.application.startup-probe");
        if (!startupProbes.isEmpty()) {
            for (StartupProbe startupProbe : startupProbes) {
                if (startupProbe.check()) continue;
                commandContext.setHttpCode(503);
                return "false";
            }
        }
        commandContext.setHttpCode(200);
        return "true";
    }
}

