/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.event.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.InstanceAddressURL;
import org.apache.dubbo.registry.client.RegistryClusterIdentifier;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.RetryServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.store.RemoteMetadataServiceImpl;

public class ServiceInstancesChangedListener {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInstancesChangedListener.class);
    protected final Set<String> serviceNames;
    protected final ServiceDiscovery serviceDiscovery;
    protected URL url;
    protected Map<String, NotifyListener> listeners;
    protected AtomicBoolean destroyed = new AtomicBoolean(false);
    protected Map<String, List<ServiceInstance>> allInstances;
    protected Map<String, Object> serviceUrls;
    protected Map<String, MetadataInfo> revisionToMetadata;
    private volatile long lastRefreshTime;
    private volatile long lastFailureTime;
    private volatile AtomicInteger failureCounter = new AtomicInteger(0);
    private Semaphore retryPermission;
    private volatile ScheduledFuture<?> retryFuture;
    private static ScheduledExecutorService scheduler = ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension().getMetadataRetryExecutor();

    public ServiceInstancesChangedListener(Set<String> serviceNames, ServiceDiscovery serviceDiscovery) {
        this.serviceNames = serviceNames;
        this.serviceDiscovery = serviceDiscovery;
        this.listeners = new ConcurrentHashMap<String, NotifyListener>();
        this.allInstances = new HashMap<String, List<ServiceInstance>>();
        this.serviceUrls = new HashMap<String, Object>();
        this.revisionToMetadata = new HashMap<String, MetadataInfo>();
        this.retryPermission = new Semaphore(1);
    }

    public synchronized void onEvent(ServiceInstancesChangedEvent event) {
        if (this.destroyed.get() || this.isRetryAndExpired(event) || !this.accept(event)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(event.getServiceInstances().toString());
        }
        HashMap<String, List> revisionToInstances = new HashMap<String, List>();
        HashMap<MetadataInfo.ServiceInfo, Set<String>> localServiceToRevisions = new HashMap<MetadataInfo.ServiceInfo, Set<String>>();
        HashMap protocolRevisionsToUrls = new HashMap();
        HashMap<String, Object> newServiceUrls = new HashMap<String, Object>();
        HashMap<String, MetadataInfo> newRevisionToMetadata = new HashMap<String, MetadataInfo>();
        for (Map.Entry<String, List<ServiceInstance>> entry : this.allInstances.entrySet()) {
            List<ServiceInstance> instances = entry.getValue();
            for (ServiceInstance instance : instances) {
                String revision = ServiceInstanceMetadataUtils.getExportedServicesRevision(instance);
                if ("0".equals(revision)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Find instance without valid service metadata: " + instance.getAddress());
                    continue;
                }
                List subInstances = revisionToInstances.computeIfAbsent(revision, r -> new LinkedList());
                subInstances.add(instance);
                MetadataInfo metadata = this.getRemoteMetadata(instance, revision, localServiceToRevisions, subInstances);
                ((DefaultServiceInstance)instance).setServiceMetadata(metadata);
                newRevisionToMetadata.putIfAbsent(revision, metadata);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(newRevisionToMetadata.size() + " unique revisions: " + newRevisionToMetadata.keySet());
        }
        if (this.hasEmptyMetadata(newRevisionToMetadata) && this.retryPermission.tryAcquire()) {
            this.retryFuture = scheduler.schedule(new AddressRefreshRetryTask(this.retryPermission), 10000L, TimeUnit.MILLISECONDS);
            logger.warn("Address refresh try task submitted.");
        }
        this.revisionToMetadata = newRevisionToMetadata;
        localServiceToRevisions.forEach((serviceInfo, revisions) -> {
            String protocol = serviceInfo.getProtocol();
            Map revisionsToUrls = protocolRevisionsToUrls.computeIfAbsent(protocol, k -> new HashMap());
            Object urls = revisionsToUrls.get(revisions);
            if (urls == null) {
                urls = this.getServiceUrlsCache((Map<String, List<ServiceInstance>>)revisionToInstances, (Set<String>)revisions, protocol);
                revisionsToUrls.put(revisions, urls);
            }
            newServiceUrls.put(serviceInfo.getMatchKey(), urls);
        });
        this.serviceUrls = newServiceUrls;
        this.notifyAddressChanged();
    }

    public synchronized void addListenerAndNotify(String serviceKey, NotifyListener listener) {
        this.listeners.put(serviceKey, listener);
        List<URL> urls = this.getAddresses(serviceKey);
        if (CollectionUtils.isNotEmpty(urls)) {
            listener.notify(urls);
        }
    }

    public void removeListener(String serviceKey) {
        this.listeners.remove(serviceKey);
        logger.info("Interface listener of interface " + serviceKey + " removed.");
        if (this.listeners.isEmpty()) {
            logger.info("No interface listeners exist, will stop instance listener for " + this.getServiceNames());
            this.serviceDiscovery.removeServiceInstancesChangedListener(this);
        }
    }

    public boolean hasListeners() {
        return CollectionUtils.isNotEmptyMap(this.listeners);
    }

    public final Set<String> getServiceNames() {
        return this.serviceNames;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public Map<String, List<ServiceInstance>> getAllInstances() {
        return this.allInstances;
    }

    public List<ServiceInstance> getInstancesOfApp(String appName) {
        return this.allInstances.get(appName);
    }

    public Map<String, MetadataInfo> getRevisionToMetadata() {
        return this.revisionToMetadata;
    }

    public MetadataInfo getMetadata(String revision) {
        return this.revisionToMetadata.get(revision);
    }

    private boolean accept(ServiceInstancesChangedEvent event) {
        return this.serviceNames.contains(event.getServiceName());
    }

    protected boolean isRetryAndExpired(ServiceInstancesChangedEvent event) {
        String appName = event.getServiceName();
        List<ServiceInstance> appInstances = event.getServiceInstances();
        if (event instanceof RetryServiceInstancesChangedEvent) {
            RetryServiceInstancesChangedEvent retryEvent = (RetryServiceInstancesChangedEvent)event;
            logger.warn("Received address refresh retry event, " + retryEvent.getFailureRecordTime());
            if (retryEvent.getFailureRecordTime() < this.lastRefreshTime && !this.hasEmptyMetadata(this.revisionToMetadata)) {
                logger.warn("Ignore retry event, event time: " + retryEvent.getFailureRecordTime() + ", last refresh time: " + this.lastRefreshTime);
                return true;
            }
            logger.warn("Retrying address notification...");
        } else {
            logger.info("Received instance notification, serviceName: " + appName + ", instances: " + appInstances.size());
            this.allInstances.put(appName, appInstances);
            this.lastRefreshTime = System.currentTimeMillis();
        }
        return false;
    }

    protected boolean hasEmptyMetadata(Map<String, MetadataInfo> revisionToMetadata) {
        if (revisionToMetadata == null) {
            return false;
        }
        for (Map.Entry<String, MetadataInfo> entry : revisionToMetadata.entrySet()) {
            if (entry.getValue() != MetadataInfo.EMPTY) continue;
            return true;
        }
        return false;
    }

    protected MetadataInfo getRemoteMetadata(ServiceInstance instance, String revision, Map<MetadataInfo.ServiceInfo, Set<String>> localServiceToRevisions, List<ServiceInstance> subInstances) {
        MetadataInfo metadata = this.revisionToMetadata.get(revision);
        if (metadata != null && metadata != MetadataInfo.EMPTY && logger.isDebugEnabled()) {
            logger.debug("MetadataInfo for instance " + instance.getAddress() + "?revision=" + revision + "&cluster=" + instance.getRegistryCluster() + ", " + metadata);
        }
        if (metadata == null || metadata == MetadataInfo.EMPTY && (this.failureCounter.get() < 3 || System.currentTimeMillis() - this.lastFailureTime > 10000L)) {
            metadata = this.getMetadataInfo(instance);
            if (metadata != MetadataInfo.EMPTY) {
                this.failureCounter.set(0);
                this.revisionToMetadata.putIfAbsent(revision, metadata);
                this.parseMetadata(revision, metadata, localServiceToRevisions);
            } else {
                logger.error("Failed to get MetadataInfo for instance " + instance.getAddress() + "?revision=" + revision + "&cluster=" + instance.getRegistryCluster() + ", wait for retry.");
                this.lastFailureTime = System.currentTimeMillis();
                this.failureCounter.incrementAndGet();
            }
        } else if (metadata != MetadataInfo.EMPTY && subInstances.size() == 1) {
            this.parseMetadata(revision, metadata, localServiceToRevisions);
        }
        return metadata;
    }

    protected Map<MetadataInfo.ServiceInfo, Set<String>> parseMetadata(String revision, MetadataInfo metadata, Map<MetadataInfo.ServiceInfo, Set<String>> localServiceToRevisions) {
        Map<String, MetadataInfo.ServiceInfo> serviceInfos = metadata.getServices();
        for (Map.Entry<String, MetadataInfo.ServiceInfo> entry : serviceInfos.entrySet()) {
            Set set = localServiceToRevisions.computeIfAbsent(entry.getValue(), k -> new TreeSet());
            set.add(revision);
        }
        return localServiceToRevisions;
    }

    protected MetadataInfo getMetadataInfo(ServiceInstance instance) {
        MetadataInfo metadataInfo;
        String metadataType = ServiceInstanceMetadataUtils.getMetadataStorageType(instance);
        if (instance.getRegistryCluster() == null) {
            instance.setRegistryCluster(RegistryClusterIdentifier.getExtension(this.url).consumerKey(this.url));
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Instance " + instance.getAddress() + " is using metadata type " + metadataType);
            }
            if ("remote".equals(metadataType)) {
                RemoteMetadataServiceImpl remoteMetadataService = MetadataUtils.getRemoteMetadataService();
                metadataInfo = remoteMetadataService.getMetadata(instance);
            } else {
                MetadataService metadataServiceProxy = MetadataUtils.getMetadataServiceProxy(instance, this.serviceDiscovery);
                metadataInfo = metadataServiceProxy.getMetadataInfo(ServiceInstanceMetadataUtils.getExportedServicesRevision(instance));
            }
        }
        catch (Exception e) {
            logger.error("Failed to load service metadata, meta type is " + metadataType, e);
            metadataInfo = null;
        }
        if (metadataInfo == null) {
            metadataInfo = MetadataInfo.EMPTY;
        }
        return metadataInfo;
    }

    protected Object getServiceUrlsCache(Map<String, List<ServiceInstance>> revisionToInstances, Set<String> revisions, String protocol) {
        ArrayList<InstanceAddressURL> urls = new ArrayList<InstanceAddressURL>();
        for (String r : revisions) {
            for (ServiceInstance i : revisionToInstances.get(r)) {
                DefaultServiceInstance.Endpoint endpoint;
                if (ServiceInstanceMetadataUtils.hasEndpoints(i) && (endpoint = ServiceInstanceMetadataUtils.getEndpoint(i, protocol)) != null && !endpoint.getPort().equals(i.getPort())) {
                    urls.add(((DefaultServiceInstance)i).copy(endpoint).toURL());
                    continue;
                }
                urls.add(i.toURL());
            }
        }
        return urls;
    }

    protected List<URL> getAddresses(String serviceProtocolKey) {
        return (List)this.serviceUrls.get(serviceProtocolKey);
    }

    protected void notifyAddressChanged() {
        this.listeners.forEach((key, notifyListener) -> {
            List<URL> urls = this.toUrlsWithEmpty(this.getAddresses((String)key));
            logger.info("Notify service " + key + " with urls " + urls.size());
            notifyListener.notify(urls);
        });
    }

    protected List<URL> toUrlsWithEmpty(List<URL> urls) {
        if (urls == null) {
            urls = Collections.emptyList();
        }
        return urls;
    }

    public synchronized void destroy() {
        if (!this.destroyed.get() && CollectionUtils.isEmptyMap(this.listeners) && this.destroyed.compareAndSet(false, true)) {
            this.allInstances.clear();
            this.serviceUrls.clear();
            this.revisionToMetadata.clear();
            if (this.retryFuture != null && !this.retryFuture.isDone()) {
                this.retryFuture.cancel(true);
            }
        }
    }

    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceInstancesChangedListener)) {
            return false;
        }
        ServiceInstancesChangedListener that = (ServiceInstancesChangedListener)o;
        return Objects.equals(this.getServiceNames(), that.getServiceNames());
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.getServiceNames());
    }

    private class AddressRefreshRetryTask
    implements Runnable {
        private final RetryServiceInstancesChangedEvent retryEvent = new RetryServiceInstancesChangedEvent();
        private final Semaphore retryPermission;

        public AddressRefreshRetryTask(Semaphore semaphore) {
            this.retryPermission = semaphore;
        }

        @Override
        public void run() {
            this.retryPermission.release();
            ServiceInstancesChangedListener.this.onEvent(this.retryEvent);
        }
    }
}

