/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigItem;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.registry.client.RegistryClusterIdentifier;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetadataServiceNameMapping
implements ServiceNameMapping {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final List<String> IGNORED_SERVICE_INTERFACES = Collections.singletonList(MetadataService.class.getName());
    private static final int CAS_RETRY_TIMES = 6;

    @Override
    public void map(URL url) {
        this.execute(() -> {
            ConfigItem configItem;
            boolean success;
            String serviceInterface = url.getServiceInterface();
            if (IGNORED_SERVICE_INTERFACES.contains(serviceInterface)) {
                return;
            }
            String registryCluster = this.getRegistryCluster(url);
            MetadataReport metadataReport = MetadataReportInstance.getMetadataReport(registryCluster);
            int currentRetryTimes = 1;
            String newConfigContent = ApplicationModel.getName();
            do {
                String oldConfigContent;
                if (!StringUtils.isNotEmpty(oldConfigContent = (configItem = metadataReport.getConfigItem(serviceInterface, "mapping")).getContent())) continue;
                boolean contains = StringUtils.isContains(oldConfigContent, ApplicationModel.getName());
                if (contains) break;
                newConfigContent = oldConfigContent + "," + ApplicationModel.getName();
            } while (!(success = metadataReport.registerServiceAppMapping(serviceInterface, "mapping", newConfigContent, configItem.getStat())) && currentRetryTimes++ <= 6);
        });
    }

    @Override
    public Set<String> getAndListen(URL url, MappingListener mappingListener) {
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        this.execute(() -> {
            String serviceInterface = url.getServiceInterface();
            String registryCluster = this.getRegistryCluster(url);
            MetadataReport metadataReport = MetadataReportInstance.getMetadataReport(registryCluster);
            Set<String> apps = metadataReport.getServiceAppMapping(serviceInterface, mappingListener, url);
            serviceNames.addAll(apps);
        });
        return serviceNames;
    }

    protected String getRegistryCluster(URL url) {
        int i;
        String registryCluster = RegistryClusterIdentifier.getExtension(url).providerKey(url);
        if (registryCluster == null) {
            registryCluster = "default";
        }
        if ((i = registryCluster.indexOf(",")) > 0) {
            registryCluster = registryCluster.substring(0, i);
        }
        return registryCluster;
    }

    private void execute(Runnable runnable) {
        block2: {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn(e.getMessage(), e);
            }
        }
    }
}

