/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.status.reporter.FrameworkStatusReporter;
import org.apache.dubbo.registry.client.migration.MigrationClusterInvoker;
import org.apache.dubbo.registry.client.migration.ServiceDiscoveryMigrationInvoker;
import org.apache.dubbo.registry.client.migration.model.MigrationRule;
import org.apache.dubbo.registry.client.migration.model.MigrationStep;

public class MigrationRuleHandler<T> {
    public static final String DUBBO_SERVICEDISCOVERY_MIGRATION = "dubbo.application.service-discovery.migration";
    public static final String MIGRATION_KEY = "migration";
    private static final Logger logger = LoggerFactory.getLogger(MigrationRuleHandler.class);
    private MigrationClusterInvoker<T> migrationInvoker;
    private MigrationStep currentStep;
    private Float currentThreshold = Float.valueOf(0.0f);
    private URL consumerURL;

    public MigrationRuleHandler(MigrationClusterInvoker<T> invoker, URL url) {
        this.migrationInvoker = invoker;
        this.consumerURL = url;
    }

    public synchronized void doMigrate(MigrationRule rule) {
        if (this.migrationInvoker instanceof ServiceDiscoveryMigrationInvoker) {
            this.refreshInvoker(MigrationStep.FORCE_APPLICATION, Float.valueOf(1.0f), rule);
            return;
        }
        MigrationStep step = MigrationStep.APPLICATION_FIRST;
        Float threshold = Float.valueOf(-1.0f);
        if (rule == MigrationRule.INIT) {
            step = Enum.valueOf(MigrationStep.class, this.consumerURL.getParameter(MIGRATION_KEY, ConfigurationUtils.getCachedDynamicProperty(DUBBO_SERVICEDISCOVERY_MIGRATION, step.name())));
        } else {
            try {
                String serviceKey = this.consumerURL.getDisplayServiceKey();
                step = this.getMigrationStep(rule, step, serviceKey);
                threshold = this.getMigrationThreshold(rule, threshold, serviceKey);
            }
            catch (Exception e) {
                logger.error("Failed to get step and threshold info from rule: " + rule, e);
            }
        }
        if (this.refreshInvoker(step, threshold, rule)) {
            this.setMigrationRule(rule);
        }
    }

    private boolean refreshInvoker(MigrationStep step, Float threshold, MigrationRule newRule) {
        if (step == null || threshold == null) {
            throw new IllegalStateException("Step or threshold of migration rule cannot be null");
        }
        MigrationStep originStep = this.currentStep;
        if (this.currentStep == null || this.currentStep != step || !this.currentThreshold.equals(threshold)) {
            boolean success = true;
            switch (step) {
                case APPLICATION_FIRST: {
                    this.migrationInvoker.migrateToApplicationFirstInvoker(newRule);
                    break;
                }
                case FORCE_APPLICATION: {
                    success = this.migrationInvoker.migrateToForceApplicationInvoker(newRule);
                    break;
                }
                default: {
                    success = this.migrationInvoker.migrateToForceInterfaceInvoker(newRule);
                }
            }
            if (success) {
                this.setCurrentStepAndThreshold(step, threshold);
                logger.info("Succeed Migrated to " + (Object)((Object)step) + " mode. Service Name: " + this.consumerURL.getDisplayServiceKey());
                this.report(step, originStep, "true");
            } else {
                logger.warn("Migrate to " + (Object)((Object)step) + " mode failed. Probably not satisfy the threshold you set " + threshold + ". Please try re-publish configuration if you still after check.");
                this.report(step, originStep, "false");
            }
            return success;
        }
        return true;
    }

    private void report(MigrationStep step, MigrationStep originStep, String success) {
        if (FrameworkStatusReporter.hasReporter()) {
            FrameworkStatusReporter.reportMigrationStepStatus(FrameworkStatusReporter.createMigrationStepReport(this.consumerURL.getServiceInterface(), this.consumerURL.getVersion(), this.consumerURL.getGroup(), String.valueOf((Object)originStep), String.valueOf((Object)step), success));
        }
    }

    private void setMigrationRule(MigrationRule rule) {
        this.migrationInvoker.setMigrationRule(rule);
    }

    private MigrationStep getMigrationStep(MigrationRule rule, MigrationStep step, String serviceKey) {
        MigrationStep configuredStep = rule.getStep(serviceKey);
        step = configuredStep == null ? step : configuredStep;
        return step;
    }

    private Float getMigrationThreshold(MigrationRule rule, Float threshold, String serviceKey) {
        Float configuredThreshold = rule.getThreshold(serviceKey);
        threshold = configuredThreshold == null ? threshold : configuredThreshold;
        return threshold;
    }

    private void setCurrentStepAndThreshold(MigrationStep currentStep, Float currentThreshold) {
        if (currentThreshold != null) {
            this.currentThreshold = currentThreshold;
        }
        if (currentStep != null) {
            this.currentStep = currentStep;
            this.migrationInvoker.setMigrationStep(currentStep);
        }
    }
}

