/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.migration.MigrationInvoker;
import org.apache.dubbo.registry.client.migration.MigrationRuleHandler;
import org.apache.dubbo.registry.client.migration.model.MigrationRule;
import org.apache.dubbo.registry.integration.RegistryProtocol;
import org.apache.dubbo.registry.integration.RegistryProtocolListener;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate
public class MigrationRuleListener
implements RegistryProtocolListener,
ConfigurationListener {
    private static final Logger logger = LoggerFactory.getLogger(MigrationRuleListener.class);
    private static final String DUBBO_SERVICEDISCOVERY_MIGRATION = "DUBBO_SERVICEDISCOVERY_MIGRATION";
    private static final String MIGRATION_DELAY_KEY = "dubbo.application.migration.delay";
    private final String RULE_KEY = ApplicationModel.getName() + ".migration";
    private final Map<MigrationInvoker, MigrationRuleHandler> handlers = new ConcurrentHashMap<MigrationInvoker, MigrationRuleHandler>();
    private DynamicConfiguration configuration = ApplicationModel.getEnvironment().getDynamicConfiguration().orElse(null);
    private volatile String rawRule;
    private volatile MigrationRule rule;

    public MigrationRuleListener() {
        if (this.configuration != null) {
            logger.info("Listening for migration rules on dataId " + this.RULE_KEY + ", group " + DUBBO_SERVICEDISCOVERY_MIGRATION);
            this.configuration.addListener(this.RULE_KEY, DUBBO_SERVICEDISCOVERY_MIGRATION, this);
            String rawRule = this.configuration.getConfig(this.RULE_KEY, DUBBO_SERVICEDISCOVERY_MIGRATION);
            if (StringUtils.isEmpty(rawRule)) {
                rawRule = "INIT";
            }
            this.rawRule = rawRule;
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn("Using default configuration rule because config center is not configured!");
            }
            this.rawRule = "INIT";
        }
        String localRawRule = ApplicationModel.getEnvironment().getLocalMigrationRule();
        if (!StringUtils.isEmpty(localRawRule)) {
            Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("DubboMigrationRuleDelayWorker", true)).schedule(() -> {
                if (this.rawRule.equals("INIT")) {
                    this.process(new ConfigChangedEvent(null, null, localRawRule));
                }
            }, (long)this.getDelay(), TimeUnit.MILLISECONDS);
        }
    }

    private int getDelay() {
        int delay = 60000;
        String delayStr = ConfigurationUtils.getProperty(MIGRATION_DELAY_KEY);
        if (StringUtils.isEmpty(delayStr)) {
            return delay;
        }
        try {
            delay = Integer.parseInt(delayStr);
        }
        catch (Exception e) {
            logger.warn("Invalid migration delay param " + delayStr);
        }
        return delay;
    }

    @Override
    public synchronized void process(ConfigChangedEvent event) {
        this.rawRule = event.getContent();
        if (StringUtils.isEmpty(this.rawRule)) {
            logger.warn("Received empty migration rule, will ignore.");
            return;
        }
        logger.info("Using the following migration rule to migrate:");
        logger.info(this.rawRule);
        this.rule = this.parseRule(this.rawRule);
        if (CollectionUtils.isNotEmptyMap(this.handlers)) {
            this.handlers.forEach((_key, handler) -> handler.doMigrate(this.rule));
        }
    }

    private MigrationRule parseRule(String rawRule) {
        MigrationRule tmpRule = this.rule;
        if ("INIT".equals(rawRule)) {
            tmpRule = MigrationRule.INIT;
        } else {
            try {
                tmpRule = MigrationRule.parse(rawRule);
            }
            catch (Exception e) {
                logger.error("Failed to parse migration rule...", e);
            }
        }
        return tmpRule;
    }

    @Override
    public synchronized void onExport(RegistryProtocol registryProtocol, Exporter<?> exporter) {
    }

    @Override
    public synchronized void onRefer(RegistryProtocol registryProtocol, ClusterInvoker<?> invoker, URL consumerUrl, URL registryURL) {
        MigrationRuleHandler migrationRuleHandler = this.handlers.computeIfAbsent((MigrationInvoker)invoker, _key -> {
            ((MigrationInvoker)invoker).setMigrationRuleListener(this);
            return new MigrationRuleHandler((MigrationInvoker)invoker, consumerUrl);
        });
        this.rule = this.parseRule(this.rawRule);
        migrationRuleHandler.doMigrate(this.rule);
    }

    @Override
    public void onDestroy() {
        if (this.configuration != null) {
            this.configuration.removeListener(this.RULE_KEY, this);
        }
    }

    public Map<MigrationInvoker, MigrationRuleHandler> getHandlers() {
        return this.handlers;
    }

    protected void removeMigrationInvoker(MigrationInvoker<?> migrationInvoker) {
        this.handlers.remove(migrationInvoker);
    }
}

