/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.registry.client.migration.model.InterfaceMigrationRule;
import org.apache.dubbo.registry.client.migration.model.MigrationStep;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class MigrationRule {
    public static final MigrationRule INIT = new MigrationRule();
    private String key;
    private MigrationStep step;
    private Float threshold;
    private Integer proportion;
    private Integer delay;
    private Boolean force;
    private List<InterfaceMigrationRule> interfaces;
    private transient Map<String, InterfaceMigrationRule> interfaceRules;

    private static MigrationRule parseFromMap(Map<String, Object> map) {
        Object interfaces;
        Object force;
        Object delay;
        Object proportion;
        Object threshold;
        MigrationRule migrationRule = new MigrationRule();
        migrationRule.setKey((String)map.get("key"));
        Object step = map.get("step");
        if (step != null) {
            migrationRule.setStep(MigrationStep.valueOf(step.toString()));
        }
        if ((threshold = map.get("threshold")) != null) {
            migrationRule.setThreshold(Float.valueOf(threshold.toString()));
        }
        if ((proportion = map.get("proportion")) != null) {
            migrationRule.setProportion(Integer.valueOf(proportion.toString()));
        }
        if ((delay = map.get("delay")) != null) {
            migrationRule.setDelay(Integer.valueOf(delay.toString()));
        }
        if ((force = map.get("force")) != null) {
            migrationRule.setForce(Boolean.valueOf(force.toString()));
        }
        if ((interfaces = map.get("interfaces")) != null && List.class.isAssignableFrom(interfaces.getClass())) {
            migrationRule.setInterfaces(((List)interfaces).stream().map(InterfaceMigrationRule::parseFromMap).collect(Collectors.toList()));
        }
        return migrationRule;
    }

    public MigrationRule() {
    }

    public MigrationRule(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public MigrationStep getStep(String serviceKey) {
        InterfaceMigrationRule rule;
        if (this.interfaceRules != null && (rule = this.interfaceRules.get(serviceKey)) != null) {
            return rule.getStep() == null ? this.step : rule.getStep();
        }
        return this.step;
    }

    public InterfaceMigrationRule getInterfaceRule(String serviceKey) {
        if (this.interfaceRules == null) {
            return null;
        }
        return this.interfaceRules.get(serviceKey);
    }

    public MigrationStep getStep() {
        return this.step;
    }

    public Float getThreshold(String serviceKey) {
        InterfaceMigrationRule rule;
        if (this.interfaceRules != null && (rule = this.interfaceRules.get(serviceKey)) != null) {
            return rule.getThreshold() == null ? this.threshold : rule.getThreshold();
        }
        return this.threshold;
    }

    public Float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Float threshold) {
        this.threshold = threshold;
    }

    public Integer getProportion() {
        return this.proportion;
    }

    public Integer getProportion(String serviceKey) {
        InterfaceMigrationRule rule;
        if (this.interfaceRules != null && (rule = this.interfaceRules.get(serviceKey)) != null) {
            return rule.getProportion() == null ? this.proportion : rule.getProportion();
        }
        return this.proportion;
    }

    public void setProportion(Integer proportion) {
        this.proportion = proportion;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public Integer getDelay(String serviceKey) {
        InterfaceMigrationRule rule;
        if (this.interfaceRules != null && (rule = this.interfaceRules.get(serviceKey)) != null) {
            return rule.getDelay() == null ? this.delay : rule.getDelay();
        }
        return this.delay;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public void setStep(MigrationStep step) {
        this.step = step;
    }

    public Boolean getForce() {
        return this.force;
    }

    public Boolean getForce(String serviceKey) {
        InterfaceMigrationRule rule;
        if (this.interfaceRules != null && (rule = this.interfaceRules.get(serviceKey)) != null) {
            return rule.getForce() == null ? this.force : rule.getForce();
        }
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public List<InterfaceMigrationRule> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(List<InterfaceMigrationRule> interfaces) {
        this.interfaces = interfaces;
        if (interfaces != null) {
            this.interfaceRules = new HashMap<String, InterfaceMigrationRule>();
            interfaces.forEach(rule -> this.interfaceRules.put(rule.getServiceKey(), (InterfaceMigrationRule)rule));
        }
    }

    public boolean removeInterfaceRule(String serviceKey) {
        if (CollectionUtils.isNotEmpty(this.interfaces)) {
            boolean removed = this.interfaces.removeIf(interfaceMigrationRule -> interfaceMigrationRule.getServiceKey().equals(serviceKey));
            this.interfaceRules.remove(serviceKey);
            return removed;
        }
        return false;
    }

    public boolean addInterfaceRule(String serviceKey, MigrationStep step, Float threshold, Integer proportion) {
        if (this.getInterfaceRule(serviceKey) != null) {
            return false;
        }
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<InterfaceMigrationRule>();
        }
        InterfaceMigrationRule interfaceMigrationRule = new InterfaceMigrationRule(serviceKey, step, threshold, proportion);
        this.interfaces.add(interfaceMigrationRule);
        if (this.interfaceRules == null) {
            this.interfaceRules = new HashMap<String, InterfaceMigrationRule>();
        }
        this.interfaceRules.put(serviceKey, interfaceMigrationRule);
        return true;
    }

    public static MigrationRule parse(String rawRule) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        Map map = (Map)yaml.load(rawRule);
        return MigrationRule.parseFromMap(map);
    }

    public static String toYaml(MigrationRule rule) {
        Constructor constructor = new Constructor(MigrationRule.class);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        return yaml.dump((Object)rule);
    }
}

