/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.dubbo.common.Node;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.url.component.DubboServiceAddressURL;
import org.apache.dubbo.common.url.component.ServiceAddressURL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.AddressListener;
import org.apache.dubbo.registry.integration.AbstractConfiguratorListener;
import org.apache.dubbo.registry.integration.DynamicDirectory;
import org.apache.dubbo.registry.integration.InterfaceCompatibleRegistryProtocol;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.directory.StaticDirectory;
import org.apache.dubbo.rpc.cluster.support.ClusterUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class RegistryDirectory<T>
extends DynamicDirectory<T> {
    private static final Logger logger = LoggerFactory.getLogger(RegistryDirectory.class);
    private static final ConsumerConfigurationListener CONSUMER_CONFIGURATION_LISTENER = new ConsumerConfigurationListener();
    private ReferenceConfigurationListener referenceConfigurationListener;
    protected volatile Map<URL, Invoker<T>> urlInvokerMap;
    protected volatile Set<URL> cachedInvokerUrls;

    public RegistryDirectory(Class<T> serviceType, URL url) {
        super(serviceType, url);
    }

    @Override
    public void subscribe(URL url) {
        this.setSubscribeUrl(url);
        CONSUMER_CONFIGURATION_LISTENER.addNotifyListener(this);
        this.referenceConfigurationListener = new ReferenceConfigurationListener(this, url);
        this.registry.subscribe(url, this);
    }

    @Override
    public void unSubscribe(URL url) {
        this.setSubscribeUrl(null);
        CONSUMER_CONFIGURATION_LISTENER.removeNotifyListener(this);
        this.referenceConfigurationListener.stop();
        this.registry.unsubscribe(url, this);
    }

    @Override
    public synchronized void notify(List<URL> urls) {
        if (this.isDestroyed()) {
            return;
        }
        Map<String, List<URL>> categoryUrls = urls.stream().filter(Objects::nonNull).filter(this::isValidCategory).filter(this::isNotCompatibleFor26x).collect(Collectors.groupingBy(this::judgeCategory));
        List<URL> configuratorURLs = categoryUrls.getOrDefault("configurators", Collections.emptyList());
        this.configurators = Configurator.toConfigurators(configuratorURLs).orElse(this.configurators);
        List<URL> routerURLs = categoryUrls.getOrDefault("routers", Collections.emptyList());
        this.toRouters(routerURLs).ifPresent(this::addRouters);
        List<URL> providerURLs = categoryUrls.getOrDefault("providers", Collections.emptyList());
        ExtensionLoader<AddressListener> addressListenerExtensionLoader = ExtensionLoader.getExtensionLoader(AddressListener.class);
        List<AddressListener> supportedListeners = addressListenerExtensionLoader.getActivateExtension(this.getUrl(), (String[])null);
        if (supportedListeners != null && !supportedListeners.isEmpty()) {
            for (AddressListener addressListener : supportedListeners) {
                providerURLs = addressListener.notify(providerURLs, this.getConsumerUrl(), this);
            }
        }
        this.refreshOverrideAndInvoker(providerURLs);
    }

    @Override
    public boolean isServiceDiscovery() {
        return false;
    }

    private String judgeCategory(URL url) {
        if (UrlUtils.isConfigurator(url)) {
            return "configurators";
        }
        if (UrlUtils.isRoute(url)) {
            return "routers";
        }
        if (UrlUtils.isProvider(url)) {
            return "providers";
        }
        return "";
    }

    private synchronized void refreshOverrideAndInvoker(List<URL> urls) {
        this.overrideDirectoryUrl();
        this.refreshInvoker(urls);
    }

    private void refreshInvoker(List<URL> invokerUrls) {
        Assert.notNull(invokerUrls, "invokerUrls should not be null");
        if (invokerUrls.size() == 1 && invokerUrls.get(0) != null && "empty".equals(invokerUrls.get(0).getProtocol())) {
            this.forbidden = true;
            this.invokers = Collections.emptyList();
            this.routerChain.setInvokers(this.invokers);
            this.destroyAllInvokers();
        } else {
            this.forbidden = false;
            Map<URL, Invoker<T>> oldUrlInvokerMap = this.urlInvokerMap;
            if (invokerUrls == Collections.emptyList()) {
                invokerUrls = new ArrayList<URL>();
            }
            if (invokerUrls.isEmpty() && this.cachedInvokerUrls != null) {
                invokerUrls.addAll(this.cachedInvokerUrls);
            } else {
                this.cachedInvokerUrls = new HashSet<URL>();
                this.cachedInvokerUrls.addAll(invokerUrls);
            }
            if (invokerUrls.isEmpty()) {
                return;
            }
            Map<URL, Invoker<T>> newUrlInvokerMap = this.toInvokers(invokerUrls);
            if (CollectionUtils.isEmptyMap(newUrlInvokerMap)) {
                logger.error(new IllegalStateException("urls to invokers error .invokerUrls.size :" + invokerUrls.size() + ", invoker.size :0. urls :" + invokerUrls.toString()));
                return;
            }
            List<Invoker<T>> newInvokers = Collections.unmodifiableList(new ArrayList<Invoker<T>>(newUrlInvokerMap.values()));
            this.routerChain.setInvokers(newInvokers);
            this.invokers = this.multiGroup ? this.toMergeInvokerList(newInvokers) : newInvokers;
            this.urlInvokerMap = newUrlInvokerMap;
            try {
                this.destroyUnusedInvokers(oldUrlInvokerMap, newUrlInvokerMap);
            }
            catch (Exception e) {
                logger.warn("destroyUnusedInvokers error. ", e);
            }
            this.invokersChanged();
        }
    }

    private List<Invoker<T>> toMergeInvokerList(List<Invoker<T>> invokers) {
        ArrayList<Invoker<T>> mergedInvokers = new ArrayList();
        HashMap<String, List> groupMap = new HashMap<String, List>();
        for (Invoker<T> invoker : invokers) {
            String group = invoker.getUrl().getGroup("");
            groupMap.computeIfAbsent(group, k -> new ArrayList());
            ((List)groupMap.get(group)).add(invoker);
        }
        if (groupMap.size() == 1) {
            mergedInvokers.addAll((Collection)groupMap.values().iterator().next());
        } else if (groupMap.size() > 1) {
            for (List groupList : groupMap.values()) {
                StaticDirectory staticDirectory = new StaticDirectory(groupList);
                staticDirectory.buildRouterChain();
                mergedInvokers.add(CLUSTER.join(staticDirectory));
            }
        } else {
            mergedInvokers = invokers;
        }
        return mergedInvokers;
    }

    private Optional<List<Router>> toRouters(List<URL> urls) {
        if (urls == null || urls.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<Router> routers = new ArrayList<Router>();
        for (URL url : urls) {
            if ("empty".equals(url.getProtocol())) continue;
            String routerType = url.getParameter("router");
            if (routerType != null && routerType.length() > 0) {
                url = url.setProtocol(routerType);
            }
            try {
                Router router = ROUTER_FACTORY.getRouter(url);
                if (routers.contains(router)) continue;
                routers.add(router);
            }
            catch (Throwable t) {
                logger.error("convert router url to router error, url: " + url, t);
            }
        }
        return Optional.of(routers);
    }

    private Map<URL, Invoker<T>> toInvokers(List<URL> urls) {
        ConcurrentHashMap<URL, Invoker<T>> newUrlInvokerMap = new ConcurrentHashMap<URL, Invoker<T>>();
        if (urls == null || urls.isEmpty()) {
            return newUrlInvokerMap;
        }
        String queryProtocols = (String)this.queryMap.get("protocol");
        for (URL providerUrl : urls) {
            Invoker<T> invoker;
            if (queryProtocols != null && queryProtocols.length() > 0) {
                String[] acceptProtocols;
                boolean accept = false;
                for (String acceptProtocol : acceptProtocols = queryProtocols.split(",")) {
                    if (!providerUrl.getProtocol().equals(acceptProtocol)) continue;
                    accept = true;
                    break;
                }
                if (!accept) continue;
            }
            if ("empty".equals(providerUrl.getProtocol())) continue;
            if (!ExtensionLoader.getExtensionLoader(Protocol.class).hasExtension(providerUrl.getProtocol())) {
                logger.error(new IllegalStateException("Unsupported protocol " + providerUrl.getProtocol() + " in notified url: " + providerUrl + " from registry " + this.getUrl().getAddress() + " to consumer " + NetUtils.getLocalHost() + ", supported protocol: " + ExtensionLoader.getExtensionLoader(Protocol.class).getSupportedExtensions()));
                continue;
            }
            URL url = this.mergeUrl(providerUrl);
            Map<URL, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
            Invoker<T> invoker2 = invoker = localUrlInvokerMap == null ? null : localUrlInvokerMap.remove(url);
            if (invoker == null) {
                try {
                    boolean enabled = true;
                    enabled = url.hasParameter("disabled") ? !url.getParameter("disabled", false) : url.getParameter("enabled", true);
                    if (enabled) {
                        invoker = this.protocol.refer(this.serviceType, url);
                    }
                }
                catch (Throwable t) {
                    logger.error("Failed to refer invoker for interface:" + this.serviceType + ",url:(" + url + ")" + t.getMessage(), t);
                }
                if (invoker == null) continue;
                newUrlInvokerMap.put(url, invoker);
                continue;
            }
            newUrlInvokerMap.put(url, invoker);
        }
        return newUrlInvokerMap;
    }

    private URL mergeUrl(URL providerUrl) {
        String path;
        if (providerUrl instanceof ServiceAddressURL) {
            providerUrl = this.overrideWithConfigurator(providerUrl);
        } else {
            providerUrl = ClusterUtils.mergeUrl(providerUrl, this.queryMap);
            providerUrl = this.overrideWithConfigurator(providerUrl);
            providerUrl = providerUrl.addParameter("check", String.valueOf(false));
        }
        if (providerUrl.hasParameter("mock") || providerUrl.getAnyMethodParameter("mock") != null) {
            providerUrl = providerUrl.removeParameter("dubbo.tag");
            this.overrideDirectoryUrl = this.overrideDirectoryUrl.addParametersIfAbsent(providerUrl.getParameters());
        }
        if ((providerUrl.getPath() == null || providerUrl.getPath().length() == 0) && "dubbo".equals(providerUrl.getProtocol()) && (path = this.directoryUrl.getServiceInterface()) != null) {
            int i = path.indexOf(47);
            if (i >= 0) {
                path = path.substring(i + 1);
            }
            if ((i = path.lastIndexOf(58)) >= 0) {
                path = path.substring(0, i);
            }
            providerUrl = providerUrl.setPath(path);
        }
        return providerUrl;
    }

    private URL overrideWithConfigurator(URL providerUrl) {
        providerUrl = this.overrideWithConfigurators(this.configurators, providerUrl);
        providerUrl = this.overrideWithConfigurators(CONSUMER_CONFIGURATION_LISTENER.getConfigurators(), providerUrl);
        if (this.referenceConfigurationListener != null) {
            providerUrl = this.overrideWithConfigurators(this.referenceConfigurationListener.getConfigurators(), providerUrl);
        }
        return providerUrl;
    }

    private URL overrideWithConfigurators(List<Configurator> configurators, URL url) {
        if (CollectionUtils.isNotEmpty(configurators)) {
            if (url instanceof DubboServiceAddressURL) {
                DubboServiceAddressURL interfaceAddressURL = (DubboServiceAddressURL)url;
                URL overriddenURL = interfaceAddressURL.getOverrideURL();
                if (overriddenURL == null) {
                    String appName = interfaceAddressURL.getApplication();
                    String side = interfaceAddressURL.getSide();
                    overriddenURL = URLBuilder.from(interfaceAddressURL).clearParameters().addParameter("application", appName).addParameter("side", side).build();
                }
                for (Configurator configurator : configurators) {
                    overriddenURL = configurator.configure(overriddenURL);
                }
                url = new DubboServiceAddressURL(interfaceAddressURL.getUrlAddress(), interfaceAddressURL.getUrlParam(), interfaceAddressURL.getConsumerURL(), (ServiceConfigURL)overriddenURL);
            } else {
                for (Configurator configurator : configurators) {
                    url = configurator.configure(url);
                }
            }
        }
        return url;
    }

    @Override
    protected void destroyAllInvokers() {
        Map<URL, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
        if (localUrlInvokerMap != null) {
            for (Invoker<T> invoker : new ArrayList<Invoker<T>>(localUrlInvokerMap.values())) {
                try {
                    invoker.destroy();
                }
                catch (Throwable t) {
                    logger.warn("Failed to destroy service " + this.serviceKey + " to provider " + invoker.getUrl(), t);
                }
            }
            localUrlInvokerMap.clear();
        }
        this.invokers = null;
        this.cachedInvokerUrls = null;
    }

    private void destroyUnusedInvokers(Map<URL, Invoker<T>> oldUrlInvokerMap, Map<URL, Invoker<T>> newUrlInvokerMap) {
        if (newUrlInvokerMap == null || newUrlInvokerMap.size() == 0) {
            this.destroyAllInvokers();
            return;
        }
        if (oldUrlInvokerMap == null || oldUrlInvokerMap.size() == 0) {
            return;
        }
        for (Map.Entry<URL, Invoker<T>> entry : oldUrlInvokerMap.entrySet()) {
            Invoker<T> invoker = entry.getValue();
            if (invoker == null) continue;
            try {
                invoker.destroy();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("destroy invoker[" + invoker.getUrl() + "] success. ");
            }
            catch (Exception e) {
                logger.warn("destroy invoker[" + invoker.getUrl() + "] failed. " + e.getMessage(), e);
            }
        }
        logger.info("New url total size, " + newUrlInvokerMap.size() + ", destroyed total size " + oldUrlInvokerMap.size());
    }

    @Override
    public List<Invoker<T>> doList(Invocation invocation) {
        if (this.forbidden) {
            throw new RpcException(4, "No provider available from registry " + this.getUrl().getAddress() + " for service " + this.getConsumerUrl().getServiceKey() + " on consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", please check status of providers(disabled, not registered or in blacklist).");
        }
        if (this.multiGroup) {
            return this.invokers == null ? Collections.emptyList() : this.invokers;
        }
        List invokers = null;
        try {
            invokers = this.routerChain.route(this.getConsumerUrl(), invocation);
        }
        catch (Throwable t) {
            logger.error("Failed to execute router: " + this.getUrl() + ", cause: " + t.getMessage(), t);
        }
        return invokers == null ? Collections.emptyList() : invokers;
    }

    @Override
    public Class<T> getInterface() {
        return this.serviceType;
    }

    @Override
    public List<Invoker<T>> getAllInvokers() {
        return this.invokers;
    }

    @Override
    public URL getConsumerUrl() {
        return this.overrideDirectoryUrl;
    }

    @Override
    public URL getRegisteredConsumerUrl() {
        return this.registeredConsumerUrl;
    }

    @Override
    public void setRegisteredConsumerUrl(URL url) {
        this.registeredConsumerUrl = !this.shouldSimplified ? url.addParameters("category", "consumers", "check", String.valueOf(false)) : URL.valueOf(url, InterfaceCompatibleRegistryProtocol.DEFAULT_REGISTER_CONSUMER_KEYS, null).addParameters("category", "consumers", "check", String.valueOf(false));
    }

    @Override
    public boolean isAvailable() {
        if (this.isDestroyed()) {
            return false;
        }
        Map<URL, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
        return CollectionUtils.isNotEmptyMap(localUrlInvokerMap) && localUrlInvokerMap.values().stream().anyMatch(Node::isAvailable);
    }

    public Map<URL, Invoker<T>> getUrlInvokerMap() {
        return this.urlInvokerMap;
    }

    @Override
    public List<Invoker<T>> getInvokers() {
        return this.invokers;
    }

    private boolean isValidCategory(URL url) {
        String category = url.getCategory("providers");
        if ("routers".equals(category) || "route".equals(url.getProtocol()) || "providers".equals(category) || "configurators".equals(category) || "dynamicconfigurators".equals(category) || "appdynamicconfigurators".equals(category)) {
            return true;
        }
        logger.warn("Unsupported category " + category + " in notified url: " + url + " from registry " + this.getUrl().getAddress() + " to consumer " + NetUtils.getLocalHost());
        return false;
    }

    private boolean isNotCompatibleFor26x(URL url) {
        return StringUtils.isEmpty(url.getParameter("compatible_config"));
    }

    private void overrideDirectoryUrl() {
        this.overrideDirectoryUrl = this.directoryUrl;
        List localConfigurators = this.configurators;
        this.doOverrideUrl(localConfigurators);
        List<Configurator> localAppDynamicConfigurators = CONSUMER_CONFIGURATION_LISTENER.getConfigurators();
        this.doOverrideUrl(localAppDynamicConfigurators);
        if (this.referenceConfigurationListener != null) {
            List<Configurator> localDynamicConfigurators = this.referenceConfigurationListener.getConfigurators();
            this.doOverrideUrl(localDynamicConfigurators);
        }
    }

    private void doOverrideUrl(List<Configurator> configurators) {
        if (CollectionUtils.isNotEmpty(configurators)) {
            for (Configurator configurator : configurators) {
                this.overrideDirectoryUrl = configurator.configure(this.overrideDirectoryUrl);
            }
        }
    }

    private static class ConsumerConfigurationListener
    extends AbstractConfiguratorListener {
        List<RegistryDirectory> listeners = new ArrayList<RegistryDirectory>();

        ConsumerConfigurationListener() {
            this.initWith(ApplicationModel.getApplication() + ".configurators");
        }

        void addNotifyListener(RegistryDirectory listener) {
            this.listeners.add(listener);
        }

        void removeNotifyListener(RegistryDirectory listener) {
            this.listeners.remove(listener);
        }

        @Override
        protected void notifyOverrides() {
            this.listeners.forEach(listener -> ((RegistryDirectory)listener).refreshOverrideAndInvoker(Collections.emptyList()));
        }
    }

    private static class ReferenceConfigurationListener
    extends AbstractConfiguratorListener {
        private RegistryDirectory directory;
        private URL url;

        ReferenceConfigurationListener(RegistryDirectory directory, URL url) {
            this.directory = directory;
            this.url = url;
            this.initWith(DynamicConfiguration.getRuleKey(url) + ".configurators");
        }

        void stop() {
            this.stopListen(DynamicConfiguration.getRuleKey(this.url) + ".configurators");
        }

        @Override
        protected void notifyOverrides() {
            this.directory.refreshOverrideAndInvoker(Collections.emptyList());
        }
    }
}

