/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.remoting.api.NettyEventLoopFactory;
import org.apache.dubbo.remoting.api.PortUnificationServerHandler;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.utils.UrlUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class PortUnificationServer {
    private static final Logger logger = LoggerFactory.getLogger(PortUnificationServer.class);
    private final List<WireProtocol> protocols;
    private final URL url;
    private ServerBootstrap bootstrap;
    private Channel channel;
    private DefaultChannelGroup channelGroup;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public PortUnificationServer(URL url) {
        this.url = ExecutorUtil.setThreadName(url, "DubboPUServerHandler");
        this.protocols = ExtensionLoader.getExtensionLoader(WireProtocol.class).getActivateExtension(url, new String[0]);
    }

    private static boolean checkJdkProvider() {
        Provider[] jdkProviders = Security.getProviders("SSLContext.TLS");
        return jdkProviders != null && jdkProviders.length > 0;
    }

    private static SslProvider findSslProvider() {
        if (OpenSsl.isAvailable()) {
            logger.info("Using OPENSSL provider.");
            return SslProvider.OPENSSL;
        }
        if (PortUnificationServer.checkJdkProvider()) {
            logger.info("Using JDK provider.");
            return SslProvider.JDK;
        }
        throw new IllegalStateException("Could not find any valid TLS provider, please check your dependency or deployment environment, usually netty-tcnative, Conscrypt, or Jetty NPN/ALPN is needed.");
    }

    public static SslContext buildServerSslContext(URL url) {
        ConfigManager globalConfigManager = ApplicationModel.getConfigManager();
        SslConfig sslConfig = globalConfigManager.getSsl().orElseThrow(() -> new IllegalStateException("Ssl enabled, but no ssl cert information provided!"));
        SslContextBuilder sslClientContextBuilder = null;
        try {
            String password = sslConfig.getServerKeyPassword();
            sslClientContextBuilder = password != null ? SslContextBuilder.forServer((InputStream)sslConfig.getServerKeyCertChainPathStream(), (InputStream)sslConfig.getServerPrivateKeyPathStream(), (String)password) : SslContextBuilder.forServer((InputStream)sslConfig.getServerKeyCertChainPathStream(), (InputStream)sslConfig.getServerPrivateKeyPathStream());
            if (sslConfig.getServerTrustCertCollectionPathStream() != null) {
                sslClientContextBuilder.trustManager(sslConfig.getServerTrustCertCollectionPathStream());
                sslClientContextBuilder.clientAuth(ClientAuth.REQUIRE);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find certificate file or the certificate is invalid.", e);
        }
        try {
            return sslClientContextBuilder.sslProvider(PortUnificationServer.findSslProvider()).build();
        }
        catch (SSLException e) {
            throw new IllegalStateException("Build SslSession failed.", e);
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public void bind() {
        if (this.channel == null) {
            this.doOpen();
        }
    }

    public void close() throws Throwable {
        if (this.channel != null) {
            this.doClose();
        }
    }

    protected void doOpen() {
        this.bootstrap = new ServerBootstrap();
        this.bossGroup = NettyEventLoopFactory.eventLoopGroup(1, "NettyServerBoss");
        this.workerGroup = NettyEventLoopFactory.eventLoopGroup(this.getUrl().getPositiveParameter("iothreads", Constants.DEFAULT_IO_THREADS), "NettyServerWorker");
        ((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NettyEventLoopFactory.serverSocketChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE)).childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                PortUnificationServerHandler puHandler;
                int idleTimeout = UrlUtils.getIdleTimeout(PortUnificationServer.this.getUrl());
                ChannelPipeline p = ch.pipeline();
                boolean enableSSL = PortUnificationServer.this.getUrl().getParameter("ssl-enabled", false);
                if (enableSSL) {
                    SslContext sslContext = PortUnificationServer.buildServerSslContext(PortUnificationServer.this.getUrl());
                    puHandler = new PortUnificationServerHandler(sslContext, PortUnificationServer.this.protocols);
                } else {
                    puHandler = new PortUnificationServerHandler(PortUnificationServer.this.protocols);
                }
                p.addLast("server-idle-handler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)idleTimeout, TimeUnit.MILLISECONDS));
                p.addLast("negotiation", (ChannelHandler)puHandler);
                PortUnificationServer.this.channelGroup = puHandler.getChannels();
            }
        });
        String bindIp = this.getUrl().getParameter("bind.ip", this.getUrl().getHost());
        int bindPort = this.getUrl().getParameter("bind.port", this.getUrl().getPort());
        if (this.url.getParameter("anyhost", false) || NetUtils.isInvalidLocalHost(bindIp)) {
            bindIp = "0.0.0.0";
        }
        InetSocketAddress bindAddress = new InetSocketAddress(bindIp, bindPort);
        ChannelFuture channelFuture = this.bootstrap.bind((SocketAddress)bindAddress);
        channelFuture.syncUninterruptibly();
        this.channel = channelFuture.channel();
    }

    protected void doClose() throws Throwable {
        long st = System.currentTimeMillis();
        try {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            if (this.channelGroup != null) {
                ChannelGroupFuture closeFuture = this.channelGroup.close();
                closeFuture.await(15000L);
            }
            long cost = System.currentTimeMillis() - st;
            logger.info("Port unification server closed. cost:" + cost);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while shutting down", e);
        }
        for (WireProtocol protocol : this.protocols) {
            protocol.close();
        }
        try {
            if (this.bootstrap != null) {
                this.bossGroup.shutdownGracefully().syncUninterruptibly();
                this.workerGroup.shutdownGracefully().syncUninterruptibly();
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public boolean isBound() {
        return this.channel.isActive();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }
}

