/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.List;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.api.WireProtocol;

public class PortUnificationServerHandler
extends ByteToMessageDecoder {
    private final SslContext sslCtx;
    private final boolean detectSsl;
    private final List<WireProtocol> protocols;
    private final DefaultChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    public PortUnificationServerHandler(List<WireProtocol> protocols) {
        this(null, false, protocols);
    }

    public PortUnificationServerHandler(SslContext sslCtx, List<WireProtocol> protocols) {
        this(sslCtx, true, protocols);
    }

    public PortUnificationServerHandler(SslContext sslCtx, boolean detectSsl, List<WireProtocol> protocols) {
        this.sslCtx = sslCtx;
        this.protocols = protocols;
        this.detectSsl = detectSsl;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
    }

    public DefaultChannelGroup getChannels() {
        return this.channels;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.channels.add(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.channels.remove((Object)ctx.channel());
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 5) {
            return;
        }
        if (this.isSsl(in)) {
            this.enableSsl(ctx);
        } else {
            block5: for (WireProtocol protocol : this.protocols) {
                in.markReaderIndex();
                ProtocolDetector.Result result = protocol.detector().detect(ctx, in);
                in.resetReaderIndex();
                switch (result) {
                    case UNRECOGNIZED: {
                        continue block5;
                    }
                    case RECOGNIZED: {
                        protocol.configServerPipeline(ctx.pipeline(), null);
                        ctx.pipeline().remove((ChannelHandler)this);
                    }
                    case NEED_MORE_DATA: {
                        return;
                    }
                }
            }
            in.clear();
            ctx.close();
        }
    }

    private boolean isSsl(ByteBuf buf) {
        if (this.detectSsl) {
            return SslHandler.isEncrypted((ByteBuf)buf);
        }
        return false;
    }

    private void enableSsl(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        p.addLast("ssl", (ChannelHandler)this.sslCtx.newHandler(ctx.alloc()));
        p.addLast("unificationA", (ChannelHandler)new PortUnificationServerHandler(this.sslCtx, false, this.protocols));
        p.remove((ChannelHandler)this);
    }
}

