/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.state;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.RouterChain;
import org.apache.dubbo.rpc.cluster.governance.GovernanceRuleRepository;
import org.apache.dubbo.rpc.cluster.router.state.AddrCache;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.RouterCache;
import org.apache.dubbo.rpc.cluster.router.state.StateRouter;

public abstract class AbstractStateRouter
implements StateRouter {
    protected final RouterChain chain;
    protected int priority = Integer.MAX_VALUE;
    protected boolean force = false;
    protected URL url;
    protected List<Invoker> invokers;
    protected AtomicReference<AddrCache> cache;
    protected GovernanceRuleRepository ruleRepository = ExtensionLoader.getExtensionLoader(GovernanceRuleRepository.class).getDefaultExtension();

    public AbstractStateRouter(URL url, RouterChain chain) {
        this.chain = chain;
        this.url = url;
    }

    @Override
    public <T> void notify(List<Invoker<T>> invokers) {
        this.invokers = invokers;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    @Override
    public boolean isRuntime() {
        return true;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public <T> BitList<Invoker<T>> route(BitList<Invoker<T>> invokers, RouterCache<T> cache, URL url, Invocation invocation) throws RpcException {
        List<String> tags = this.getTags(url, invocation);
        if (tags == null) {
            return invokers;
        }
        for (String tag : tags) {
            BitList tagInvokers = (BitList)cache.getAddrPool().get(tag);
            if (this.tagMatchFail(tagInvokers).booleanValue()) continue;
            return tagInvokers.intersect(invokers, invokers.getUnmodifiableList());
        }
        return invokers;
    }

    protected List<String> getTags(URL url, Invocation invocation) {
        return new ArrayList<String>();
    }

    public <T> Boolean tagMatchFail(BitList<Invoker<T>> invokers) {
        return invokers == null || invokers.isEmpty();
    }

    @Override
    public void pool() {
        this.chain.loop(false);
    }
}

