/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.tag;

import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.RouterChain;
import org.apache.dubbo.rpc.cluster.router.state.AbstractStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.RouterCache;
import org.apache.dubbo.rpc.cluster.router.tag.model.TagRouterRule;
import org.apache.dubbo.rpc.cluster.router.tag.model.TagRuleParser;

public class TagDynamicStateRouter
extends AbstractStateRouter
implements ConfigurationListener {
    public static final String NAME = "TAG_ROUTER";
    private static final int TAG_ROUTER_DEFAULT_PRIORITY = 100;
    private static final Logger logger = LoggerFactory.getLogger(TagDynamicStateRouter.class);
    private static final String RULE_SUFFIX = ".tag-router";
    private static final String NO_TAG = "noTag";
    private TagRouterRule tagRouterRule;
    private String application;

    public TagDynamicStateRouter(URL url, RouterChain chain) {
        super(url, chain);
        this.priority = 100;
    }

    @Override
    public synchronized void process(ConfigChangedEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("Notification of tag rule, change type is: " + (Object)((Object)event.getChangeType()) + ", raw rule is:\n " + event.getContent());
        }
        try {
            this.tagRouterRule = event.getChangeType().equals((Object)ConfigChangeType.DELETED) ? null : TagRuleParser.parse(event.getContent());
        }
        catch (Exception e) {
            logger.error("Failed to parse the raw tag router rule and it will not take effect, please check if the rule matches with the template, the raw rule is:\n ", e);
        }
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public <T> BitList<Invoker<T>> route(BitList<Invoker<T>> invokers, RouterCache<T> cache, URL url, Invocation invocation) throws RpcException {
        TagRouterRule tagRouterRuleCopy = (TagRouterRule)cache.getAddrMetadata();
        String tag = StringUtils.isEmpty(invocation.getAttachment("dubbo.tag")) ? url.getParameter("dubbo.tag") : invocation.getAttachment("dubbo.tag");
        ConcurrentMap<String, BitList<Invoker<T>>> addrPool = cache.getAddrPool();
        if (StringUtils.isEmpty(tag)) {
            return invokers.intersect((List)addrPool.get(NO_TAG), invokers.getUnmodifiableList());
        }
        BitList result = (BitList)addrPool.get(tag);
        if (CollectionUtils.isNotEmpty(result) || tagRouterRuleCopy != null && tagRouterRuleCopy.isForce() || this.isForceUseTag(invocation)) {
            return invokers.intersect(result, invokers.getUnmodifiableList());
        }
        invocation.setAttachment("dubbo.tag", NO_TAG);
        return invokers;
    }

    private boolean isForceUseTag(Invocation invocation) {
        return Boolean.valueOf(invocation.getAttachment("dubbo.force.tag", this.url.getParameter("dubbo.force.tag", "false")));
    }

    @Override
    public boolean isRuntime() {
        return this.tagRouterRule != null && this.tagRouterRule.isRuntime();
    }

    @Override
    public boolean isEnable() {
        return true;
    }

    @Override
    public boolean isForce() {
        return this.tagRouterRule != null && this.tagRouterRule.isForce();
    }

    @Override
    public String getName() {
        return "TagDynamic";
    }

    @Override
    public boolean shouldRePool() {
        return false;
    }

    @Override
    public <T> RouterCache<T> pool(List<Invoker<T>> invokers) {
        RouterCache routerCache = new RouterCache();
        ConcurrentHashMap addrPool = new ConcurrentHashMap();
        TagRouterRule tagRouterRuleCopy = this.tagRouterRule;
        if (tagRouterRuleCopy == null || !tagRouterRuleCopy.isValid() || !tagRouterRuleCopy.isEnabled()) {
            BitList<Invoker<T>> noTagList = new BitList<Invoker<T>>(invokers, true);
            for (int index = 0; index < invokers.size(); ++index) {
                noTagList.addIndex(index);
            }
            addrPool.put(NO_TAG, noTagList);
            routerCache.setAddrPool(addrPool);
            return routerCache;
        }
        List<String> tagNames = tagRouterRuleCopy.getTagNames();
        Map<String, List<String>> tagnameToAddresses = tagRouterRuleCopy.getTagnameToAddresses();
        for (String tag : tagNames) {
            List<String> addresses = tagnameToAddresses.get(tag);
            BitList<Invoker<T>> list = new BitList<Invoker<T>>(invokers, true);
            if (CollectionUtils.isEmpty(addresses)) {
                list.addAll(invokers);
            } else {
                for (int index = 0; index < invokers.size(); ++index) {
                    Invoker<T> invoker = invokers.get(index);
                    if (!this.addressMatches(invoker.getUrl(), addresses)) continue;
                    list.addIndex(index);
                }
            }
            addrPool.put(tag, list);
        }
        List<String> addresses = tagRouterRuleCopy.getAddresses();
        BitList<Invoker<T>> noTagList = new BitList<Invoker<T>>(invokers, true);
        for (int index = 0; index < invokers.size(); ++index) {
            Invoker<T> invoker = invokers.get(index);
            if (!this.addressNotMatches(invoker.getUrl(), addresses)) continue;
            noTagList.addIndex(index);
        }
        addrPool.put(NO_TAG, noTagList);
        routerCache.setAddrPool(addrPool);
        routerCache.setAddrMetadata(tagRouterRuleCopy);
        return routerCache;
    }

    private boolean addressMatches(URL url, List<String> addresses) {
        return addresses != null && this.checkAddressMatch(addresses, url.getHost(), url.getPort());
    }

    private boolean addressNotMatches(URL url, List<String> addresses) {
        return addresses == null || !this.checkAddressMatch(addresses, url.getHost(), url.getPort());
    }

    private boolean checkAddressMatch(List<String> addresses, String host, int port) {
        for (String address : addresses) {
            try {
                if (NetUtils.matchIpExpression(address, host, port)) {
                    return true;
                }
                if (!("0.0.0.0:" + port).equals(address)) continue;
                return true;
            }
            catch (UnknownHostException e) {
                logger.error("The format of ip address is invalid in tag route. Address :" + address, e);
            }
            catch (Exception e) {
                logger.error("The format of ip address is invalid in tag route. Address :" + address, e);
            }
        }
        return false;
    }

    public void setApplication(String app) {
        this.application = app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void notify(List<Invoker<T>> invokers) {
        if (CollectionUtils.isEmpty(invokers)) {
            return;
        }
        Invoker<T> invoker = invokers.get(0);
        URL url = invoker.getUrl();
        String providerApplication = url.getRemoteApplication();
        if (StringUtils.isEmpty(providerApplication)) {
            logger.error("TagRouter must getConfig from or subscribe to a specific application, but the application in this TagRouter is not specified.");
            return;
        }
        TagDynamicStateRouter tagDynamicStateRouter = this;
        synchronized (tagDynamicStateRouter) {
            if (!providerApplication.equals(this.application)) {
                if (!StringUtils.isEmpty(this.application)) {
                    this.ruleRepository.removeListener(this.application + RULE_SUFFIX, this);
                }
                String key = providerApplication + RULE_SUFFIX;
                this.ruleRepository.addListener(key, this);
                this.application = providerApplication;
                String rawRule = this.ruleRepository.getRule(key, "dubbo");
                if (StringUtils.isNotEmpty(rawRule)) {
                    this.process(new ConfigChangedEvent(key, "dubbo", rawRule));
                }
            }
        }
        this.pool(invokers);
    }
}

