/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.context.FrameworkExt;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.rpc.model.ApplicationInitListener;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceRepository;

public class ApplicationModel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModel.class);
    public static final String NAME = "application";
    private static AtomicBoolean INIT_FLAG = new AtomicBoolean(false);
    private static final ExtensionLoader<FrameworkExt> LOADER = ExtensionLoader.getExtensionLoader(FrameworkExt.class);
    @Deprecated
    private static String application;

    public static void init() {
        if (INIT_FLAG.compareAndSet(false, true)) {
            ExtensionLoader<ApplicationInitListener> extensionLoader = ExtensionLoader.getExtensionLoader(ApplicationInitListener.class);
            Set<String> listenerNames = extensionLoader.getSupportedExtensions();
            for (String listenerName : listenerNames) {
                extensionLoader.getExtension(listenerName).init();
            }
        }
    }

    public static Collection<ConsumerModel> allConsumerModels() {
        return ApplicationModel.getServiceRepository().getReferredServices();
    }

    public static Collection<ProviderModel> allProviderModels() {
        return ApplicationModel.getServiceRepository().getExportedServices();
    }

    public static ProviderModel getProviderModel(String serviceKey) {
        return ApplicationModel.getServiceRepository().lookupExportedService(serviceKey);
    }

    public static ConsumerModel getConsumerModel(String serviceKey) {
        return ApplicationModel.getServiceRepository().lookupReferredService(serviceKey);
    }

    public static void initFrameworkExts() {
        Set<FrameworkExt> exts = ExtensionLoader.getExtensionLoader(FrameworkExt.class).getSupportedExtensionInstances();
        for (FrameworkExt ext : exts) {
            ext.initialize();
        }
    }

    public static Environment getEnvironment() {
        return (Environment)LOADER.getExtension("environment");
    }

    public static ConfigManager getConfigManager() {
        return (ConfigManager)LOADER.getExtension("config");
    }

    public static ServiceRepository getServiceRepository() {
        return (ServiceRepository)LOADER.getExtension("repository");
    }

    public static ExecutorRepository getExecutorRepository() {
        return ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
    }

    public static ApplicationConfig getApplicationConfig() {
        return ApplicationModel.getConfigManager().getApplicationOrElseThrow();
    }

    public static String getName() {
        return ApplicationModel.getApplicationConfig().getName();
    }

    @Deprecated
    public static String getApplication() {
        return application == null ? ApplicationModel.getName() : application;
    }

    @Deprecated
    public static void setApplication(String application) {
        ApplicationModel.application = application;
    }

    public static void reset() {
        ApplicationModel.getServiceRepository().destroy();
        ApplicationModel.getConfigManager().destroy();
        ApplicationModel.getEnvironment().reset();
    }
}

