/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.remoting.api.Connection;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.protocol.tri.AbstractStream;
import org.apache.dubbo.rpc.protocol.tri.ClassLoadUtil;
import org.apache.dubbo.rpc.protocol.tri.ClientStream;
import org.apache.dubbo.rpc.protocol.tri.DefaultMetadata;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.Stream;
import org.apache.dubbo.rpc.protocol.tri.TripleUtil;
import org.apache.dubbo.rpc.protocol.tri.UnaryClientStream;
import org.apache.dubbo.triple.TripleWrapper;

public abstract class AbstractClientStream
extends AbstractStream
implements Stream {
    private ConsumerModel consumerModel;
    private Connection connection;

    protected AbstractClientStream(URL url) {
        super(url);
    }

    protected AbstractClientStream(URL url, Executor executor) {
        super(url, executor);
    }

    public static UnaryClientStream unary(URL url, Executor executor) {
        return new UnaryClientStream(url, executor);
    }

    public static AbstractClientStream stream(URL url) {
        return new ClientStream(url);
    }

    public AbstractClientStream service(ConsumerModel model) {
        this.consumerModel = model;
        return this;
    }

    public ConsumerModel getConsumerModel() {
        return this.consumerModel;
    }

    public AbstractClientStream connection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void execute(Runnable runnable) {
        try {
            super.execute(runnable);
        }
        catch (RejectedExecutionException e) {
            LOGGER.error("Consumer's thread pool is full", e);
            this.getStreamSubscriber().onError(GrpcStatus.fromCode(GrpcStatus.Code.RESOURCE_EXHAUSTED).withDescription("Consumer's thread pool is full").asException());
        }
        catch (Throwable t) {
            LOGGER.error("Consumer submit request to thread pool error ", t);
            this.getStreamSubscriber().onError(GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withCause(t).withDescription("Consumer's error").asException());
        }
    }

    protected byte[] encodeRequest(Object value) {
        Object obj = this.getMethodDescriptor().isNeedWrap() ? this.getRequestWrapper(value) : this.getRequestValue(value);
        byte[] out = TripleUtil.pack(obj);
        return out;
    }

    private TripleWrapper.TripleRequestWrapper getRequestWrapper(Object value) {
        if (this.getMethodDescriptor().isStream()) {
            String type = this.getMethodDescriptor().getParameterClasses()[0].getName();
            return TripleUtil.wrapReq(this.getUrl(), this.getSerializeType(), value, type, this.getMultipleSerialization());
        }
        RpcInvocation invocation = (RpcInvocation)value;
        return TripleUtil.wrapReq(this.getUrl(), invocation, this.getMultipleSerialization());
    }

    private Object getRequestValue(Object value) {
        if (this.getMethodDescriptor().isUnary()) {
            RpcInvocation invocation = (RpcInvocation)value;
            return invocation.getArguments()[0];
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserializeResponse(byte[] data) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (this.getConsumerModel() != null) {
                ClassLoadUtil.switchContextLoader(this.getConsumerModel().getServiceInterfaceClass().getClassLoader());
            }
            if (this.getMethodDescriptor().isNeedWrap()) {
                TripleWrapper.TripleResponseWrapper wrapper = TripleUtil.unpack(data, TripleWrapper.TripleResponseWrapper.class);
                this.serialize(wrapper.getSerializeType());
                Object object = TripleUtil.unwrapResp(this.getUrl(), wrapper, this.getMultipleSerialization());
                return object;
            }
            Object obj = TripleUtil.unpack(data, this.getMethodDescriptor().getReturnClass());
            return obj;
        }
        finally {
            ClassLoadUtil.switchContextLoader(tccl);
        }
    }

    protected Metadata createRequestMeta(RpcInvocation inv) {
        DefaultMetadata metadata = new DefaultMetadata();
        metadata.put(":path", "/" + inv.getObjectAttachment("path") + "/" + inv.getMethodName()).put(":authority", this.getUrl().getAddress()).put("content-type", "application/grpc+proto").put("grpc-timeout", inv.get("timeout") + "m").put((CharSequence)HttpHeaderNames.TE, (CharSequence)HttpHeaderValues.TRAILERS);
        metadata.putIfNotNull("tri-service-version", inv.getInvoker().getUrl().getVersion()).putIfNotNull("tri-consumer-appname", (String)inv.getObjectAttachments().remove("application")).putIfNotNull("tri-consumer-appname", (String)inv.getObjectAttachments().remove("remote.application")).putIfNotNull("tri-service-group", inv.getInvoker().getUrl().getGroup());
        inv.getObjectAttachments().remove("group");
        inv.getObjectAttachments().remove("interface");
        inv.getObjectAttachments().remove("path");
        metadata.forEach(e -> metadata.put((CharSequence)e.getKey(), (CharSequence)e.getValue()));
        Map<String, Object> attachments = inv.getObjectAttachments();
        if (attachments != null) {
            this.convertAttachment(metadata, attachments);
        }
        return metadata;
    }

    protected class ClientStreamObserver
    implements StreamObserver<Object> {
        protected ClientStreamObserver() {
        }

        @Override
        public void onNext(Object data) {
            RpcInvocation invocation = (RpcInvocation)data;
            Metadata metadata = AbstractClientStream.this.createRequestMeta(invocation);
            AbstractClientStream.this.getTransportSubscriber().tryOnMetadata(metadata, false);
            byte[] bytes = AbstractClientStream.this.encodeRequest(invocation);
            AbstractClientStream.this.getTransportSubscriber().tryOnData(bytes, false);
        }

        @Override
        public void onError(Throwable throwable) {
        }

        @Override
        public void onCompleted() {
            AbstractClientStream.this.getTransportSubscriber().tryOnComplete();
        }
    }
}

