/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SingleProtobufSerialization {
    private static final ConcurrentHashMap<Class<?>, Message> instCache = new ConcurrentHashMap();
    private static final ExtensionRegistryLite globalRegistry = ExtensionRegistryLite.getEmptyRegistry();
    private final ConcurrentMap<Class<?>, SingleMessageMarshaller<?>> marshallers = new ConcurrentHashMap();

    public static Message defaultInst(Class<?> clz) {
        Message defaultInst = instCache.get(clz);
        if (defaultInst != null) {
            return defaultInst;
        }
        try {
            defaultInst = (Message)clz.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Create default protobuf instance failed ", e);
        }
        instCache.put(clz, defaultInst);
        return defaultInst;
    }

    public static <T> Parser<T> getParser(Class<T> clz) {
        Message defaultInst = SingleProtobufSerialization.defaultInst(clz);
        return defaultInst.getParserForType();
    }

    public Object deserialize(InputStream in, Class<?> clz) throws IOException {
        try {
            return this.getMarshaller(clz).parse(in);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IOException(e);
        }
    }

    public void serialize(Object obj, OutputStream os) throws IOException {
        MessageLite msg = (MessageLite)obj;
        msg.writeTo(os);
    }

    private SingleMessageMarshaller<?> getMarshaller(Class<?> clz) {
        return this.marshallers.computeIfAbsent(clz, k -> new SingleMessageMarshaller(k));
    }

    public static final class SingleMessageMarshaller<T extends MessageLite> {
        private final Parser<T> parser;

        SingleMessageMarshaller(Class<T> clz) {
            Message inst = SingleProtobufSerialization.defaultInst(clz);
            this.parser = inst.getParserForType();
        }

        public T parse(InputStream stream) throws InvalidProtocolBufferException {
            return (T)((MessageLite)this.parser.parseFrom(stream, globalRegistry));
        }
    }
}

