/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.remoting.api.Connection;
import org.apache.dubbo.remoting.api.ConnectionHandler;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.exchange.support.DefaultFuture2;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceRepository;
import org.apache.dubbo.rpc.protocol.tri.AbstractClientStream;
import org.apache.dubbo.rpc.protocol.tri.ClassLoadUtil;
import org.apache.dubbo.rpc.protocol.tri.ClientTransportObserver;

public class TripleClientHandler
extends ChannelDuplexHandler {
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Request) {
            this.writeRequest(ctx, (Request)msg, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof Http2SettingsFrame)) {
            if (msg instanceof Http2GoAwayFrame) {
                ConnectionHandler connectionHandler = (ConnectionHandler)ctx.pipeline().get(ConnectionHandler.class);
                connectionHandler.onGoAway(ctx.channel());
                ReferenceCountUtil.release((Object)msg);
            } else {
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }

    private void writeRequest(ChannelHandlerContext ctx, Request req, ChannelPromise promise) {
        RpcInvocation inv = (RpcInvocation)req.getData();
        URL url = inv.getInvoker().getUrl();
        ServiceRepository repo = ApplicationModel.getServiceRepository();
        MethodDescriptor methodDescriptor = repo.lookupMethod(inv.getServiceName(), inv.getMethodName());
        ConsumerModel service = repo.lookupReferredService(url.getServiceKey());
        if (service != null) {
            ClassLoadUtil.switchContextLoader(service.getServiceInterfaceClass().getClassLoader());
        }
        Executor executor = (Executor)inv.getAttributes().remove("callback.executor");
        AbstractClientStream stream = methodDescriptor.isUnary() ? AbstractClientStream.unary(url, executor) : AbstractClientStream.stream(url);
        stream.service(service).connection(Connection.getConnectionFromChannel(ctx.channel())).method(methodDescriptor).methodName(methodDescriptor.getMethodName()).request(req).serialize((String)inv.getObjectAttachment("serialization")).subscribe(new ClientTransportObserver(ctx, stream, promise));
        if (methodDescriptor.isUnary()) {
            stream.asStreamObserver().onNext(inv);
            stream.asStreamObserver().onCompleted();
        } else {
            StreamObserver streamObserver = (StreamObserver)inv.getArguments()[0];
            stream.subscribe(streamObserver);
            Response response = new Response(req.getId(), req.getVersion());
            AppResponse result = new AppResponse(stream.asStreamObserver());
            response.setResult(result);
            DefaultFuture2.received(stream.getConnection(), response);
        }
    }
}

