/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamFrame;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.protocol.tri.AbstractClientStream;
import org.apache.dubbo.rpc.protocol.tri.DefaultMetadata;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Http2HeaderMeta;
import org.apache.dubbo.rpc.protocol.tri.TransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TripleUtil;

public final class TripleHttp2ClientResponseHandler
extends SimpleChannelInboundHandler<Http2StreamFrame> {
    private static final Logger logger = LoggerFactory.getLogger(TripleHttp2ClientResponseHandler.class);

    public TripleHttp2ClientResponseHandler() {
        super(false);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        super.userEventTriggered(ctx, evt);
        if (evt instanceof Http2GoAwayFrame) {
            Http2GoAwayFrame event = (Http2GoAwayFrame)evt;
            ctx.close();
            logger.debug("Event triggered, event name is: " + event.name() + ", last stream id is: " + event.lastStreamId());
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Http2StreamFrame msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            this.onHeadersRead(ctx, (Http2HeadersFrame)msg);
        } else if (msg instanceof Http2DataFrame) {
            this.onDataRead(ctx, (Http2DataFrame)msg);
        } else {
            super.channelRead(ctx, (Object)msg);
        }
    }

    private void onHeadersRead(ChannelHandlerContext ctx, Http2HeadersFrame msg) {
        Http2Headers headers = msg.headers();
        AbstractClientStream clientStream = TripleUtil.getClientStream(ctx);
        TransportObserver observer = clientStream.asTransportObserver();
        observer.tryOnMetadata(new Http2HeaderMeta(headers), false);
        if (msg.isEndStream()) {
            observer.tryOnComplete();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        AbstractClientStream clientStream = TripleUtil.getClientStream(ctx);
        GrpcStatus status = GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withCause(cause);
        DefaultMetadata metadata = new DefaultMetadata();
        metadata.put("grpc-status", Integer.toString(status.code.code));
        metadata.put("grpc-message", status.toMessage());
        logger.warn("Meet Exception on ClientResponseHandler, status code is: " + (Object)((Object)status.code), cause);
        clientStream.asStreamObserver().onError(status.asException());
        ctx.close();
    }

    public void onDataRead(ChannelHandlerContext ctx, Http2DataFrame msg) throws Exception {
        AbstractClientStream clientStream;
        super.channelRead(ctx, (Object)msg.content());
        if (msg.isEndStream() && (clientStream = TripleUtil.getClientStream(ctx)) != null) {
            clientStream.asTransportObserver().tryOnComplete();
        }
    }
}

