/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.SslContext;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.api.Http2WireProtocol;
import org.apache.dubbo.rpc.protocol.tri.TripleClientHandler;
import org.apache.dubbo.rpc.protocol.tri.TripleServerConnectionHandler;
import org.apache.dubbo.rpc.protocol.tri.TripleServerInitializer;

@Activate
public class TripleHttp2Protocol
extends Http2WireProtocol {
    @Override
    public void close() {
        super.close();
    }

    @Override
    public void configServerPipeline(ChannelPipeline pipeline, SslContext sslContext) {
        Http2FrameCodec codec = Http2FrameCodecBuilder.forServer().gracefulShutdownTimeoutMillis(10000L).initialSettings(new Http2Settings().maxHeaderListSize(8192L).maxFrameSize(131072).maxConcurrentStreams(Integer.MAX_VALUE).initialWindowSize(0x100000)).frameLogger(SERVER_LOGGER).build();
        Http2MultiplexHandler handler = new Http2MultiplexHandler((ChannelHandler)new TripleServerInitializer());
        pipeline.addLast(new ChannelHandler[]{codec, new TripleServerConnectionHandler(), handler, new SimpleChannelInboundHandler<Object>(){

            protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
            }
        }});
    }

    @Override
    public void configClientPipeline(ChannelPipeline pipeline, SslContext sslContext) {
        Http2FrameCodec codec = Http2FrameCodecBuilder.forClient().initialSettings(new Http2Settings().maxHeaderListSize(8192L).maxFrameSize(131072).maxConcurrentStreams(Integer.MAX_VALUE).initialWindowSize(0x100000)).gracefulShutdownTimeoutMillis(10000L).frameLogger(CLIENT_LOGGER).build();
        Http2MultiplexHandler handler = new Http2MultiplexHandler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
            }
        });
        pipeline.addLast(new ChannelHandler[]{codec, handler, new TripleClientHandler()});
    }
}

