/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.util.ArrayList;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.PortUnificationExchanger;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.AbstractExporter;
import org.apache.dubbo.rpc.protocol.AbstractProtocol;
import org.apache.dubbo.rpc.protocol.tri.PathResolver;
import org.apache.dubbo.rpc.protocol.tri.TripleInvoker;

public class TripleProtocol
extends AbstractProtocol
implements Protocol {
    private static final Logger logger = LoggerFactory.getLogger(TripleProtocol.class);
    private final PathResolver pathResolver = ExtensionLoader.getExtensionLoader(PathResolver.class).getDefaultExtension();
    private final ExecutorRepository executorRepository = ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();

    @Override
    public int getDefaultPort() {
        return 50051;
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        final URL url = invoker.getUrl();
        final String key = TripleProtocol.serviceKey(url);
        AbstractExporter exporter = new AbstractExporter<T>(invoker){

            @Override
            public void afterUnExport() {
                TripleProtocol.this.pathResolver.remove(url.getServiceKey());
                TripleProtocol.this.pathResolver.remove(url.getServiceInterface());
                TripleProtocol.this.exporterMap.remove(key);
            }
        };
        this.exporterMap.put(key, exporter);
        this.invokers.add(invoker);
        this.pathResolver.add(url.getServiceKey(), invoker);
        this.pathResolver.add(url.getServiceInterface(), invoker);
        PortUnificationExchanger.bind(invoker.getUrl());
        return exporter;
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        TripleInvoker<T> invoker;
        try {
            url = ExecutorUtil.setThreadName(url, "DubboClientHandler");
            url = url.addParameterIfAbsent("threadpool", "cached");
            this.executorRepository.createExecutorIfAbsent(url);
            invoker = new TripleInvoker<T>(type, url, this.invokers);
        }
        catch (RemotingException e) {
            throw new RpcException("Fail to create remoting client for service(" + url + "): " + e.getMessage(), (Throwable)e);
        }
        this.invokers.add(invoker);
        return invoker;
    }

    @Override
    protected <T> Invoker<T> protocolBindingRefer(Class<T> type, URL url) throws RpcException {
        return null;
    }

    @Override
    public void destroy() {
        PortUnificationExchanger.close();
        this.pathResolver.destroy();
        for (String key : new ArrayList(this.exporterMap.keySet())) {
            Exporter exporter = (Exporter)this.exporterMap.remove(key);
            if (exporter == null) continue;
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("Unexport service: " + exporter.getInvoker().getUrl());
                }
                exporter.unexport();
            }
            catch (Throwable t) {
                logger.warn(t.getMessage(), t);
            }
        }
    }
}

