/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2ChannelDuplexHandler;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.util.ReferenceCountUtil;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.protocol.tri.GracefulShutdown;

public class TripleServerConnectionHandler
extends Http2ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(TripleServerConnectionHandler.class);
    private GracefulShutdown gracefulShutdown;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2PingFrame) {
            if (((Http2PingFrame)msg).content() == 40715087873L) {
                if (this.gracefulShutdown == null) {
                    logger.warn("Received GRACEFUL_SHUTDOWN_PING Ack but gracefulShutdown is null");
                } else {
                    this.gracefulShutdown.secondGoAwayAndClose(ctx);
                }
            }
        } else if (msg instanceof Http2GoAwayFrame) {
            ReferenceCountUtil.release((Object)msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.warn(String.format("Channel:%s Error", ctx.channel()), cause);
        ctx.close();
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (this.gracefulShutdown == null) {
            this.gracefulShutdown = new GracefulShutdown(ctx, "app_requested", promise);
        }
        this.gracefulShutdown.gracefulShutdown();
    }
}

