/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AttributeKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.MultipleSerialization;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.AbstractClientStream;
import org.apache.dubbo.rpc.protocol.tri.AbstractServerStream;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.SingleProtobufSerialization;
import org.apache.dubbo.triple.TripleWrapper;

public class TripleUtil {
    public static final AttributeKey<AbstractServerStream> SERVER_STREAM_KEY = AttributeKey.newInstance((String)"tri_server_stream");
    public static final AttributeKey<AbstractClientStream> CLIENT_STREAM_KEY = AttributeKey.newInstance((String)"tri_client_stream");
    private static final SingleProtobufSerialization pbSerialization = new SingleProtobufSerialization();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder().withoutPadding();

    public static AbstractServerStream getServerStream(ChannelHandlerContext ctx) {
        return (AbstractServerStream)ctx.channel().attr(SERVER_STREAM_KEY).get();
    }

    public static AbstractClientStream getClientStream(ChannelHandlerContext ctx) {
        return (AbstractClientStream)ctx.channel().attr(CLIENT_STREAM_KEY).get();
    }

    public static boolean supportContentType(String contentType) {
        if (contentType == null) {
            return false;
        }
        return contentType.startsWith("application/grpc");
    }

    public static void responseErr(ChannelHandlerContext ctx, GrpcStatus status) {
        Http2Headers trailers = (Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.OK.codeAsText()).set((Object)HttpHeaderNames.CONTENT_TYPE, (Object)"application/grpc+proto")).setInt((Object)"grpc-status", status.code.code)).set((Object)"grpc-message", (Object)status.toMessage());
        ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame(trailers, true));
    }

    public static void responsePlainTextError(ChannelHandlerContext ctx, int code, GrpcStatus status) {
        Http2Headers headers = (Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers(true).status((CharSequence)("" + code)).setInt((Object)"grpc-status", status.code.code)).set((Object)"grpc-message", (Object)status.description)).set((Object)"content-type", (Object)"text/plain; encoding=utf-8");
        ctx.write((Object)new DefaultHttp2HeadersFrame(headers));
        ByteBuf buf = ByteBufUtil.writeUtf8((ByteBufAllocator)ctx.alloc(), (CharSequence)status.description);
        ctx.write((Object)new DefaultHttp2DataFrame(buf, true));
    }

    public static Object unwrapResp(URL url, TripleWrapper.TripleResponseWrapper wrap, MultipleSerialization serialization) {
        String serializeType = TripleUtil.convertHessianFromWrapper(wrap.getSerializeType());
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(wrap.getData().toByteArray());
            Object ret = serialization.deserialize(url, serializeType, wrap.getType(), bais);
            bais.close();
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to unwrap resp", e);
        }
    }

    public static Object[] unwrapReq(URL url, TripleWrapper.TripleRequestWrapper wrap, MultipleSerialization multipleSerialization) {
        String serializeType = TripleUtil.convertHessianFromWrapper(wrap.getSerializeType());
        try {
            Object[] arguments = new Object[wrap.getArgsCount()];
            for (int i = 0; i < arguments.length; ++i) {
                Object obj;
                ByteArrayInputStream bais = new ByteArrayInputStream(wrap.getArgs(i).toByteArray());
                arguments[i] = obj = multipleSerialization.deserialize(url, serializeType, wrap.getArgTypes(i), bais);
            }
            return arguments;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to unwrap req: " + e.getMessage(), e);
        }
    }

    public static TripleWrapper.TripleResponseWrapper wrapResp(URL url, String serializeType, Object resp, MethodDescriptor desc, MultipleSerialization multipleSerialization) {
        try {
            TripleWrapper.TripleResponseWrapper.Builder builder = TripleWrapper.TripleResponseWrapper.newBuilder().setType(desc.getReturnClass().getName()).setSerializeType(TripleUtil.convertHessianToWrapper(serializeType));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            multipleSerialization.serialize(url, serializeType, desc.getReturnClass().getName(), resp, bos);
            builder.setData(ByteString.copyFrom((byte[])bos.toByteArray()));
            bos.close();
            return builder.build();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to pack wrapper req", e);
        }
    }

    public static TripleWrapper.TripleRequestWrapper wrapReq(URL url, String serializeType, Object req, String type, MultipleSerialization multipleSerialization) {
        try {
            TripleWrapper.TripleRequestWrapper.Builder builder = TripleWrapper.TripleRequestWrapper.newBuilder().addArgTypes(type).setSerializeType(TripleUtil.convertHessianToWrapper(serializeType));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            multipleSerialization.serialize(url, serializeType, type, req, bos);
            builder.addArgs(ByteString.copyFrom((byte[])bos.toByteArray()));
            bos.close();
            return builder.build();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to pack wrapper req", e);
        }
    }

    public static TripleWrapper.TripleRequestWrapper wrapReq(URL url, RpcInvocation invocation, MultipleSerialization serialization) {
        try {
            String serializationName = (String)invocation.getObjectAttachment("serialization");
            TripleWrapper.TripleRequestWrapper.Builder builder = TripleWrapper.TripleRequestWrapper.newBuilder().setSerializeType(TripleUtil.convertHessianToWrapper(serializationName));
            for (int i = 0; i < invocation.getArguments().length; ++i) {
                String clz = invocation.getParameterTypes()[i].getName();
                builder.addArgTypes(clz);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                serialization.serialize(url, serializationName, clz, invocation.getArguments()[i], bos);
                builder.addArgs(ByteString.copyFrom((byte[])bos.toByteArray()));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to pack wrapper req", e);
        }
    }

    public static <T> T unpack(byte[] data, Class<T> clz) {
        return TripleUtil.unpack(new ByteArrayInputStream(data), clz);
    }

    public static <T> T unpack(InputStream is, Class<T> clz) {
        try {
            Object req = pbSerialization.deserialize(is, clz);
            is.close();
            Object object = req;
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to unpack req", e);
        }
        finally {
            TripleUtil.closeQuietly(is);
        }
    }

    private static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static byte[] pack(Object obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            pbSerialization.serialize(obj, baos);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to pack protobuf object", e);
        }
        return baos.toByteArray();
    }

    public static String encodeWrapper(URL url, Object obj, String serializeType, MultipleSerialization serialization) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        serialization.serialize(url, serializeType, obj.getClass().getName(), obj, bos);
        TripleWrapper.TripleRequestWrapper wrap = TripleWrapper.TripleRequestWrapper.newBuilder().setSerializeType(TripleUtil.convertHessianToWrapper(serializeType)).addArgTypes(obj.getClass().getName()).addArgs(ByteString.copyFrom((byte[])bos.toByteArray())).build();
        return TripleUtil.encodeBase64ASCII(wrap.toByteArray());
    }

    public static String encodeBase64ASCII(byte[] in) {
        byte[] bytes = TripleUtil.encodeBase64(in);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    public static byte[] encodeBase64(byte[] in) {
        return BASE64_ENCODER.encode(in);
    }

    public static Object decodeObjFromHeader(URL url, CharSequence value, MultipleSerialization serialization) throws InvalidProtocolBufferException {
        byte[] decode = TripleUtil.decodeASCIIByte(value);
        TripleWrapper.TripleRequestWrapper wrapper = TripleWrapper.TripleRequestWrapper.parseFrom(decode);
        Object[] objects = TripleUtil.unwrapReq(url, wrapper, serialization);
        return objects[0];
    }

    public static byte[] decodeASCIIByte(CharSequence value) {
        return BASE64_DECODER.decode(value.toString().getBytes(StandardCharsets.US_ASCII));
    }

    public static String convertHessianToWrapper(String serializeType) {
        if (serializeType.equals("hessian2")) {
            return "hessian4";
        }
        return serializeType;
    }

    public static String convertHessianFromWrapper(String serializeType) {
        if (serializeType.equals("hessian4")) {
            return "hessian2";
        }
        return serializeType;
    }
}

