/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.exchange.support.DefaultFuture2;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.protocol.tri.AbstractClientStream;
import org.apache.dubbo.rpc.protocol.tri.AbstractStream;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Stream;
import org.apache.dubbo.rpc.protocol.tri.TransportObserver;

public class UnaryClientStream
extends AbstractClientStream
implements Stream {
    protected UnaryClientStream(URL url, Executor executor) {
        super(url, executor);
    }

    @Override
    protected StreamObserver<Object> createStreamObserver() {
        return new AbstractClientStream.ClientStreamObserver();
    }

    @Override
    protected TransportObserver createTransportObserver() {
        return new UnaryClientTransportObserver();
    }

    private class UnaryClientTransportObserver
    extends AbstractStream.UnaryTransportObserver
    implements TransportObserver {
        private UnaryClientTransportObserver() {
        }

        @Override
        public void doOnComplete(Stream.OperationHandler handler) {
            UnaryClientStream.this.execute(() -> {
                try {
                    Object resp = UnaryClientStream.this.deserializeResponse(this.getData());
                    Response response = new Response(UnaryClientStream.this.getRequest().getId(), "1.0.0");
                    AppResponse result = new AppResponse(resp);
                    result.setObjectAttachments(UnaryClientStream.this.parseMetadataToMap(this.getTrailers()));
                    response.setResult(result);
                    DefaultFuture2.received(UnaryClientStream.this.getConnection(), response);
                }
                catch (Exception e) {
                    GrpcStatus status = GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withCause(e).withDescription("Failed to deserialize response");
                    this.onError(status);
                }
            });
        }

        @Override
        protected void onError(GrpcStatus status) {
            Response response = new Response(UnaryClientStream.this.getRequest().getId(), "1.0.0");
            if (status.description != null) {
                response.setErrorMessage(status.description);
            } else {
                response.setErrorMessage(status.cause.getMessage());
            }
            byte code = GrpcStatus.toDubboStatus(status.code);
            response.setStatus(code);
            DefaultFuture2.received(UnaryClientStream.this.getConnection(), response);
        }
    }
}

