/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.beans.support;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelAccessor;

public class InstantiationStrategy {
    private boolean supportConstructorWithArguments;
    private ScopeModelAccessor scopeModelAccessor;

    public InstantiationStrategy() {
        this(null);
    }

    public InstantiationStrategy(ScopeModelAccessor scopeModelAccessor) {
        this.scopeModelAccessor = scopeModelAccessor;
        this.supportConstructorWithArguments = this.scopeModelAccessor != null;
    }

    public <T> T instantiate(Class<T> type) throws ReflectiveOperationException {
        try {
            return type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Constructor<?>[] declaredConstructors;
            if (!this.supportConstructorWithArguments) {
                throw new IllegalArgumentException("Default constructor was not found for type: " + type.getName());
            }
            ArrayList matchedConstructors = new ArrayList();
            for (Constructor<?> constructor : declaredConstructors = type.getConstructors()) {
                if (!this.isMatched(constructor)) continue;
                matchedConstructors.add(constructor);
            }
            if (matchedConstructors.size() > 1) {
                throw new IllegalArgumentException("Expect only one but found " + matchedConstructors.size() + " matched constructors for type: " + type.getName() + ", matched constructors: " + matchedConstructors);
            }
            if (matchedConstructors.size() == 0) {
                throw new IllegalArgumentException("None matched constructor was found for type: " + type.getName());
            }
            Constructor constructor = (Constructor)matchedConstructors.get(0);
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            Object[] args = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                args[i] = this.getArgumentValueForType(parameterTypes[i]);
            }
            return constructor.newInstance(args);
        }
    }

    private boolean isMatched(Constructor<?> constructor) {
        for (Class<?> parameterType : constructor.getParameterTypes()) {
            if (this.isSupportedConstructorParameterType(parameterType)) continue;
            return false;
        }
        return true;
    }

    private boolean isSupportedConstructorParameterType(Class<?> parameterType) {
        return ScopeModel.class.isAssignableFrom(parameterType);
    }

    private Object getArgumentValueForType(Class parameterType) {
        if (this.scopeModelAccessor != null) {
            if (parameterType == ScopeModel.class) {
                return this.scopeModelAccessor.getScopeModel();
            }
            if (parameterType == FrameworkModel.class) {
                return this.scopeModelAccessor.getFrameworkModel();
            }
            if (parameterType == ApplicationModel.class) {
                return this.scopeModelAccessor.getApplicationModel();
            }
            if (parameterType == ModuleModel.class) {
                return this.scopeModelAccessor.getModuleModel();
            }
        }
        return null;
    }
}

