/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config.configcenter.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.TreePathDynamicConfiguration;
import org.apache.dubbo.common.function.ThrowableConsumer;
import org.apache.dubbo.common.function.ThrowableFunction;
import org.apache.dubbo.common.lang.ShutdownHookCallbacks;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class FileSystemDynamicConfiguration
extends TreePathDynamicConfiguration {
    public static final String CONFIG_CENTER_DIR_PARAM_NAME = "dubbo.config-center.dir";
    public static final String CONFIG_CENTER_ENCODING_PARAM_NAME = "dubbo.config-center.encoding";
    public static final String DEFAULT_CONFIG_CENTER_DIR_PATH = System.getProperty("user.home") + File.separator + ".dubbo" + File.separator + "config-center";
    public static final int DEFAULT_THREAD_POOL_SIZE = 1;
    public static final String DEFAULT_CONFIG_CENTER_ENCODING = "UTF-8";
    private static final WatchEvent.Kind[] INTEREST_PATH_KINDS = FileSystemDynamicConfiguration.of(StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
    private static final String POLLING_WATCH_SERVICE_CLASS_NAME = "sun.nio.fs.PollingWatchService";
    private static final int THREAD_POOL_SIZE = 1;
    private static final Log logger = LogFactory.getLog(FileSystemDynamicConfiguration.class);
    private static final Map<String, ConfigChangeType> CONFIG_CHANGE_TYPES_MAP = Collections.unmodifiableMap(new HashMap<String, ConfigChangeType>(){
        {
            this.put(StandardWatchEventKinds.ENTRY_CREATE.name(), ConfigChangeType.ADDED);
            this.put(StandardWatchEventKinds.ENTRY_DELETE.name(), ConfigChangeType.DELETED);
            this.put(StandardWatchEventKinds.ENTRY_MODIFY.name(), ConfigChangeType.MODIFIED);
        }
    });
    private static final Optional<WatchService> watchService = FileSystemDynamicConfiguration.newWatchService();
    private static final boolean BASED_POOLING_WATCH_SERVICE = FileSystemDynamicConfiguration.detectPoolingBasedWatchService(watchService);
    private static final WatchEvent.Modifier[] MODIFIERS = FileSystemDynamicConfiguration.initWatchEventModifiers();
    private static final Integer DELAY = FileSystemDynamicConfiguration.initDelay(MODIFIERS);
    private static final ThreadPoolExecutor WATCH_EVENTS_LOOP_THREAD_POOL = FileSystemDynamicConfiguration.newWatchEventsLoopThreadPool();
    private final File rootDirectory;
    private final String encoding;
    private final Set<File> processingDirectories;
    private final Map<File, List<ConfigurationListener>> listenersRepository;
    private ScopeModel scopeModel;
    private AtomicBoolean hasRegisteredShutdownHook = new AtomicBoolean();

    public FileSystemDynamicConfiguration() {
        this(new File(DEFAULT_CONFIG_CENTER_DIR_PATH));
    }

    public FileSystemDynamicConfiguration(File rootDirectory) {
        this(rootDirectory, DEFAULT_CONFIG_CENTER_ENCODING);
    }

    public FileSystemDynamicConfiguration(File rootDirectory, String encoding) {
        this(rootDirectory, encoding, "dubbo.config-center.workers");
    }

    public FileSystemDynamicConfiguration(File rootDirectory, String encoding, String threadPoolPrefixName) {
        this(rootDirectory, encoding, threadPoolPrefixName, 1);
    }

    public FileSystemDynamicConfiguration(File rootDirectory, String encoding, String threadPoolPrefixName, int threadPoolSize) {
        this(rootDirectory, encoding, threadPoolPrefixName, threadPoolSize, DEFAULT_THREAD_POOL_KEEP_ALIVE_TIME);
    }

    public FileSystemDynamicConfiguration(File rootDirectory, String encoding, String threadPoolPrefixName, int threadPoolSize, long keepAliveTime) {
        super(rootDirectory.getAbsolutePath(), threadPoolPrefixName, threadPoolSize, keepAliveTime, "dubbo", -1L);
        this.rootDirectory = rootDirectory;
        this.encoding = encoding;
        this.processingDirectories = this.initProcessingDirectories();
        this.listenersRepository = new HashMap<File, List<ConfigurationListener>>();
        this.registerDubboShutdownHook();
    }

    public FileSystemDynamicConfiguration(File rootDirectory, String encoding, String threadPoolPrefixName, int threadPoolSize, long keepAliveTime, ScopeModel scopeModel) {
        super(rootDirectory.getAbsolutePath(), threadPoolPrefixName, threadPoolSize, keepAliveTime, "dubbo", -1L);
        this.rootDirectory = rootDirectory;
        this.encoding = encoding;
        this.processingDirectories = this.initProcessingDirectories();
        this.listenersRepository = new HashMap<File, List<ConfigurationListener>>();
        this.scopeModel = scopeModel;
        this.registerDubboShutdownHook();
    }

    public FileSystemDynamicConfiguration(URL url) {
        this(FileSystemDynamicConfiguration.initDirectory(url), FileSystemDynamicConfiguration.getEncoding(url), FileSystemDynamicConfiguration.getThreadPoolPrefixName(url), FileSystemDynamicConfiguration.getThreadPoolSize(url), FileSystemDynamicConfiguration.getThreadPoolKeepAliveTime(url), url.getScopeModel());
    }

    private Set<File> initProcessingDirectories() {
        return FileSystemDynamicConfiguration.isBasedPoolingWatchService() ? new LinkedHashSet() : Collections.emptySet();
    }

    public File configFile(String key, String group) {
        return new File(this.buildPathKey(group, key));
    }

    private void doInListener(String configFilePath, BiConsumer<File, List<ConfigurationListener>> consumer) {
        FileSystemDynamicConfiguration.watchService.ifPresent(watchService -> {
            File configFile = new File(configFilePath);
            this.executeMutually(configFile.getParentFile(), () -> {
                if (!FileSystemDynamicConfiguration.isProcessingWatchEvents()) {
                    this.processWatchEvents((WatchService)watchService);
                }
                List<ConfigurationListener> listeners = this.getListeners(configFile);
                consumer.accept(configFile, listeners);
                return null;
            });
        });
    }

    private void registerDubboShutdownHook() {
        if (!this.hasRegisteredShutdownHook.compareAndSet(false, true)) {
            return;
        }
        ShutdownHookCallbacks shutdownHookCallbacks = ScopeModelUtil.getApplicationModel(this.scopeModel).getBeanFactory().getBean(ShutdownHookCallbacks.class);
        shutdownHookCallbacks.addCallback(() -> {
            watchService.ifPresent(w -> {
                try {
                    w.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            FileSystemDynamicConfiguration.getWatchEventsLoopThreadPool().shutdown();
        });
    }

    private static boolean isProcessingWatchEvents() {
        return FileSystemDynamicConfiguration.getWatchEventsLoopThreadPool().getActiveCount() > 0;
    }

    private void processWatchEvents(WatchService watchService) {
        FileSystemDynamicConfiguration.getWatchEventsLoopThreadPool().execute(() -> {
            block4: while (true) {
                WatchKey watchKey = null;
                try {
                    watchKey = watchService.take();
                    if (!watchKey.isValid()) continue;
                    Iterator<WatchEvent<?>> iterator = watchKey.pollEvents().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block4;
                        WatchEvent<?> event = iterator.next();
                        WatchEvent.Kind<?> kind = event.kind();
                        ConfigChangeType configChangeType = CONFIG_CHANGE_TYPES_MAP.get(kind.name());
                        if (configChangeType == null) continue;
                        Path configDirectoryPath = (Path)watchKey.watchable();
                        Path currentPath = (Path)event.context();
                        Path configFilePath = configDirectoryPath.resolve(currentPath);
                        File configDirectory = configDirectoryPath.toFile();
                        this.executeMutually(configDirectory, () -> {
                            this.fireConfigChangeEvent(configDirectory, configFilePath.toFile(), configChangeType);
                            this.signalConfigDirectory(configDirectory);
                            return null;
                        });
                    }
                }
                catch (Exception e) {
                    return;
                }
                finally {
                    if (watchKey == null) continue;
                    watchKey.reset();
                    continue;
                }
                break;
            }
        });
    }

    private void signalConfigDirectory(File configDirectory) {
        if (FileSystemDynamicConfiguration.isBasedPoolingWatchService()) {
            this.removeProcessingDirectory(configDirectory);
            this.notifyProcessingDirectory(configDirectory);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("The config rootDirectory[%s] is signalled...", configDirectory.getName()));
            }
        }
    }

    private void removeProcessingDirectory(File configDirectory) {
        this.processingDirectories.remove(configDirectory);
    }

    private void notifyProcessingDirectory(File configDirectory) {
        configDirectory.notifyAll();
    }

    private List<ConfigurationListener> getListeners(File configFile) {
        return this.listenersRepository.computeIfAbsent(configFile, p -> new LinkedList());
    }

    private void fireConfigChangeEvent(File configDirectory, File configFile, ConfigChangeType configChangeType) {
        String key = configFile.getName();
        String value = this.getConfig(configFile);
        this.getListeners(configFile).forEach(listener -> {
            block2: {
                try {
                    listener.process(new ConfigChangedEvent(key, configDirectory.getName(), value, configChangeType));
                }
                catch (Throwable e) {
                    if (!logger.isErrorEnabled()) break block2;
                    logger.error((Object)e.getMessage(), e);
                }
            }
        });
    }

    private boolean canRead(File file) {
        return file.exists() && file.canRead();
    }

    @Override
    public Object getInternalProperty(String key) {
        return null;
    }

    @Override
    protected boolean doPublishConfig(String pathKey, String content) throws Exception {
        return this.delay(pathKey, configFile -> {
            FileUtils.write((File)configFile, (CharSequence)content, (String)this.getEncoding());
            return true;
        });
    }

    @Override
    protected String doGetConfig(String pathKey) throws Exception {
        File configFile = new File(pathKey);
        return this.getConfig(configFile);
    }

    @Override
    protected boolean doRemoveConfig(String pathKey) throws Exception {
        this.delay(pathKey, configFile -> {
            String content = this.getConfig((File)configFile);
            FileUtils.deleteQuietly((File)configFile);
            return content;
        });
        return true;
    }

    @Override
    protected Collection<String> doGetConfigKeys(String groupPath) {
        File[] files = new File(groupPath).listFiles(File::isFile);
        if (files == null) {
            return new TreeSet<String>();
        }
        return Stream.of(files).map(File::getName).collect(Collectors.toList());
    }

    @Override
    protected void doAddListener(String pathKey, ConfigurationListener listener) {
        this.doInListener(pathKey, (configFilePath, listeners) -> {
            if (listeners.isEmpty()) {
                ThrowableConsumer.execute(configFilePath, configFile -> {
                    FileUtils.forceMkdirParent((File)configFile);
                    File configDirectory = configFile.getParentFile();
                    if (configDirectory != null) {
                        configDirectory.toPath().register(watchService.get(), INTEREST_PATH_KINDS, MODIFIERS);
                    }
                });
            }
            listeners.add(listener);
        });
    }

    @Override
    protected void doRemoveListener(String pathKey, ConfigurationListener listener) {
        this.doInListener(pathKey, (file, listeners) -> listeners.remove(listener));
    }

    protected <V> V delay(String configFilePath, ThrowableFunction<File, V> function) {
        V value;
        block3: {
            File configFile = new File(configFilePath);
            if (FileSystemDynamicConfiguration.isBasedPoolingWatchService()) {
                File configDirectory = configFile.getParentFile();
                this.executeMutually(configDirectory, () -> {
                    Integer delay;
                    if (this.hasListeners(configFile) && this.isProcessing(configDirectory) && (delay = this.getDelay()) != null) {
                        long timeout = TimeUnit.SECONDS.toMillis(delay.intValue());
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("The config[path : %s] is about to delay in %d ms.", configFilePath, timeout));
                        }
                        configDirectory.wait(timeout);
                    }
                    this.addProcessing(configDirectory);
                    return null;
                });
            }
            value = null;
            try {
                value = function.apply(configFile);
            }
            catch (Throwable e) {
                if (!logger.isErrorEnabled()) break block3;
                logger.error((Object)e.getMessage(), e);
            }
        }
        return value;
    }

    private boolean hasListeners(File configFile) {
        return this.getListeners(configFile).size() > 0;
    }

    private boolean isProcessing(File configDirectory) {
        return this.processingDirectories.contains(configDirectory);
    }

    private void addProcessing(File configDirectory) {
        this.processingDirectories.add(configDirectory);
    }

    public Set<String> getConfigGroups() {
        return Stream.of(this.getRootDirectory().listFiles()).filter(File::isDirectory).map(File::getName).collect(Collectors.toSet());
    }

    protected String getConfig(File configFile) {
        return ThrowableFunction.execute(configFile, file -> this.canRead(configFile) ? FileUtils.readFileToString((File)configFile, (String)this.getEncoding()) : null);
    }

    @Override
    protected void doClose() throws Exception {
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected Integer getDelay() {
        return DELAY;
    }

    protected static boolean isBasedPoolingWatchService() {
        return BASED_POOLING_WATCH_SERVICE;
    }

    protected static ThreadPoolExecutor getWatchEventsLoopThreadPool() {
        return WATCH_EVENTS_LOOP_THREAD_POOL;
    }

    @Override
    protected ThreadPoolExecutor getWorkersThreadPool() {
        return super.getWorkersThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V executeMutually(Object mutex, Callable<V> callable) {
        V value = null;
        Object object = mutex;
        synchronized (object) {
            block5: {
                try {
                    value = callable.call();
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block5;
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return value;
    }

    private static <T> T[] of(T ... values) {
        return values;
    }

    private static Integer initDelay(WatchEvent.Modifier[] modifiers) {
        if (FileSystemDynamicConfiguration.isBasedPoolingWatchService()) {
            return 2;
        }
        return null;
    }

    private static WatchEvent.Modifier[] initWatchEventModifiers() {
        return FileSystemDynamicConfiguration.of(new WatchEvent.Modifier[0]);
    }

    private static boolean detectPoolingBasedWatchService(Optional<WatchService> watchService) {
        String className = watchService.map(Object::getClass).map(Class::getName).orElse(null);
        return POLLING_WATCH_SERVICE_CLASS_NAME.equals(className);
    }

    private static Optional<WatchService> newWatchService() {
        Optional<WatchService> watchService = null;
        FileSystem fileSystem = FileSystems.getDefault();
        try {
            watchService = Optional.of(fileSystem.newWatchService());
        }
        catch (IOException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            watchService = Optional.empty();
        }
        return watchService;
    }

    protected static File initDirectory(URL url) {
        String directoryPath = FileSystemDynamicConfiguration.getParameter(url, CONFIG_CENTER_DIR_PARAM_NAME, url == null ? null : url.getPath());
        File rootDirectory = null;
        if (!StringUtils.isBlank(directoryPath)) {
            rootDirectory = new File("/" + directoryPath);
        }
        if (directoryPath == null || !rootDirectory.exists()) {
            rootDirectory = new File(DEFAULT_CONFIG_CENTER_DIR_PATH);
        }
        if (!rootDirectory.exists() && !rootDirectory.mkdirs()) {
            throw new IllegalStateException(String.format("Dubbo config center rootDirectory[%s] can't be created!", rootDirectory.getAbsolutePath()));
        }
        return rootDirectory;
    }

    protected static String getEncoding(URL url) {
        return FileSystemDynamicConfiguration.getParameter(url, CONFIG_CENTER_ENCODING_PARAM_NAME, DEFAULT_CONFIG_CENTER_ENCODING);
    }

    private static ThreadPoolExecutor newWatchEventsLoopThreadPool() {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory("dubbo-config-center-watch-events-loop", true));
    }
}

