/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.deploy;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.deploy.DeployListener;
import org.apache.dubbo.common.deploy.DeployState;
import org.apache.dubbo.common.deploy.Deployer;
import org.apache.dubbo.rpc.model.ScopeModel;

public abstract class AbstractDeployer<E extends ScopeModel>
implements Deployer<E> {
    private volatile DeployState state = DeployState.PENDING;
    protected AtomicBoolean initialized = new AtomicBoolean(false);
    private List<DeployListener<E>> listeners = new ArrayList<DeployListener<E>>();
    private E scopeModel;

    public AbstractDeployer(E scopeModel) {
        this.scopeModel = scopeModel;
    }

    @Override
    public boolean isPending() {
        return this.state == DeployState.PENDING;
    }

    @Override
    public boolean isRunning() {
        return this.state == DeployState.STARTING || this.state == DeployState.STARTED;
    }

    @Override
    public boolean isStarted() {
        return this.state == DeployState.STARTED;
    }

    @Override
    public boolean isStarting() {
        return this.state == DeployState.STARTING;
    }

    @Override
    public boolean isStopping() {
        return this.state == DeployState.STOPPING;
    }

    @Override
    public boolean isStopped() {
        return this.state == DeployState.STOPPED;
    }

    @Override
    public boolean isFailed() {
        return this.state == DeployState.FAILED;
    }

    @Override
    public DeployState getState() {
        return this.state;
    }

    @Override
    public void addDeployListener(DeployListener<E> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDeployListener(DeployListener<E> listener) {
        this.listeners.remove(listener);
    }

    protected void setStarting() {
        this.state = DeployState.STARTING;
        for (DeployListener<E> listener : this.listeners) {
            listener.onStarting(this.scopeModel);
        }
    }

    protected void setStarted() {
        this.state = DeployState.STARTED;
        for (DeployListener<E> listener : this.listeners) {
            listener.onStarted(this.scopeModel);
        }
    }

    protected void setStopping() {
        this.state = DeployState.STOPPING;
        for (DeployListener<E> listener : this.listeners) {
            listener.onStopping(this.scopeModel);
        }
    }

    protected void setStopped() {
        this.state = DeployState.STOPPED;
        for (DeployListener<E> listener : this.listeners) {
            listener.onStopped(this.scopeModel);
        }
    }

    protected void setFailed(Throwable cause) {
        this.state = DeployState.FAILED;
        for (DeployListener<E> listener : this.listeners) {
            listener.onFailure(this.scopeModel, cause);
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }
}

