/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.hessian2.dubbo;

import com.alibaba.com.caucho.hessian.io.SerializerFactory;
import org.apache.dubbo.common.serialize.hessian2.Hessian2SerializerFactory;
import org.apache.dubbo.common.serialize.hessian2.dubbo.AbstractHessian2FactoryInitializer;
import org.apache.dubbo.common.utils.StringUtils;

public class WhitelistHessian2FactoryInitializer
extends AbstractHessian2FactoryInitializer {
    @Override
    public SerializerFactory createSerializerFactory() {
        Hessian2SerializerFactory serializerFactory = new Hessian2SerializerFactory();
        String whiteList = System.getProperty("dubbo.application.hessian2.whitelist");
        if ("true".equals(whiteList)) {
            serializerFactory.getClassFactory().setWhitelist(true);
            String allowPattern = System.getProperty("dubbo.application.hessian2.allow");
            if (StringUtils.isNotEmpty(allowPattern)) {
                for (String pattern : allowPattern.split(";")) {
                    serializerFactory.getClassFactory().allow(pattern);
                }
            }
        } else {
            serializerFactory.getClassFactory().setWhitelist(false);
            String denyPattern = System.getProperty("dubbo.application.hessian2.deny");
            if (StringUtils.isNotEmpty(denyPattern)) {
                for (String pattern : denyPattern.split(";")) {
                    serializerFactory.getClassFactory().deny(pattern);
                }
            }
        }
        serializerFactory.getClassFactory().allow(RuntimeException.class.getName());
        serializerFactory.getClassFactory().allow("org.apache.dubbo.*");
        return serializerFactory;
    }
}

