/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.deploy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.config.ReferenceCache;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.config.configcenter.DynamicConfigurationFactory;
import org.apache.dubbo.common.config.configcenter.wrapper.CompositeDynamicConfiguration;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.deploy.AbstractDeployer;
import org.apache.dubbo.common.deploy.ApplicationDeployListener;
import org.apache.dubbo.common.deploy.ApplicationDeployer;
import org.apache.dubbo.common.deploy.ModuleDeployer;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.lang.ShutdownHookCallbacks;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.DubboShutdownHook;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.utils.CompositeReferenceCache;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.MetadataServiceExporter;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.metadata.report.MetadataReportFactory;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReportFactory;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.store.InMemoryWritableMetadataService;
import org.apache.dubbo.registry.client.metadata.store.RemoteMetadataServiceImpl;
import org.apache.dubbo.registry.support.RegistryManager;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class DefaultApplicationDeployer
extends AbstractDeployer<ApplicationModel>
implements ApplicationDeployer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultApplicationDeployer.class);
    private final ApplicationModel applicationModel;
    private final ConfigManager configManager;
    private final Environment environment;
    private final ReferenceCache referenceCache;
    private final ExecutorRepository executorRepository;
    private volatile ServiceInstance serviceInstance;
    private AtomicBoolean hasPreparedApplicationInstance = new AtomicBoolean(false);
    private volatile MetadataService metadataService;
    private volatile MetadataServiceExporter metadataServiceExporter;
    private ScheduledFuture<?> asyncMetadataFuture;
    private String identifier;
    private CompletableFuture startFuture;
    private DubboShutdownHook dubboShutdownHook;

    public DefaultApplicationDeployer(ApplicationModel applicationModel) {
        super(applicationModel);
        this.applicationModel = applicationModel;
        this.configManager = applicationModel.getApplicationConfigManager();
        this.environment = applicationModel.getModelEnvironment();
        this.referenceCache = new CompositeReferenceCache(applicationModel);
        this.executorRepository = this.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
        this.dubboShutdownHook = new DubboShutdownHook(applicationModel);
        Set<ApplicationDeployListener> deployListeners = applicationModel.getExtensionLoader(ApplicationDeployListener.class).getSupportedExtensionInstances();
        for (ApplicationDeployListener listener : deployListeners) {
            this.addDeployListener(listener);
        }
    }

    public static ApplicationDeployer get(ScopeModel moduleOrApplicationModel) {
        ApplicationModel applicationModel = ScopeModelUtil.getApplicationModel(moduleOrApplicationModel);
        ApplicationDeployer applicationDeployer = applicationModel.getDeployer();
        if (applicationDeployer == null) {
            applicationDeployer = applicationModel.getBeanFactory().getOrRegisterBean(DefaultApplicationDeployer.class);
        }
        return applicationDeployer;
    }

    @Override
    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    private <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        return this.applicationModel.getExtensionLoader(type);
    }

    private void unRegisterShutdownHook() {
        this.dubboShutdownHook.unregister();
    }

    private boolean isRegisterConsumerInstance() {
        Boolean registerConsumer = this.getApplication().getRegisterConsumer();
        return Boolean.TRUE.equals(registerConsumer);
    }

    private String getMetadataType() {
        String type = this.getApplication().getMetadataType();
        if (StringUtils.isEmpty(type)) {
            type = "local";
        }
        return type;
    }

    @Override
    public ReferenceCache getReferenceCache() {
        return this.referenceCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        if (this.initialized.get()) {
            return;
        }
        DefaultApplicationDeployer defaultApplicationDeployer = this;
        synchronized (defaultApplicationDeployer) {
            if (this.initialized.get()) {
                return;
            }
            this.registerShutdownHook();
            this.startConfigCenter();
            this.loadApplicationConfigs();
            this.initModuleDeployers();
            this.startMetadataCenter();
            this.initMetadataService();
            this.initialized.set(true);
            if (logger.isInfoEnabled()) {
                logger.info(this.getIdentifier() + " has been initialized!");
            }
        }
    }

    private void registerShutdownHook() {
        this.dubboShutdownHook.register();
    }

    private void initModuleDeployers() {
        this.applicationModel.getDefaultModule();
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            moduleModel.getDeployer().initialize();
        }
    }

    private void loadApplicationConfigs() {
        this.configManager.loadConfigs();
    }

    private void startConfigCenter() {
        this.configManager.loadConfigsOfTypeFromProps(ApplicationConfig.class);
        this.configManager.loadConfigsOfTypeFromProps(ConfigCenterConfig.class);
        this.useRegistryAsConfigCenterIfNecessary();
        Collection<ConfigCenterConfig> configCenters = this.configManager.getConfigCenters();
        if (CollectionUtils.isEmpty(configCenters)) {
            ConfigCenterConfig configCenterConfig = new ConfigCenterConfig();
            configCenterConfig.setScopeModel(this.applicationModel);
            configCenterConfig.refresh();
            ConfigValidationUtils.validateConfigCenterConfig(configCenterConfig);
            if (configCenterConfig.isValid()) {
                this.configManager.addConfigCenter(configCenterConfig);
                configCenters = this.configManager.getConfigCenters();
            }
        } else {
            for (ConfigCenterConfig configCenterConfig : configCenters) {
                configCenterConfig.refresh();
                ConfigValidationUtils.validateConfigCenterConfig(configCenterConfig);
            }
        }
        if (CollectionUtils.isNotEmpty(configCenters)) {
            CompositeDynamicConfiguration compositeDynamicConfiguration = new CompositeDynamicConfiguration();
            for (ConfigCenterConfig configCenter : configCenters) {
                this.environment.updateExternalConfigMap(configCenter.getExternalConfiguration());
                this.environment.updateAppExternalConfigMap(configCenter.getAppExternalConfiguration());
                compositeDynamicConfiguration.addConfiguration(this.prepareEnvironment(configCenter));
            }
            this.environment.setDynamicConfiguration(compositeDynamicConfiguration);
        }
        this.configManager.refreshAll();
    }

    private void startMetadataCenter() {
        this.useRegistryAsMetadataCenterIfNecessary();
        ApplicationConfig applicationConfig = this.getApplication();
        String metadataType = applicationConfig.getMetadataType();
        Collection<MetadataReportConfig> metadataReportConfigs = this.configManager.getMetadataConfigs();
        if (CollectionUtils.isEmpty(metadataReportConfigs)) {
            if ("remote".equals(metadataType)) {
                throw new IllegalStateException("No MetadataConfig found, Metadata Center address is required when 'metadata=remote' is enabled.");
            }
            return;
        }
        MetadataReportInstance metadataReportInstance = this.applicationModel.getBeanFactory().getBean(MetadataReportInstance.class);
        for (MetadataReportConfig metadataReportConfig : metadataReportConfigs) {
            ConfigValidationUtils.validateMetadataConfig(metadataReportConfig);
            if (!metadataReportConfig.isValid()) {
                logger.info("Ignore invalid metadata-report config: " + metadataReportConfig);
                continue;
            }
            metadataReportInstance.init(metadataReportConfig);
        }
    }

    private void useRegistryAsConfigCenterIfNecessary() {
        if (this.environment.getDynamicConfiguration().isPresent()) {
            return;
        }
        if (CollectionUtils.isNotEmpty(this.configManager.getConfigCenters())) {
            return;
        }
        this.configManager.loadConfigsOfTypeFromProps(RegistryConfig.class);
        List<RegistryConfig> defaultRegistries = this.configManager.getDefaultRegistries();
        if (defaultRegistries.size() > 0) {
            defaultRegistries.stream().filter(this::isUsedRegistryAsConfigCenter).map(this::registryAsConfigCenter).forEach(configCenter -> {
                if (this.configManager.getConfigCenter(configCenter.getId()).isPresent()) {
                    return;
                }
                this.configManager.addConfigCenter((ConfigCenterConfig)configCenter);
                logger.info("use registry as config-center: " + configCenter);
            });
        }
    }

    private boolean isUsedRegistryAsConfigCenter(RegistryConfig registryConfig) {
        return this.isUsedRegistryAsCenter(registryConfig, registryConfig::getUseAsConfigCenter, "config", DynamicConfigurationFactory.class);
    }

    private ConfigCenterConfig registryAsConfigCenter(RegistryConfig registryConfig) {
        String protocol = registryConfig.getProtocol();
        Integer port = registryConfig.getPort();
        URL url = URL.valueOf(registryConfig.getAddress(), registryConfig.getScopeModel());
        String id = "config-center-" + protocol + "-" + url.getHost() + "-" + port;
        ConfigCenterConfig cc = new ConfigCenterConfig();
        cc.setId(id);
        cc.setScopeModel(this.applicationModel);
        if (cc.getParameters() == null) {
            cc.setParameters(new HashMap<String, String>());
        }
        if (registryConfig.getParameters() != null) {
            cc.getParameters().putAll(registryConfig.getParameters());
        }
        cc.getParameters().put("client", registryConfig.getClient());
        cc.setProtocol(protocol);
        cc.setPort(port);
        if (StringUtils.isNotEmpty(registryConfig.getGroup())) {
            cc.setGroup(registryConfig.getGroup());
        }
        cc.setAddress(this.getRegistryCompatibleAddress(registryConfig));
        cc.setNamespace(registryConfig.getGroup());
        cc.setUsername(registryConfig.getUsername());
        cc.setPassword(registryConfig.getPassword());
        if (registryConfig.getTimeout() != null) {
            cc.setTimeout(registryConfig.getTimeout().longValue());
        }
        cc.setHighestPriority(false);
        return cc;
    }

    private void useRegistryAsMetadataCenterIfNecessary() {
        Collection<MetadataReportConfig> metadataConfigs = this.configManager.getMetadataConfigs();
        if (CollectionUtils.isNotEmpty(metadataConfigs)) {
            return;
        }
        List<RegistryConfig> defaultRegistries = this.configManager.getDefaultRegistries();
        if (defaultRegistries.size() > 0) {
            defaultRegistries.stream().filter(this::isUsedRegistryAsMetadataCenter).map(this::registryAsMetadataCenter).forEach(metadataReportConfig -> {
                Optional<MetadataReportConfig> configOptional = this.configManager.getConfig(MetadataReportConfig.class, metadataReportConfig.getId());
                if (configOptional.isPresent()) {
                    return;
                }
                this.configManager.addMetadataReport((MetadataReportConfig)metadataReportConfig);
                logger.info("use registry as metadata-center: " + metadataReportConfig);
            });
        }
    }

    private boolean isUsedRegistryAsMetadataCenter(RegistryConfig registryConfig) {
        return this.isUsedRegistryAsCenter(registryConfig, registryConfig::getUseAsMetadataCenter, "metadata", MetadataReportFactory.class);
    }

    private boolean isUsedRegistryAsCenter(RegistryConfig registryConfig, Supplier<Boolean> usedRegistryAsCenter, String centerType, Class<?> extensionClass) {
        boolean supported;
        Boolean configuredValue = usedRegistryAsCenter.get();
        if (configuredValue != null) {
            supported = configuredValue;
        } else {
            String protocol = registryConfig.getProtocol();
            supported = this.supportsExtension(extensionClass, protocol);
            if (logger.isInfoEnabled()) {
                logger.info(String.format("No value is configured in the registry, the %s extension[name : %s] %s as the %s center", extensionClass.getSimpleName(), protocol, supported ? "supports" : "does not support", centerType));
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("The registry[%s] will be %s as the %s center", registryConfig, supported ? "used" : "not used", centerType));
        }
        return supported;
    }

    private boolean supportsExtension(Class<?> extensionClass, String name) {
        if (StringUtils.isNotEmpty(name)) {
            ExtensionLoader<?> extensionLoader = this.getExtensionLoader(extensionClass);
            return extensionLoader.hasExtension(name);
        }
        return false;
    }

    private MetadataReportConfig registryAsMetadataCenter(RegistryConfig registryConfig) {
        String protocol = registryConfig.getProtocol();
        URL url = URL.valueOf(registryConfig.getAddress(), registryConfig.getScopeModel());
        String id = "metadata-center-" + protocol + "-" + url.getHost() + "-" + url.getPort();
        MetadataReportConfig metadataReportConfig = new MetadataReportConfig();
        metadataReportConfig.setId(id);
        metadataReportConfig.setScopeModel(this.applicationModel);
        if (metadataReportConfig.getParameters() == null) {
            metadataReportConfig.setParameters(new HashMap<String, String>());
        }
        if (registryConfig.getParameters() != null) {
            metadataReportConfig.getParameters().putAll(registryConfig.getParameters());
        }
        metadataReportConfig.getParameters().put("client", registryConfig.getClient());
        metadataReportConfig.setGroup(registryConfig.getGroup());
        metadataReportConfig.setAddress(this.getRegistryCompatibleAddress(registryConfig));
        metadataReportConfig.setUsername(registryConfig.getUsername());
        metadataReportConfig.setPassword(registryConfig.getPassword());
        metadataReportConfig.setTimeout(registryConfig.getTimeout());
        return metadataReportConfig;
    }

    private String getRegistryCompatibleAddress(RegistryConfig registryConfig) {
        String registryAddress = registryConfig.getAddress();
        Object[] addresses = CommonConstants.REGISTRY_SPLIT_PATTERN.split(registryAddress);
        if (ArrayUtils.isEmpty(addresses)) {
            throw new IllegalStateException("Invalid registry address found.");
        }
        Object address = addresses[0];
        StringBuilder metadataAddressBuilder = new StringBuilder();
        URL url = URL.valueOf((String)address, registryConfig.getScopeModel());
        String protocolFromAddress = url.getProtocol();
        if (StringUtils.isEmpty(protocolFromAddress)) {
            String protocolFromConfig = registryConfig.getProtocol();
            metadataAddressBuilder.append(protocolFromConfig).append("://");
        }
        metadataAddressBuilder.append((String)address);
        return metadataAddressBuilder.toString();
    }

    private void initMetadataService() {
        this.metadataService = this.getExtensionLoader(WritableMetadataService.class).getDefaultExtension();
        this.applicationModel.getBeanFactory().registerBean(this.metadataService);
        this.metadataServiceExporter = this.getExtensionLoader(MetadataServiceExporter.class).getDefaultExtension();
    }

    @Override
    public synchronized CompletableFuture start() {
        if (this.isStarting()) {
            return this.startFuture;
        }
        this.startFuture = new CompletableFuture();
        if (this.isStarted()) {
            boolean hasNewModule = false;
            for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
                if (!moduleModel.getDeployer().isPending()) continue;
                hasNewModule = true;
                break;
            }
            if (!hasNewModule) {
                this.startFuture.complete(false);
                return this.startFuture;
            }
        }
        this.onStarting();
        this.initialize();
        this.doStart();
        return this.startFuture;
    }

    private void doStart() {
        ArrayList<ModuleModel> moduleModels = new ArrayList<ModuleModel>(this.applicationModel.getModuleModels());
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(moduleModels.size());
        for (ModuleModel moduleModel : moduleModels) {
            if (!moduleModel.getDeployer().isPending()) continue;
            CompletableFuture moduleFuture = moduleModel.getDeployer().start();
            futures.add(moduleFuture);
        }
        this.prepareApplicationInstance();
    }

    private void awaitDeployFinished(List<CompletableFuture> futures) {
        try {
            CompletableFuture<Void> mergedFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            mergedFuture.get();
        }
        catch (Exception e) {
            logger.error(this.getIdentifier() + " await deploy finished failed", e);
        }
    }

    @Override
    public void prepareApplicationInstance() {
        if (this.hasPreparedApplicationInstance.get()) {
            return;
        }
        if (this.isRegisterConsumerInstance() || this.hasExportedServices()) {
            if (!this.hasPreparedApplicationInstance.compareAndSet(false, true)) {
                return;
            }
            this.prepareInternalModule();
            this.registerServiceInstance();
        }
    }

    private void prepareInternalModule() {
        this.exportMetadataService();
        ModuleDeployer internalModuleDeployer = this.applicationModel.getInternalModule().getDeployer();
        if (!internalModuleDeployer.isRunning()) {
            internalModuleDeployer.start();
        }
    }

    private boolean hasExportedServices() {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            if (!CollectionUtils.isNotEmpty(moduleModel.getConfigManager().getServices())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAsync() {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            if (!moduleModel.getDeployer().isAsync()) continue;
            return true;
        }
        return false;
    }

    private DynamicConfiguration prepareEnvironment(ConfigCenterConfig configCenter) {
        if (configCenter.isValid()) {
            if (!configCenter.checkOrUpdateInitialized(true)) {
                return null;
            }
            DynamicConfiguration dynamicConfiguration = null;
            try {
                dynamicConfiguration = this.getDynamicConfiguration(configCenter.toUrl());
            }
            catch (Exception e) {
                if (!configCenter.isCheck().booleanValue()) {
                    logger.warn("The configuration center failed to initialize", e);
                    configCenter.checkOrUpdateInitialized(false);
                    return null;
                }
                throw new IllegalStateException(e);
            }
            String configContent = dynamicConfiguration.getProperties(configCenter.getConfigFile(), configCenter.getGroup());
            String appGroup = this.getApplication().getName();
            String appConfigContent = null;
            if (StringUtils.isNotEmpty(appGroup)) {
                appConfigContent = dynamicConfiguration.getProperties(StringUtils.isNotEmpty(configCenter.getAppConfigFile()) ? configCenter.getAppConfigFile() : configCenter.getConfigFile(), appGroup);
            }
            try {
                this.environment.updateExternalConfigMap(ConfigurationUtils.parseProperties(configContent));
                this.environment.updateAppExternalConfigMap(ConfigurationUtils.parseProperties(appConfigContent));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to parse configurations from Config Center.", e);
            }
            return dynamicConfiguration;
        }
        return null;
    }

    private DynamicConfiguration getDynamicConfiguration(URL connectionURL) {
        String protocol = connectionURL.getProtocol();
        DynamicConfigurationFactory factory = ConfigurationUtils.getDynamicConfigurationFactory(this.applicationModel, protocol);
        return factory.getDynamicConfiguration(connectionURL);
    }

    private void exportMetadataService() {
        this.metadataServiceExporter.export();
    }

    private void unexportMetadataService() {
        if (this.metadataServiceExporter != null && this.metadataServiceExporter.isExported()) {
            try {
                this.metadataServiceExporter.unexport();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void registerServiceInstance() {
        if (this.isRegisteredServiceInstance()) {
            return;
        }
        ApplicationConfig application = this.getApplication();
        String serviceName = application.getName();
        ServiceInstance serviceInstance = this.createServiceInstance(serviceName);
        boolean registered = true;
        try {
            ServiceInstanceMetadataUtils.registerMetadataAndInstance(serviceInstance);
        }
        catch (Exception e) {
            registered = false;
            logger.error("Register instance error", e);
        }
        if (registered) {
            this.asyncMetadataFuture = this.executorRepository.nextScheduledExecutor().scheduleAtFixedRate(() -> {
                InMemoryWritableMetadataService localMetadataService = (InMemoryWritableMetadataService)WritableMetadataService.getDefaultExtension(this.applicationModel);
                localMetadataService.blockUntilUpdated();
                try {
                    ServiceInstanceMetadataUtils.refreshMetadataAndInstance(serviceInstance);
                }
                catch (Exception e) {
                    logger.error("Refresh instance and metadata error", e);
                }
                finally {
                    localMetadataService.releaseBlock();
                }
            }, 0L, ConfigurationUtils.get(this.applicationModel, "dubbo.application.metadata.publish.delay", 10000), TimeUnit.MILLISECONDS);
        }
    }

    private boolean isRegisteredServiceInstance() {
        return this.serviceInstance != null;
    }

    private void doRegisterServiceInstance(ServiceInstance serviceInstance) {
        if (serviceInstance.getPort() > 0) {
            this.publishMetadataToRemote(serviceInstance);
            logger.info("Start registering instance address to registry.");
            RegistryManager.getInstance(this.applicationModel).getServiceDiscoveries().forEach(serviceDiscovery -> {
                DefaultServiceInstance serviceInstanceForRegistry = new DefaultServiceInstance((DefaultServiceInstance)serviceInstance);
                ServiceInstanceMetadataUtils.calInstanceRevision(serviceDiscovery, serviceInstanceForRegistry);
                if (logger.isDebugEnabled()) {
                    logger.info("Start registering instance address to registry" + serviceDiscovery.getUrl() + ", instance " + serviceInstanceForRegistry);
                }
                serviceDiscovery.register(serviceInstanceForRegistry);
            });
        }
    }

    private void publishMetadataToRemote(ServiceInstance serviceInstance) {
        if (logger.isInfoEnabled()) {
            logger.info("Start publishing metadata to remote center, this only makes sense for applications enabled remote metadata center.");
        }
        RemoteMetadataServiceImpl remoteMetadataService = this.applicationModel.getBeanFactory().getBean(RemoteMetadataServiceImpl.class);
        remoteMetadataService.publishMetadata(serviceInstance.getServiceName());
    }

    private void unregisterServiceInstance() {
        if (this.isRegisteredServiceInstance()) {
            RegistryManager.getInstance(this.applicationModel).getServiceDiscoveries().forEach(serviceDiscovery -> {
                try {
                    serviceDiscovery.unregister(this.serviceInstance);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    private ServiceInstance createServiceInstance(String serviceName) {
        this.serviceInstance = new DefaultServiceInstance(serviceName, this.applicationModel);
        ServiceInstanceMetadataUtils.setMetadataStorageType(this.serviceInstance, this.getMetadataType());
        ServiceInstanceMetadataUtils.customizeInstance(this.serviceInstance);
        return this.serviceInstance;
    }

    public ServiceInstance getServiceInstance() {
        return this.serviceInstance;
    }

    @Override
    public void stop() {
        this.destroy();
    }

    @Override
    public synchronized void destroy() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        try {
            this.onStopping();
            this.unRegisterShutdownHook();
            this.unregisterServiceInstance();
            this.unexportMetadataService();
            if (this.asyncMetadataFuture != null) {
                this.asyncMetadataFuture.cancel(true);
            }
            this.executeShutdownCallbacks();
            this.applicationModel.destroy();
            this.destroyProtocols();
            this.destroyRegistries();
            this.destroyServiceDiscoveries();
            this.destroyMetadataReports();
            this.destroyServiceDiscoveries();
            this.destroyExecutorRepository();
            this.destroyDynamicConfigurations();
            this.onStopped();
        }
        catch (Throwable ex) {
            logger.error(this.getIdentifier() + " an error occurred while stopping application: " + ex.getMessage(), ex);
            this.setFailed(ex);
        }
    }

    private void executeShutdownCallbacks() {
        ShutdownHookCallbacks shutdownHookCallbacks = this.applicationModel.getBeanFactory().getBean(ShutdownHookCallbacks.class);
        shutdownHookCallbacks.callback();
    }

    @Override
    public void checkStarting() {
        if (this.isStarting()) {
            return;
        }
        this.onStarting();
    }

    @Override
    public void checkStarted() {
        for (ModuleModel moduleModel : this.applicationModel.getModuleModels()) {
            if (moduleModel.getDeployer().isStarted()) continue;
            return;
        }
        this.onStarted();
    }

    private void onStarting() {
        this.setStarting();
        if (logger.isInfoEnabled()) {
            logger.info(this.getIdentifier() + " is starting.");
        }
    }

    private void onStarted() {
        this.setStarted();
        if (logger.isInfoEnabled()) {
            logger.info(this.getIdentifier() + " is ready.");
        }
        if (this.startFuture != null) {
            this.startFuture.complete(true);
        }
    }

    private void onStopping() {
        this.setStopping();
        if (logger.isInfoEnabled()) {
            logger.info(this.getIdentifier() + " is stopping.");
        }
    }

    private void onStopped() {
        this.setStopped();
        if (logger.isInfoEnabled()) {
            logger.info(this.getIdentifier() + " has stopped.");
        }
    }

    private void destroyExecutorRepository() {
        this.getExtensionLoader(ExecutorRepository.class).getDefaultExtension().destroyAll();
    }

    private void destroyRegistries() {
        RegistryManager.getInstance(this.applicationModel).destroyAll();
    }

    private void destroyProtocols() {
        FrameworkModel frameworkModel = this.applicationModel.getFrameworkModel();
        if (frameworkModel.getApplicationModels().isEmpty()) {
            ExtensionLoader<Protocol> loader = frameworkModel.getExtensionLoader(Protocol.class);
            for (String protocolName : loader.getLoadedExtensions()) {
                try {
                    Protocol protocol = loader.getLoadedExtension(protocolName);
                    if (protocol == null) continue;
                    protocol.destroy();
                }
                catch (Throwable t) {
                    logger.warn(t.getMessage(), t);
                }
            }
        }
    }

    private void destroyServiceDiscoveries() {
        RegistryManager.getInstance(this.applicationModel).getServiceDiscoveries().forEach(serviceDiscovery -> {
            try {
                serviceDiscovery.destroy();
            }
            catch (Throwable ignored) {
                logger.warn(ignored.getMessage(), ignored);
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug(this.getIdentifier() + "'s all ServiceDiscoveries have been destroyed.");
        }
    }

    private void destroyMetadataReports() {
        AbstractMetadataReportFactory.destroy();
    }

    private void destroyDynamicConfigurations() {
    }

    private ApplicationConfig getApplication() {
        return this.configManager.getApplicationOrElseThrow();
    }

    private String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.applicationModel.getModelName() != null && !StringUtils.isEquals(this.applicationModel.getModelName(), this.applicationModel.getInternalName()) ? this.applicationModel.getModelName() + "[" + this.applicationModel.getInternalId() + "]" : "Dubbo Application[" + this.applicationModel.getInternalId() + "]";
        }
        return this.identifier;
    }
}

