/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.deploy;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.dubbo.common.config.ReferenceCache;
import org.apache.dubbo.common.deploy.AbstractDeployer;
import org.apache.dubbo.common.deploy.ApplicationDeployer;
import org.apache.dubbo.common.deploy.ModuleDeployListener;
import org.apache.dubbo.common.deploy.ModuleDeployer;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.config.context.ModuleConfigManager;
import org.apache.dubbo.config.deploy.DefaultApplicationDeployer;
import org.apache.dubbo.config.utils.SimpleReferenceCache;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ModuleServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;

public class DefaultModuleDeployer
extends AbstractDeployer<ModuleModel>
implements ModuleDeployer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultModuleDeployer.class);
    private final List<CompletableFuture<?>> asyncExportingFutures = new ArrayList();
    private final List<CompletableFuture<?>> asyncReferringFutures = new ArrayList();
    private List<ServiceConfigBase<?>> exportedServices = new ArrayList();
    private ModuleModel moduleModel;
    private ExecutorRepository executorRepository;
    private final ModuleConfigManager configManager;
    private final SimpleReferenceCache referenceCache;
    private String identifier;
    private ApplicationDeployer applicationDeployer;
    private CompletableFuture startFuture;
    private Boolean async;

    public DefaultModuleDeployer(ModuleModel moduleModel) {
        super(moduleModel);
        this.moduleModel = moduleModel;
        this.configManager = moduleModel.getConfigManager();
        this.executorRepository = moduleModel.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
        this.referenceCache = SimpleReferenceCache.newCache();
        this.applicationDeployer = DefaultApplicationDeployer.get(moduleModel);
        Set<ModuleDeployListener> listeners = moduleModel.getExtensionLoader(ModuleDeployListener.class).getSupportedExtensionInstances();
        for (ModuleDeployListener listener : listeners) {
            this.addDeployListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws IllegalStateException {
        if (this.initialized.get()) {
            return;
        }
        DefaultModuleDeployer defaultModuleDeployer = this;
        synchronized (defaultModuleDeployer) {
            if (this.initialized.get()) {
                return;
            }
            this.loadConfigs();
            this.initialized.set(true);
            if (logger.isInfoEnabled()) {
                logger.info(this.getIdentifier() + " has been initialized!");
            }
        }
    }

    @Override
    public synchronized CompletableFuture start() throws IllegalStateException {
        if (this.isStarting() || this.isStarted()) {
            return this.startFuture;
        }
        this.onModuleStarting();
        this.startFuture = new CompletableFuture();
        this.applicationDeployer.initialize();
        this.initialize();
        this.exportServices();
        if (this.hasExportedServices()) {
            this.applicationDeployer.prepareApplicationInstance();
        }
        this.referServices();
        this.executorRepository.getSharedExecutor().submit(() -> {
            this.waitExportFinish();
            this.waitReferFinish();
            this.onModuleStarted(this.startFuture);
        });
        return this.startFuture;
    }

    private boolean hasExportedServices() {
        return this.configManager.getServices().size() > 0;
    }

    @Override
    public void stop() throws IllegalStateException {
        this.destroy();
    }

    @Override
    public synchronized void destroy() throws IllegalStateException {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        this.onModuleStopping();
        this.unexportServices();
        this.unreferServices();
        ModuleServiceRepository serviceRepository = this.moduleModel.getServiceRepository();
        if (serviceRepository != null) {
            List<ConsumerModel> consumerModels = serviceRepository.getReferredServices();
            for (ConsumerModel consumerModel : consumerModels) {
                try {
                    if (consumerModel.getReferenceConfig() != null) {
                        consumerModel.getReferenceConfig().destroy();
                        continue;
                    }
                    if (consumerModel.getDestroyCaller() == null) continue;
                    consumerModel.getDestroyCaller().call();
                }
                catch (Throwable t) {
                    logger.error("Unable to destroy consumerModel.", t);
                }
            }
            List<ProviderModel> exportedServices = serviceRepository.getExportedServices();
            for (ProviderModel providerModel : exportedServices) {
                try {
                    if (providerModel.getServiceConfig() != null) {
                        providerModel.getServiceConfig().unexport();
                        continue;
                    }
                    if (providerModel.getDestroyCaller() == null) continue;
                    providerModel.getDestroyCaller().call();
                }
                catch (Throwable t) {
                    logger.error("Unable to destroy providerModel.", t);
                }
            }
            serviceRepository.destroy();
        }
        this.moduleModel.destroy();
        this.onModuleStopped();
    }

    private void onModuleStarting() {
        this.setStarting();
        logger.info(this.getIdentifier() + " is starting.");
        this.applicationDeployer.checkStarting();
    }

    private void onModuleStarted(CompletableFuture startFuture) {
        this.setStarted();
        logger.info(this.getIdentifier() + " has started.");
        startFuture.complete(true);
        this.applicationDeployer.checkStarted();
    }

    private void onModuleStopping() {
        this.setStopping();
        logger.info(this.getIdentifier() + " is stopping.");
    }

    private void onModuleStopped() {
        this.setStopped();
        logger.info(this.getIdentifier() + " has stopped.");
    }

    private void loadConfigs() {
        this.moduleModel.getConfigManager().loadConfigs();
        this.moduleModel.getConfigManager().refreshAll();
    }

    private void exportServices() {
        for (ServiceConfigBase sc : this.configManager.getServices()) {
            this.exportServiceInternal(sc);
        }
    }

    private void exportServiceInternal(ServiceConfigBase sc) {
        ServiceConfig serviceConfig = (ServiceConfig)sc;
        if (!serviceConfig.isRefreshed()) {
            serviceConfig.refresh();
        }
        if (sc.isExported()) {
            return;
        }
        if (sc.shouldExportAsync().booleanValue()) {
            ExecutorService executor = this.executorRepository.getServiceExportExecutor();
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                try {
                    if (!sc.isExported()) {
                        sc.exportOnly();
                        this.exportedServices.add(sc);
                    }
                }
                catch (Throwable t) {
                    logger.error(this.getIdentifier() + " export async catch error : " + t.getMessage(), t);
                }
            }, executor);
            this.asyncExportingFutures.add(future);
        } else if (!sc.isExported()) {
            sc.exportOnly();
            this.exportedServices.add(sc);
        }
    }

    private void unexportServices() {
        this.exportedServices.forEach(sc -> {
            try {
                this.configManager.removeConfig((AbstractConfig)sc);
                sc.unexport();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.exportedServices.clear();
        this.asyncExportingFutures.forEach(future -> {
            if (!future.isDone()) {
                future.cancel(true);
            }
        });
        this.asyncExportingFutures.clear();
    }

    private void referServices() {
        this.configManager.getReferences().forEach(rc -> {
            try {
                ReferenceConfig referenceConfig = (ReferenceConfig)rc;
                if (!referenceConfig.isRefreshed()) {
                    referenceConfig.refresh();
                }
                if (rc.shouldInit()) {
                    if (rc.shouldReferAsync().booleanValue()) {
                        ExecutorService executor = this.executorRepository.getServiceReferExecutor();
                        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                            try {
                                this.referenceCache.get(rc);
                            }
                            catch (Throwable t) {
                                logger.error(this.getIdentifier() + " refer async catch error : " + t.getMessage(), t);
                            }
                        }, executor);
                        this.asyncReferringFutures.add(future);
                    } else {
                        this.referenceCache.get(rc);
                    }
                }
            }
            catch (Throwable t) {
                logger.error(this.getIdentifier() + " refer catch error", t);
                this.referenceCache.destroy(rc);
            }
        });
    }

    private void unreferServices() {
        try {
            this.asyncReferringFutures.forEach(future -> {
                if (!future.isDone()) {
                    future.cancel(true);
                }
            });
            this.asyncReferringFutures.clear();
            this.referenceCache.destroyAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void waitExportFinish() {
        try {
            logger.info(this.getIdentifier() + " waiting services exporting ...");
            CompletableFuture<Void> future = CompletableFuture.allOf(this.asyncExportingFutures.toArray(new CompletableFuture[0]));
            future.get();
        }
        catch (Exception e) {
            logger.warn(this.getIdentifier() + " export services occurred an exception.");
        }
        finally {
            this.executorRepository.shutdownServiceExportExecutor();
            logger.info(this.getIdentifier() + " export services finished.");
            this.asyncExportingFutures.clear();
        }
    }

    private void waitReferFinish() {
        try {
            logger.info(this.getIdentifier() + " waiting services referring ...");
            CompletableFuture<Void> future = CompletableFuture.allOf(this.asyncReferringFutures.toArray(new CompletableFuture[0]));
            future.get();
        }
        catch (Exception e) {
            logger.warn(this.getIdentifier() + " refer services occurred an exception.");
        }
        finally {
            this.executorRepository.shutdownServiceReferExecutor();
            logger.info(this.getIdentifier() + " refer services finished.");
            this.asyncReferringFutures.clear();
        }
    }

    @Override
    public boolean isAsync() {
        if (this.async == null) {
            this.async = this.isExportBackground() || this.isReferBackground();
        }
        return this.async;
    }

    private boolean isExportBackground() {
        return this.moduleModel.getConfigManager().getProviders().stream().map(ProviderConfig::getExportBackground).filter(k -> k != null && k != false).findAny().isPresent();
    }

    private boolean isReferBackground() {
        return this.moduleModel.getConfigManager().getConsumers().stream().map(ConsumerConfig::getReferBackground).filter(k -> k != null && k != false).findAny().isPresent();
    }

    private String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.moduleModel.getModelName() != null && !StringUtils.isEquals(this.moduleModel.getModelName(), this.moduleModel.getInternalName()) ? this.moduleModel.getModelName() + "[" + this.moduleModel.getInternalId() + "]" : "Dubbo Module[" + this.moduleModel.getInternalId() + "]";
        }
        return this.identifier;
    }

    @Override
    public ReferenceCache getReferenceCache() {
        return this.referenceCache;
    }

    @Override
    public void prepare() {
        this.applicationDeployer.initialize();
        this.initialize();
    }

    @Override
    public void notifyExportService(ServiceConfigBase<?> sc) {
        this.applicationDeployer.prepareApplicationInstance();
    }
}

