/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ServiceInstanceHostPortCustomizer
implements ServiceInstanceCustomizer {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInstanceHostPortCustomizer.class);

    @Override
    public void customize(ServiceInstance serviceInstance) {
        if (serviceInstance.getPort() > 0) {
            return;
        }
        WritableMetadataService writableMetadataService = WritableMetadataService.getDefaultExtension(serviceInstance.getApplicationModel());
        String host = null;
        int port = -1;
        Set<URL> urls = writableMetadataService.getExportedServiceURLs();
        if (CollectionUtils.isNotEmpty(urls)) {
            URL url;
            ApplicationModel applicationModel = serviceInstance.getApplicationModel();
            String preferredProtocol = applicationModel.getCurrentConfig().getProtocol();
            if (preferredProtocol != null) {
                for (URL exportedURL : urls) {
                    if (!preferredProtocol.equals(exportedURL.getProtocol())) continue;
                    host = exportedURL.getHost();
                    port = exportedURL.getPort();
                    break;
                }
                if (host == null || port == -1) {
                    logger.warn("The default preferredProtocol \"" + preferredProtocol + "\" is not found, fall back to the strategy that pick the first found protocol. Please try to modify the config of dubbo.application.protocol");
                    url = urls.iterator().next();
                    host = url.getHost();
                    port = url.getPort();
                }
            } else {
                url = urls.iterator().next();
                host = url.getHost();
                port = url.getPort();
            }
            if (serviceInstance instanceof DefaultServiceInstance) {
                DefaultServiceInstance instance = (DefaultServiceInstance)serviceInstance;
                instance.setHost(host);
                instance.setPort(port);
            }
        }
    }
}

