/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.PropertiesConfiguration;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.status.StatusChecker;
import org.apache.dubbo.common.status.reporter.FrameworkStatusReportService;
import org.apache.dubbo.common.threadpool.ThreadPool;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.monitor.MonitorFactory;
import org.apache.dubbo.monitor.MonitorService;
import org.apache.dubbo.registry.RegistryService;
import org.apache.dubbo.remoting.Codec2;
import org.apache.dubbo.remoting.Dispatcher;
import org.apache.dubbo.remoting.Transporter;
import org.apache.dubbo.remoting.exchange.Exchanger;
import org.apache.dubbo.remoting.telnet.TelnetHandler;
import org.apache.dubbo.rpc.ExporterListener;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.InvokerListener;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.support.MockInvoker;

public class ConfigValidationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigValidationUtils.class);
    private static final int MAX_LENGTH = 200;
    private static final int MAX_PATH_LENGTH = 200;
    private static final Pattern PATTERN_NAME = Pattern.compile("[\\-._0-9a-zA-Z]+");
    private static final Pattern PATTERN_MULTI_NAME = Pattern.compile("[,\\-._0-9a-zA-Z]+");
    private static final Pattern PATTERN_METHOD_NAME = Pattern.compile("[a-zA-Z][0-9a-zA-Z]*");
    private static final Pattern PATTERN_PATH = Pattern.compile("[/\\-$._0-9a-zA-Z]+");
    private static final Pattern PATTERN_NAME_HAS_SYMBOL = Pattern.compile("[:*,\\s/\\-._0-9a-zA-Z]+");
    private static final Pattern PATTERN_KEY = Pattern.compile("[*,\\-._0-9a-zA-Z]+");
    public static final String IPV6_START_MARK = "[";
    public static final String IPV6_END_MARK = "]";

    public static List<URL> loadRegistries(AbstractInterfaceConfig interfaceConfig, boolean provider) {
        ArrayList<URL> registryList = new ArrayList<URL>();
        ApplicationConfig application = interfaceConfig.getApplication();
        List<RegistryConfig> registries = interfaceConfig.getRegistries();
        if (CollectionUtils.isNotEmpty(registries)) {
            for (RegistryConfig config : registries) {
                String address = config.getAddress();
                if (StringUtils.isEmpty(address)) {
                    address = "0.0.0.0";
                }
                if ("N/A".equalsIgnoreCase(address)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                AbstractConfig.appendParameters(map, application);
                AbstractConfig.appendParameters(map, config);
                map.put("path", RegistryService.class.getName());
                AbstractInterfaceConfig.appendRuntimeParameters(map);
                if (!map.containsKey("protocol")) {
                    map.put("protocol", "dubbo");
                }
                List<URL> urls = UrlUtils.parseURLs(address, map);
                for (URL url : urls) {
                    url = URLBuilder.from(url).addParameter("registry", url.getProtocol()).setProtocol(ConfigValidationUtils.extractRegistryType(url)).setScopeModel(interfaceConfig.getScopeModel()).build();
                    if ((!provider || !url.getParameter("register", true)) && (provider || !url.getParameter("subscribe", true))) continue;
                    registryList.add(url);
                }
            }
        }
        return ConfigValidationUtils.genCompatibleRegistries(interfaceConfig.getScopeModel(), registryList, provider);
    }

    private static List<URL> genCompatibleRegistries(ScopeModel scopeModel, List<URL> registryList, boolean provider) {
        ArrayList<URL> result = new ArrayList<URL>(registryList.size());
        registryList.forEach(registryURL -> {
            if (provider) {
                String registerMode;
                if ("service-discovery-registry".equals(registryURL.getProtocol())) {
                    registerMode = registryURL.getParameter("register-mode", ConfigurationUtils.getCachedDynamicProperty(scopeModel, "dubbo.application.register-mode", "instance"));
                    if (!ConfigValidationUtils.isValidRegisterMode(registerMode)) {
                        registerMode = "instance";
                    }
                    result.add((URL)registryURL);
                    if ("all".equalsIgnoreCase(registerMode) && ConfigValidationUtils.registryNotExists(registryURL, registryList, "registry")) {
                        ServiceConfigURL interfaceCompatibleRegistryURL = URLBuilder.from(registryURL).setProtocol("registry").removeParameter("registry-type").build();
                        result.add(interfaceCompatibleRegistryURL);
                    }
                } else {
                    registerMode = registryURL.getParameter("register-mode", ConfigurationUtils.getCachedDynamicProperty(scopeModel, "dubbo.application.register-mode", "all"));
                    if (!ConfigValidationUtils.isValidRegisterMode(registerMode)) {
                        registerMode = "interface";
                    }
                    if (("instance".equalsIgnoreCase(registerMode) || "all".equalsIgnoreCase(registerMode)) && ConfigValidationUtils.registryNotExists(registryURL, registryList, "service-discovery-registry")) {
                        ServiceConfigURL serviceDiscoveryRegistryURL = URLBuilder.from(registryURL).setProtocol("service-discovery-registry").removeParameter("registry-type").build();
                        result.add(serviceDiscoveryRegistryURL);
                    }
                    if ("interface".equalsIgnoreCase(registerMode) || "all".equalsIgnoreCase(registerMode)) {
                        result.add((URL)registryURL);
                    }
                }
                FrameworkStatusReportService reportService = ScopeModelUtil.getApplicationModel(scopeModel).getBeanFactory().getBean(FrameworkStatusReportService.class);
                reportService.reportRegistrationStatus(reportService.createRegistrationReport(registerMode));
            } else {
                result.add((URL)registryURL);
            }
        });
        return result;
    }

    private static boolean isValidRegisterMode(String mode) {
        return StringUtils.isNotEmpty(mode) && ("interface".equalsIgnoreCase(mode) || "instance".equalsIgnoreCase(mode) || "all".equalsIgnoreCase(mode));
    }

    private static boolean registryNotExists(URL registryURL, List<URL> registryList, String registryType) {
        return registryList.stream().noneMatch(url -> registryType.equals(url.getProtocol()) && registryURL.getBackupAddress().equals(url.getBackupAddress()));
    }

    public static URL loadMonitor(AbstractInterfaceConfig interfaceConfig, URL registryURL) {
        String protocol;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("interface", MonitorService.class.getName());
        AbstractInterfaceConfig.appendRuntimeParameters(map);
        String hostToRegistry = ConfigUtils.getSystemProperty("DUBBO_IP_TO_REGISTRY");
        if (StringUtils.isEmpty(hostToRegistry)) {
            hostToRegistry = NetUtils.getLocalHost();
        } else if (NetUtils.isInvalidLocalHost(hostToRegistry)) {
            throw new IllegalArgumentException("Specified invalid registry ip from property:DUBBO_IP_TO_REGISTRY, value:" + hostToRegistry);
        }
        map.put("register.ip", hostToRegistry);
        MonitorConfig monitor = interfaceConfig.getMonitor();
        ApplicationConfig application = interfaceConfig.getApplication();
        AbstractConfig.appendParameters(map, monitor);
        AbstractConfig.appendParameters(map, application);
        String address = null;
        String sysAddress = System.getProperty("dubbo.monitor.address");
        if (sysAddress != null && sysAddress.length() > 0) {
            address = sysAddress;
        } else if (monitor != null) {
            address = monitor.getAddress();
        }
        String string = protocol = monitor == null ? null : monitor.getProtocol();
        if (monitor != null && ("registry".equals(protocol) || "service-discovery-registry".equals(protocol)) && registryURL != null) {
            return URLBuilder.from(registryURL).setProtocol("dubbo").addParameter("protocol", protocol).putAttribute("refer", map).build();
        }
        if (ConfigUtils.isNotEmpty(address) || ConfigUtils.isNotEmpty(protocol)) {
            if (!map.containsKey("protocol")) {
                if (interfaceConfig.getScopeModel().getExtensionLoader(MonitorFactory.class).hasExtension("logstat")) {
                    map.put("protocol", "logstat");
                } else if (ConfigUtils.isNotEmpty(protocol)) {
                    map.put("protocol", protocol);
                } else {
                    map.put("protocol", "dubbo");
                }
            }
            if (ConfigUtils.isEmpty(address)) {
                address = "127.0.0.1";
            }
            return UrlUtils.parseURL(address, map);
        }
        return null;
    }

    public static void checkMock(Class<?> interfaceClass, AbstractInterfaceConfig config) {
        String mock = config.getMock();
        if (ConfigUtils.isEmpty(mock)) {
            return;
        }
        String normalizedMock = MockInvoker.normalizeMock(mock);
        if (normalizedMock.startsWith("return ")) {
            normalizedMock = normalizedMock.substring("return ".length()).trim();
            try {
                MockInvoker.parseMockValue(normalizedMock);
            }
            catch (Exception e) {
                throw new IllegalStateException("Illegal mock return in <dubbo:service/reference ... mock=\"" + mock + "\" />");
            }
        } else if (normalizedMock.startsWith("throw")) {
            if (ConfigUtils.isNotEmpty(normalizedMock = normalizedMock.substring("throw".length()).trim())) {
                try {
                    MockInvoker.getThrowable(normalizedMock);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Illegal mock throw in <dubbo:service/reference ... mock=\"" + mock + "\" />");
                }
            }
        } else {
            MockInvoker.getMockObject(config.getScopeModel().getExtensionDirector(), normalizedMock, interfaceClass);
        }
    }

    public static void validateAbstractInterfaceConfig(AbstractInterfaceConfig config) {
        ConfigValidationUtils.checkName("local", config.getLocal());
        ConfigValidationUtils.checkName("stub", config.getStub());
        ConfigValidationUtils.checkMultiName("owner", config.getOwner());
        ConfigValidationUtils.checkExtension(config.getScopeModel(), ProxyFactory.class, "proxy", config.getProxy());
        ConfigValidationUtils.checkExtension(config.getScopeModel(), Cluster.class, "cluster", config.getCluster());
        ConfigValidationUtils.checkMultiExtension((ScopeModel)config.getScopeModel(), Arrays.asList(Filter.class, ClusterFilter.class), "filter", config.getFilter());
        ConfigValidationUtils.checkNameHasSymbol("layer", config.getLayer());
        List<MethodConfig> methods = config.getMethods();
        if (CollectionUtils.isNotEmpty(methods)) {
            methods.forEach(ConfigValidationUtils::validateMethodConfig);
        }
    }

    public static void validateServiceConfig(ServiceConfig config) {
        ProviderConfig providerConfig;
        List<ProtocolConfig> protocols;
        ConfigValidationUtils.checkKey("version", config.getVersion());
        ConfigValidationUtils.checkKey("group", config.getGroup());
        ConfigValidationUtils.checkName("token", config.getToken());
        ConfigValidationUtils.checkPathName("path", config.getPath());
        ConfigValidationUtils.checkMultiExtension((ScopeModel)config.getScopeModel(), ExporterListener.class, "listener", config.getListener());
        ConfigValidationUtils.validateAbstractInterfaceConfig(config);
        List<RegistryConfig> registries = config.getRegistries();
        if (registries != null) {
            for (RegistryConfig registryConfig : registries) {
                ConfigValidationUtils.validateRegistryConfig(registryConfig);
            }
        }
        if ((protocols = config.getProtocols()) != null) {
            for (ProtocolConfig protocol : protocols) {
                ConfigValidationUtils.validateProtocolConfig(protocol);
            }
        }
        if ((providerConfig = config.getProvider()) != null) {
            ConfigValidationUtils.validateProviderConfig(providerConfig);
        }
    }

    public static void validateReferenceConfig(ReferenceConfig config) {
        ConsumerConfig consumerConfig;
        ConfigValidationUtils.checkMultiExtension((ScopeModel)config.getScopeModel(), InvokerListener.class, "listener", config.getListener());
        ConfigValidationUtils.checkKey("version", config.getVersion());
        ConfigValidationUtils.checkKey("group", config.getGroup());
        ConfigValidationUtils.checkName("client", config.getClient());
        ConfigValidationUtils.validateAbstractInterfaceConfig(config);
        List<RegistryConfig> registries = config.getRegistries();
        if (registries != null) {
            for (RegistryConfig registry : registries) {
                ConfigValidationUtils.validateRegistryConfig(registry);
            }
        }
        if ((consumerConfig = config.getConsumer()) != null) {
            ConfigValidationUtils.validateConsumerConfig(consumerConfig);
        }
    }

    public static void validateConfigCenterConfig(ConfigCenterConfig config) {
        if (config != null) {
            ConfigValidationUtils.checkParameterName(config.getParameters());
        }
    }

    public static void validateApplicationConfig(ApplicationConfig config) {
        if (config == null) {
            return;
        }
        if (!config.isValid()) {
            throw new IllegalStateException("No application config found or it's not a valid config! Please add <dubbo:application name=\"...\" /> to your spring config.");
        }
        ScopeModel scopeModel = ScopeModelUtil.getOrDefaultApplicationModel(config.getScopeModel());
        PropertiesConfiguration configuration = scopeModel.getModelEnvironment().getPropertiesConfiguration();
        String wait = configuration.getProperty("dubbo.service.shutdown.wait");
        if (wait != null && wait.trim().length() > 0) {
            System.setProperty("dubbo.service.shutdown.wait", wait.trim());
        } else {
            wait = configuration.getProperty("dubbo.service.shutdown.wait.seconds");
            if (wait != null && wait.trim().length() > 0) {
                System.setProperty("dubbo.service.shutdown.wait.seconds", wait.trim());
            }
        }
        ConfigValidationUtils.checkName("name", config.getName());
        ConfigValidationUtils.checkMultiName("owner", config.getOwner());
        ConfigValidationUtils.checkName("organization", config.getOrganization());
        ConfigValidationUtils.checkName("architecture", config.getArchitecture());
        ConfigValidationUtils.checkName("environment", config.getEnvironment());
        ConfigValidationUtils.checkParameterName(config.getParameters());
    }

    public static void validateModuleConfig(ModuleConfig config) {
        if (config != null) {
            ConfigValidationUtils.checkName("name", config.getName());
            ConfigValidationUtils.checkName("owner", config.getOwner());
            ConfigValidationUtils.checkName("organization", config.getOrganization());
        }
    }

    public static void validateMetadataConfig(MetadataReportConfig metadataReportConfig) {
        if (metadataReportConfig == null) {
            return;
        }
    }

    public static void validateMetricsConfig(MetricsConfig metricsConfig) {
        if (metricsConfig == null) {
            return;
        }
    }

    public static void validateSslConfig(SslConfig sslConfig) {
        if (sslConfig == null) {
            return;
        }
    }

    public static void validateMonitorConfig(MonitorConfig config) {
        if (config != null) {
            if (!config.isValid()) {
                logger.info("There's no valid monitor config found, if you want to open monitor statistics for Dubbo, please make sure your monitor is configured properly.");
            }
            ConfigValidationUtils.checkParameterName(config.getParameters());
        }
    }

    public static void validateProtocolConfig(ProtocolConfig config) {
        if (config != null) {
            String name = config.getName();
            ConfigValidationUtils.checkName("name", name);
            ConfigValidationUtils.checkHost("host", config.getHost());
            ConfigValidationUtils.checkPathName("contextpath", config.getContextpath());
            if ("dubbo".equals(name)) {
                ConfigValidationUtils.checkMultiExtension(config.getScopeModel(), Codec2.class, "codec", config.getCodec());
                ConfigValidationUtils.checkMultiExtension(config.getScopeModel(), Serialization.class, "serialization", config.getSerialization());
                ConfigValidationUtils.checkMultiExtension(config.getScopeModel(), Transporter.class, "server", config.getServer());
                ConfigValidationUtils.checkMultiExtension(config.getScopeModel(), Transporter.class, "client", config.getClient());
            }
            ConfigValidationUtils.checkMultiExtension(config.getScopeModel(), TelnetHandler.class, "telnet", config.getTelnet());
            ConfigValidationUtils.checkMultiExtension(config.getScopeModel(), StatusChecker.class, "status", config.getStatus());
            ConfigValidationUtils.checkExtension(config.getScopeModel(), Transporter.class, "transporter", config.getTransporter());
            ConfigValidationUtils.checkExtension(config.getScopeModel(), Exchanger.class, "exchanger", config.getExchanger());
            ConfigValidationUtils.checkExtension(config.getScopeModel(), Dispatcher.class, "dispatcher", config.getDispatcher());
            ConfigValidationUtils.checkExtension(config.getScopeModel(), Dispatcher.class, "dispather", config.getDispather());
            ConfigValidationUtils.checkExtension(config.getScopeModel(), ThreadPool.class, "threadpool", config.getThreadpool());
        }
    }

    public static void validateProviderConfig(ProviderConfig config) {
        ConfigValidationUtils.checkPathName("contextpath", config.getContextpath());
        ConfigValidationUtils.checkExtension(config.getScopeModel(), ThreadPool.class, "threadpool", config.getThreadpool());
        ConfigValidationUtils.checkMultiExtension((ScopeModel)config.getScopeModel(), TelnetHandler.class, "telnet", config.getTelnet());
        ConfigValidationUtils.checkMultiExtension((ScopeModel)config.getScopeModel(), StatusChecker.class, "status", config.getStatus());
        ConfigValidationUtils.checkExtension(config.getScopeModel(), Transporter.class, "transporter", config.getTransporter());
        ConfigValidationUtils.checkExtension(config.getScopeModel(), Exchanger.class, "exchanger", config.getExchanger());
    }

    public static void validateConsumerConfig(ConsumerConfig config) {
        if (config == null) {
            return;
        }
    }

    public static void validateRegistryConfig(RegistryConfig config) {
        ConfigValidationUtils.checkName("protocol", config.getProtocol());
        ConfigValidationUtils.checkName("username", config.getUsername());
        ConfigValidationUtils.checkLength("password", config.getPassword());
        ConfigValidationUtils.checkPathLength("file", config.getFile());
        ConfigValidationUtils.checkName("transporter", config.getTransporter());
        ConfigValidationUtils.checkName("server", config.getServer());
        ConfigValidationUtils.checkName("client", config.getClient());
        ConfigValidationUtils.checkParameterName(config.getParameters());
    }

    public static void validateMethodConfig(MethodConfig config) {
        ConfigValidationUtils.checkExtension(config.getScopeModel(), LoadBalance.class, "loadbalance", config.getLoadbalance());
        ConfigValidationUtils.checkParameterName(config.getParameters());
        ConfigValidationUtils.checkMethodName("name", config.getName());
        String mock = config.getMock();
        if (StringUtils.isNotEmpty(mock)) {
            if (mock.startsWith("return ") || mock.startsWith("throw ")) {
                ConfigValidationUtils.checkLength("mock", mock);
            } else if (mock.startsWith("fail:") || mock.startsWith("force:")) {
                ConfigValidationUtils.checkNameHasSymbol("mock", mock);
            } else {
                ConfigValidationUtils.checkName("mock", mock);
            }
        }
    }

    private static String extractRegistryType(URL url) {
        return UrlUtils.hasServiceDiscoveryRegistryTypeKey(url) ? "service-discovery-registry" : ConfigValidationUtils.getRegistryProtocolType(url);
    }

    private static String getRegistryProtocolType(URL url) {
        String registryProtocol = url.getParameter("registry-protocol-type");
        return StringUtils.isNotEmpty(registryProtocol) ? registryProtocol : "registry";
    }

    public static void checkExtension(ScopeModel scopeModel, Class<?> type, String property, String value) {
        ConfigValidationUtils.checkName(property, value);
        if (StringUtils.isNotEmpty(value) && !scopeModel.getExtensionLoader(type).hasExtension(value)) {
            throw new IllegalStateException("No such extension " + value + " for " + property + "/" + type.getName());
        }
    }

    public static void checkMultiExtension(ScopeModel scopeModel, Class<?> type, String property, String value) {
        ConfigValidationUtils.checkMultiExtension(scopeModel, Collections.singletonList(type), property, value);
    }

    public static void checkMultiExtension(ScopeModel scopeModel, List<Class<?>> types, String property, String value) {
        ConfigValidationUtils.checkMultiName(property, value);
        if (StringUtils.isNotEmpty(value)) {
            String[] values;
            for (String v : values = value.split("\\s*[,]+\\s*")) {
                if (v.startsWith("-")) {
                    v = v.substring(1);
                }
                if ("default".equals(v)) continue;
                boolean match = false;
                for (Class<?> type : types) {
                    if (!scopeModel.getExtensionLoader(type).hasExtension(v)) continue;
                    match = true;
                }
                if (match) continue;
                throw new IllegalStateException("No such extension " + v + " for " + property + "/" + types.stream().map(Class::getName).collect(Collectors.joining(",")));
            }
        }
    }

    public static void checkLength(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, null);
    }

    public static void checkPathLength(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, null);
    }

    public static void checkName(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, PATTERN_NAME);
    }

    public static void checkHost(String property, String value) {
        if (StringUtils.isEmpty(value)) {
            return;
        }
        if (value.startsWith(IPV6_START_MARK) && value.endsWith(IPV6_END_MARK)) {
            try {
                InetAddress.getByName(value);
                return;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        ConfigValidationUtils.checkName(property, value);
    }

    public static void checkNameHasSymbol(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, PATTERN_NAME_HAS_SYMBOL);
    }

    public static void checkKey(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, PATTERN_KEY);
    }

    public static void checkMultiName(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, PATTERN_MULTI_NAME);
    }

    public static void checkPathName(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, PATTERN_PATH);
    }

    public static void checkMethodName(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, PATTERN_METHOD_NAME);
    }

    public static void checkParameterName(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return;
        }
        ArrayList<String> ignoreCheckKeys = new ArrayList<String>();
        ignoreCheckKeys.add("backup");
        String ignoreCheckKeysStr = parameters.get("ignoreCheckKeys");
        if (!StringUtils.isBlank(ignoreCheckKeysStr)) {
            ignoreCheckKeys.addAll(Arrays.asList(ignoreCheckKeysStr.split(",")));
        }
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (ignoreCheckKeys.contains(entry.getKey())) continue;
            ConfigValidationUtils.checkNameHasSymbol(entry.getKey(), entry.getValue());
        }
    }

    public static void checkProperty(String property, String value, int maxlength, Pattern pattern) {
        Matcher matcher;
        if (StringUtils.isEmpty(value)) {
            return;
        }
        if (value.length() > maxlength) {
            logger.error("Invalid " + property + "=\"" + value + "\" is longer than " + maxlength);
        }
        if (pattern != null && !(matcher = pattern.matcher(value)).matches()) {
            logger.error("Invalid " + property + "=\"" + value + "\" contains illegal character, only digit, letter, '-', '_' or '.' is legal.");
        }
    }
}

