/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.legacy;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.telnet.TelnetHandler;
import org.apache.dubbo.remoting.telnet.support.Help;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.protocol.dubbo.DubboProtocol;

@Activate
@Help(parameter="[service]", summary="Change default service.", detail="Change default service.")
public class ChangeTelnetHandler
implements TelnetHandler {
    public static final String SERVICE_KEY = "telnet.service";

    @Override
    public String telnet(Channel channel, String message) {
        if (message == null || message.length() == 0) {
            return "Please input service name, eg: \r\ncd XxxService\r\ncd com.xxx.XxxService";
        }
        StringBuilder buf = new StringBuilder();
        if ("/".equals(message) || "..".equals(message)) {
            String service = (String)channel.getAttribute(SERVICE_KEY);
            channel.removeAttribute(SERVICE_KEY);
            buf.append("Cancelled default service ").append(service).append('.');
        } else {
            boolean found = false;
            for (Exporter<?> exporter : DubboProtocol.getDubboProtocol().getExporters()) {
                if (!message.equals(exporter.getInvoker().getInterface().getSimpleName()) && !message.equals(exporter.getInvoker().getInterface().getName()) && !message.equals(exporter.getInvoker().getUrl().getPath())) continue;
                found = true;
                break;
            }
            if (found) {
                channel.setAttribute(SERVICE_KEY, message);
                buf.append("Used the ").append(message).append(" as default.\r\nYou can cancel default service by command: cd /");
            } else {
                buf.append("No such service ").append(message);
            }
        }
        return buf.toString();
    }
}

