/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigItem;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.AbstractServiceNameMapping;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.registry.client.RegistryClusterIdentifier;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetadataServiceNameMapping
extends AbstractServiceNameMapping {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final List<String> IGNORED_SERVICE_INTERFACES = Collections.singletonList(MetadataService.class.getName());
    private static final int CAS_RETRY_TIMES = 6;
    protected MetadataReportInstance metadataReportInstance;

    public MetadataServiceNameMapping(ApplicationModel applicationModel) {
        this.metadataReportInstance = applicationModel.getBeanFactory().getBean(MetadataReportInstance.class);
    }

    @Override
    public boolean map(URL url) {
        ConfigItem configItem;
        String appName;
        if (CollectionUtils.isEmpty(this.applicationModel.getApplicationConfigManager().getMetadataConfigs())) {
            return false;
        }
        String serviceInterface = url.getServiceInterface();
        if (IGNORED_SERVICE_INTERFACES.contains(serviceInterface)) {
            return false;
        }
        String registryCluster = this.getRegistryCluster(url);
        MetadataReport metadataReport = this.metadataReportInstance.getMetadataReport(registryCluster);
        if (metadataReport.registerServiceAppMapping(serviceInterface, appName = this.applicationModel.getApplicationName(), url)) {
            return true;
        }
        int currentRetryTimes = 1;
        boolean succeeded = false;
        String newConfigContent = appName;
        do {
            String oldConfigContent;
            if (!StringUtils.isNotEmpty(oldConfigContent = (configItem = metadataReport.getConfigItem(serviceInterface, "mapping")).getContent())) continue;
            boolean contains = StringUtils.isContains(oldConfigContent, appName);
            if (contains) {
                succeeded = true;
                break;
            }
            newConfigContent = oldConfigContent + "," + appName;
        } while (!(succeeded = metadataReport.registerServiceAppMapping(serviceInterface, "mapping", newConfigContent, configItem.getTicket())) && currentRetryTimes++ <= 6);
        if (!succeeded) {
            throw new RuntimeException();
        }
        return true;
    }

    @Override
    public Set<String> get(URL url) {
        String serviceInterface = url.getServiceInterface();
        String registryCluster = this.getRegistryCluster(url);
        MetadataReport metadataReport = this.metadataReportInstance.getMetadataReport(registryCluster);
        return metadataReport.getServiceAppMapping(serviceInterface, url);
    }

    @Override
    public Set<String> getAndListen(URL url, MappingListener mappingListener) {
        String serviceInterface = url.getServiceInterface();
        String registryCluster = this.getRegistryCluster(url);
        MetadataReport metadataReport = this.metadataReportInstance.getMetadataReport(registryCluster);
        return metadataReport.getServiceAppMapping(serviceInterface, mappingListener, url);
    }

    protected String getRegistryCluster(URL url) {
        int i;
        String registryCluster = RegistryClusterIdentifier.getExtension(url).providerKey(url);
        if (registryCluster == null) {
            registryCluster = "default";
        }
        if ((i = registryCluster.indexOf(",")) > 0) {
            registryCluster = registryCluster.substring(0, i);
        }
        return registryCluster;
    }
}

