/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.MetadataServiceURLBuilder;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.store.RemoteMetadataServiceImpl;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class MetadataUtils {
    public static ConcurrentMap<String, MetadataService> metadataServiceProxies = new ConcurrentHashMap<String, MetadataService>();
    public static ConcurrentMap<String, Invoker<?>> metadataServiceInvokers = new ConcurrentHashMap();

    public static RemoteMetadataServiceImpl getRemoteMetadataService(ScopeModel scopeModel) {
        return scopeModel.getBeanFactory().getBean(RemoteMetadataServiceImpl.class);
    }

    public static void publishServiceDefinition(URL url) {
        WritableMetadataService.getDefaultExtension(url.getScopeModel()).publishServiceDefinition(url);
        if ("remote".equalsIgnoreCase(url.getParameter("metadata-type"))) {
            MetadataUtils.getRemoteMetadataService(url.getOrDefaultApplicationModel()).publishServiceDefinition(url);
        }
    }

    public static String computeKey(ServiceInstance serviceInstance) {
        return serviceInstance.getServiceName() + "##" + serviceInstance.getAddress() + "##" + ServiceInstanceMetadataUtils.getExportedServicesRevision(serviceInstance);
    }

    public static synchronized MetadataService getMetadataServiceProxy(ServiceInstance instance) {
        return metadataServiceProxies.computeIfAbsent(MetadataUtils.computeKey(instance), k -> MetadataUtils.referProxy(k, instance));
    }

    public static synchronized void destroyMetadataServiceProxy(ServiceInstance instance) {
        String key = MetadataUtils.computeKey(instance);
        if (metadataServiceProxies.containsKey(key)) {
            metadataServiceProxies.remove(key);
            Invoker invoker = (Invoker)metadataServiceInvokers.remove(key);
            invoker.destroy();
        }
    }

    private static MetadataService referProxy(String key, ServiceInstance instance) {
        ExtensionLoader<MetadataServiceURLBuilder> loader = instance.getOrDefaultApplicationModel().getExtensionLoader(MetadataServiceURLBuilder.class);
        Map<String, String> metadata = instance.getMetadata();
        String dubboUrlsForJson = metadata.get("dubbo.metadata-service.urls");
        MetadataServiceURLBuilder builder = metadata.isEmpty() || StringUtils.isEmpty(dubboUrlsForJson) ? loader.getExtension("standard") : loader.getExtension("spring-cloud");
        List<URL> urls = builder.build(instance);
        if (CollectionUtils.isEmpty(urls)) {
            throw new IllegalStateException("Introspection service discovery mode is enabled " + instance + ", but no metadata service can build from it.");
        }
        ScopeModel scopeModel = ScopeModelUtil.getOrDefaultApplicationModel(instance.getApplicationModel());
        Protocol protocol = scopeModel.getExtensionLoader(Protocol.class).getAdaptiveExtension();
        Invoker<MetadataService> invoker = protocol.refer(MetadataService.class, urls.get(0));
        metadataServiceInvokers.put(key, invoker);
        ProxyFactory proxyFactory = scopeModel.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
        return proxyFactory.getProxy(invoker);
    }

    public static ConcurrentMap<String, MetadataService> getMetadataServiceProxies() {
        return metadataServiceProxies;
    }

    public static ConcurrentMap<String, Invoker<?>> getMetadataServiceInvokers() {
        return metadataServiceInvokers;
    }
}

